unit gridpnl;

// By Tom Lee , Republic Of China
// E-Mail Address : tom@libra.aaa.hinet.net
// Home Page : http://www.aaa.hinet.net/delphi
// AUG 30 1996
// Ver 1.00
// Freeware 32 Bit Delphi Component

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TGridPanel = class(TPanel)
  private
    { Private declarations }
    FGridX:integer;
    FGridY:integer;
    FShowGrid:Boolean;
    FDotColor:TColor;
    procedure SetGridX (value:integer);
    procedure SetGridY (value:integer);
    procedure SetShowGrid (value:Boolean);
    procedure SetDotColor (value:TColor);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure Paint; override;
  published
    { Published declarations }
    property GridX:integer Read FGridX write SetGridX Default 8;
    property GridY:integer Read FGridY write SetGridY Default 8;
    property DotColor:TColor Read FDotColor write SetDotColor Default clBlack;
    property ShowGrid:Boolean Read FShowGrid write SetShowGrid Default True;
  end;

procedure Register;

implementation

procedure TGridPanel.SetDotColor(value:TColor);
begin
     if value<>FDotColor then
     begin
          FDotColor:=value;
          if FShowGrid Then invalidate;
     end;
end;

procedure TGridPanel.SetShowGrid(value:Boolean);
begin
     if value<>FShowGrid then
     begin
          FShowGrid:=value;
          invalidate;
     end;
end;

procedure TGridPanel.SetGridX(value:integer);
begin
     if value<>FGridX then
     begin
          FGridX:=value;
          if FShowGrid Then invalidate;
     end;
end;

procedure TGridPanel.SetGridY(value:integer);
begin
     if value<>FGridY then
     begin
          FGridY:=value;
          if FShowGrid Then invalidate;
     end;
end;

constructor TGridPanel.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     FShowGrid:=True;
     FDotColor:=clBlack;
     FGridX:=8;
     FGridY:=8;
end;

Procedure TGridPanel.Paint;
var
   idxX,idxY:integer;
begin
     inherited;
     if FShowGrid then
     begin
          with Canvas do
          begin
               idxX:=1;
               while idxX < Width do
               begin
                    idxY:=1;
                    while idxY < height do
                    begin
                         Pixels[idxX,idxY]:=FDotColor;
                         inc(idxY,FGridY);
                    end;
                    inc(idxX,FGridX);
               end;
         end;
     end;
end;


procedure Register;
begin
  RegisterComponents('Standard', [TGridPanel]);
end;

end.
