unit Sample1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtPage, StdCtrls;

{$R SAMPLE1.RES}                   // Bitmaps in Ressource   

type
  TForm1 = class(TForm)
    ExtPageControl1: TExtPageControl;
    Page1: TTabSheet;
    Page2: TTabSheet;
    Page3: TTabSheet;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure ExtPageControl1DrawTab(Control: TWinControl; Index: Integer;
      ActiveTab: Boolean; Rect: TRect; State: TOwnerDrawState);
  private
    { Private-Deklarationen }
    bm: Array[0..2] of TBitmap;    // Bitmaps on the tabs
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// creation of the form
procedure TForm1.FormCreate(Sender: TObject);
begin
  // create all Bitmaps
  bm[0]:= TBitmap.Create;
  bm[0].Handle:= LoadBitmap(hInstance, 'TAB0');
  bm[1]:= TBitmap.Create;
  bm[1].Handle:= LoadBitmap(hInstance, 'TAB1');
  bm[2]:= TBitmap.Create;
  bm[2].Handle:= LoadBitmap(hInstance, 'TAB2');
end;

// here we paint the tabs ourself (OnwerDraw)
procedure TForm1.ExtPageControl1DrawTab(Control: TWinControl;
  Index: Integer; ActiveTab: Boolean; Rect: TRect; State: TOwnerDrawState);
VAR
  R1, R2: TRect;
begin
  with ExtPageControl1 do begin
    // first we draw the bitmap
    R1.Left:= 10;
    R1.Top:= (Rect.Bottom - bm[Index].Height) div 2;
    R1.Right:= R1.Left + bm[Index].Width;
    R1.Bottom:= R1.Top + bm[Index].Height;
    SetRect(R2, 0, 0, bm[Index].Width, bm[Index].Height);
    Canvas.BrushCopy(R1, bm[Index], R2, bm[Index].TransparentColor);

    // and now we draw the text
    inc(Rect.Left, bm[Index].Width + 15);
    Canvas.Brush.Style:= bsClear;
    DrawText(Canvas.Handle, PChar(Pages[Index].Caption), -1,
             Rect, DT_LEFT or DT_VCENTER or DT_SINGLELINE);
  end;
end;

end.
