{
 Author:       Craig Ward
 Copyright:    <>

 Date:         19/5/96

 Version:      1.0

 Overview:     Remove Collection dialog.

*******************************************************************************}
unit Remcoll;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Cwlist, Cwbutton, ExtCtrls, iniFiles, config, sysutils,
  messages, dialogs;

type
  TRemCollectDlg = class(TForm)
    Bevel1: TBevel;
    cwButton1: TcwButton;
    cwButton2: TcwButton;
    cwListBox1: TcwListBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    procedure cwButton1Click(Sender: TObject);
    procedure cwButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure ReadColls;
    procedure WriteColls;
  public
    { Public declarations }
  end;

var
  RemCollectDlg: TRemCollectDlg;

implementation

{$R *.DFM}

uses
 cw_apps,conini;

{***buttons*********************************************************************}

{ok}
procedure TRemCollectDlg.cwButton1Click(Sender: TObject);
begin
 WriteColls;
 modalResult := mrOK;
end;

{cancel}
procedure TRemCollectDlg.cwButton2Click(Sender: TObject);
begin
 modalResult := mrCancel;
end;

{delete collection}
procedure TRemCollectDlg.SpeedButton1Click(Sender: TObject);
begin
 cwListBox1.deleteSelected;
end;

{refresh}
procedure TRemCollectDlg.SpeedButton2Click(Sender: TObject);
begin
 cwListBox1.clear;
 ReadColls;
end;


{***ini************************************************************************}

{read collections from list}
procedure TRemCollectDlg.ReadColls;
var
 i: integer;
begin
 for i := 0 to (ScreenSaveDialog.FCollections.count -1) do
  begin
   with ScreenSaveDialog do
    cwListBox1.items.add( copy( FCollections.strings[i],pos('=',FCollections.strings[i])+1,gintMaxCollName));
  end;
end;

{write collections to ini}
procedure TRemCollectDlg.WriteColls;
var
 inf: TIniFile;
 iInx,iInc: integer;
 s: string[gintMaxCollName];
 tmpList: TStringList;
 pBuf: pChar;
begin
 tmpList := TStringList.create;
 inf := TIniFile.create(ExtractFilePath(paramStr(0))+'delphiss.ini');
 try
  {amend string-list in memory}
  with ScreenSaveDialog do
   begin
    tmpList.addStrings(FCollections);
    for iInc := 0 to (FCollections.count -1) do
     begin
      {read sample text from string-list}
      s := copy( FCollections.strings[iInc],pos('=',FCollections.strings[iInc])+1,gintMaxCollName);
      {iterate through list-box}
      if cwListBox1.items.indexOf(s) = -1 then
       if tmpList.Find(FCollections.strings[iInc],iInx) then
        tmpList.delete(iInx);
     end;
  {write to ini}
   pBuf := StrAlloc(fsMaxFullFileName);
   try
    StrPCopy(pBuf,ExtractFilePath(paramStr(0))+'delphiss.ini');
    WritePrivateProfileString('COLLECTIONS',nil,nil,pBuf);
   finally
    StrDispose(pBuf);
   end;
  {***}
  if tmpList.count > 0 then
  for iInc := 0 to (tmpList.count -1) do
   begin
    end;
    inf.WriteString('COLLECTIONS',
                  copy(tmpList.strings[iInc],1,pos('=',tmpList.strings[iInc])-1),
                  copy( tmpList.strings[iInc],pos('=',tmpList.strings[iInc])+1,gintMaxCollName) );
    end;
 finally
  inf.free;
  tmpList.free;
 end;
end;


{***form's preferences*********************************************************}

{on create}
procedure TRemCollectDlg.FormCreate(Sender: TObject);
begin
 ReadColls;
end;

{}
end.
