unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, About, Search,
  RHCtrl3d, RHTabBox, RHLstHdr, RHLBoxCk, RHGrhBtn, RHClrBtn, RHBmpBtn;

type
  TfrmMain = class(TForm)
    Label3D1: TrhLabel3D;
    Panel1: TPanel;
    Label3D5: TrhLabel3D;
    BitmapButton2: TrhBitmapButton;
    BitmapButton1: TrhBitmapButton;
    Panel2: TPanel;
    Label3D2: TrhLabel3D;
    TabComboBox1: TrhTabComboBox;
    Label3D3: TrhLabel3D;
    CheckListBox1: TrhCheckListBox;
    TabListHeader1: TrhTabListHeader;
    TabListBox1: TrhTabListBox;
    Label3D4: TrhLabel3D;
    txtCustomer: TEdit;
    Label3D7: TrhLabel3D;
    BitmapButton3: TrhBitmapButton;
    btnClose: TrhButton3D;
    btnOrder: TrhButton3D;
    btnAbout: TrhButton3D;
    Label3D6: TrhLabel3D;
    txtQty: TEdit;
    btnSearch: TrhButton3D;
    procedure btnAboutClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure TabComboBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnSearchClick(Sender: TObject);
    procedure btnOrderClick(Sender: TObject);
    procedure TabListBox1Click(Sender: TObject);

  private
    FCurItem : Integer;
  public
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  frmAboutBox.ShowModal;
end;

procedure TfrmMain.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.TabComboBox1Click(Sender: TObject);
begin
  CheckListBox1.Clear;

  Case StrToInt(TabComboBox1.ColText[3]) of
  1 : begin
      CheckListBox1.Items.Add('Cabin reservation');
      CheckListBox1.Items.Add('Book "The Story of Lake Fishing with Bob Kingfisher"');
      CheckListBox1.Items.Add('Book "History of Northern Minnesota"');
      CheckListBox1.Items.Add('Natural''s Callings (tapes)');
      CheckListBox1.Items.Add('Bird watching tour');
      CheckListBox1.Items.Add('Tour of north woods lodge');
    end;
    2 : begin
      CheckListBox1.Items.Add('Tent and Related Equipment Rental');
      CheckListBox1.Items.Add('Book "The History of Isle Royal"');
      CheckListBox1.Items.Add('Explore the Flora and Fauna of the Island (hike)');
      CheckListBox1.Items.Add('Five day backpacking trip around the island');
      CheckListBox1.Items.Add('Diving Isle Royal; Learn from the Experts');
      CheckListBox1.Items.Add('Canoe the lakes; see the Moose (2-day outing)');
    end;
  end;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  TabComboBox1.ItemIndex := 0;
  FCurItem := -1;
end;

procedure TfrmMain.btnSearchClick(Sender: TObject);
begin
  frmSearch.ShowModal;
  txtCustomer.Text := frmSearch.Customer;
end;

procedure TfrmMain.btnOrderClick(Sender: TObject);
var
  i : Integer;
  S : String;

begin
  if FCurItem >= 0 then begin
    S := TabListBox1.RowText[FCurItem, 0];
    TabListBox1.Items.Delete(FCurItem);
    TabListBox1.Items.Insert(FCurItem, S + TAB + txtQty.Text);
    FCurItem := -1;
    TabListBox1.ItemIndex := FCurItem;
  end

  else begin
    for i := 0 to CheckListBox1.Items.Count - 1 do
      if CheckListBox1.Selected[i] then begin
        TabListBox1.Items.Add(CheckListBox1.Items[i] + TAB + txtQty.Text);
        CheckListBox1.Selected[i] := False;
      end;
  end;
end;

procedure TfrmMain.TabListBox1Click(Sender: TObject);
begin
  if (TabListBox1.ItemIndex >= 0) then begin
    FCurItem := TabListBox1.ItemIndex;
    txtQty.Text := TabListBox1.ColText[1];
  end;
end;

end.
