unit Button;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons,
  RHCtrl3d, RHGrhBtn, RHClrBtn, RHBmpBtn;

type
  TfrmButtons = class(TForm)
    BitBtn1: TBitBtn;
    GroupBox1: TGroupBox;
    Button3D1: TrhButton3D;
    Button3D4: TrhButton3D;
    Button3D2: TrhButton3D;
    Button3D5: TrhButton3D;
    Button3D3: TrhButton3D;
    Button3D6: TrhButton3D;
    GroupBox2: TGroupBox;
    Button3: TrhColoredButton;
    Button4: TrhColoredButton;
    Button5: TrhColoredButton;
    Button1: TrhColoredButton;
    Button2: TrhColoredButton;
    Button6: TrhColoredButton;
    GroupBox3: TGroupBox;
    BitmapButton2: TrhBitmapButton;
    BitmapButton1: TrhBitmapButton;
    GroupBox4: TGroupBox;
    GraphicButton1: TrhGraphicButton;
    GraphicButton2: TrhGraphicButton;
    CheckBox1: TCheckBox;
    procedure GraphicButton1DrawFace(Sender: TObject; IsDown, IsDefault,
      IsFocused, IsNewStyle: Boolean; Canvas: TCanvas; Rect: TRect);
    procedure GraphicButton2DrawFace(Sender: TObject; IsDown, IsDefault,
      IsFocused, IsNewStyle: Boolean; Canvas: TCanvas; Rect: TRect);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmButtons: TfrmButtons;

implementation

{$R *.DFM}

procedure TfrmButtons.GraphicButton1DrawFace(Sender: TObject; IsDown,
  IsDefault, IsFocused, IsNewStyle: Boolean; Canvas: TCanvas; Rect: TRect);
begin
  if IsDown then
    Canvas.Pen.Color := clRed
  else if IsFocused then
    Canvas.Pen.Color := clYellow
  else
    Canvas.Pen.Color := clWhite;

  Canvas.Brush.Color := clBlack;
  Canvas.FrameRect(Rect);

  Canvas.MoveTo(Rect.Left+1, Rect.Top+1);
  Canvas.LineTo(Rect.Right-1, Rect.Bottom-1);
  Canvas.MoveTo(Rect.Left+1, Rect.Bottom-2);
  Canvas.LineTo(Rect.Right-1, Rect.Top);
end;

procedure TfrmButtons.GraphicButton2DrawFace(Sender: TObject; IsDown,
  IsDefault, IsFocused, IsNewStyle: Boolean; Canvas: TCanvas; Rect: TRect);
begin
  if IsDown then
    InflateRect(Rect, -8, -8)
  else if IsFocused then
    InflateRect(Rect, -5, -5)
  else
    InflateRect(Rect, -2, -2);

  Canvas.Ellipse(Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
end;

procedure TfrmButtons.CheckBox1Click(Sender: TObject);
begin
  BitmapButton2.Enabled := CheckBox1.Checked;
end;

end.
