unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs ,Oleauto,
  StdCtrls, Grids;

Const
   dbOpenDynaset=2;
   dbOpenSnapshot=4;
   dbOpenTable=1;
type
  TfrmMain = class(TForm)
    cmdOpen: TButton;
    grdData: TStringGrid;
    cmdTable: TButton;
    cmdClose: TButton;
    cmdSnapshot: TButton;
    cmdExecSQL: TButton;
    txtNewTitle: TEdit;
    lblTitle: TLabel;
    procedure cmdOpenClick(Sender: TObject);
    procedure cmdTableClick(Sender: TObject);
    procedure cmdCloseClick(Sender: TObject);
    procedure cmdSnapshotClick(Sender: TObject);
    procedure cmdExecSQLClick(Sender: TObject);
  private
    { Private declarations }
    Procedure ClearGrid;
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;
  dbEngine:Variant;
  db:Variant;
  tb:Variant;
  sp:Variant;

implementation

{$R *.DFM}

Procedure TfrmMain.ClearGrid;
begin
   try
        with grdData do
        begin
             RowCount:=0;
             RowCount:=tb.RecordCount+1;
             FixedRows:=1;
             Cells[0,0]:= 'Title';
             Cells[1,0]:= 'Year Published';
             Cells[2,0]:= 'ISBN';
             Cells[3,0]:= 'PubID';
        end;
   except
        MessageDlg('Database Not Open!',mtInformation,[mbOk],0);
   end;
end;

procedure TfrmMain.cmdOpenClick(Sender: TObject);
begin
   try
        dbEngine:=CreateOleObject('DAO.DBEngine');
        db:=dbEngine.OpenDatabase('BIBLIO.MDB');
        tb:=db.OpenRecordSet('Titles',dbOpenTable);
   except
         MessageDlg('Connect Jet Engine Automation Server Error!',mtInformation,[mbOk],0);
   end;
end;

procedure TfrmMain.cmdTableClick(Sender: TObject);
var
   RowCnt:Integer;
begin
   try
        ClearGrid;
        tb.MoveFirst;
        RowCnt:=1;
        while tb.EOF=0 Do
        begin
             with grdData Do
             begin
                  Cells[0,RowCnt]:= tb.Fields['Title'];
                  Cells[1,RowCnt]:= tb.Fields['Year Published'];
                  Cells[2,RowCnt]:= tb.Fields['ISBN'];
                  Cells[3,RowCnt]:= tb.Fields['PubID'];
             end;
             Inc(RowCnt);
             tb.MoveNext;
        end
    except
        MessageDlg('Read Table Data Error!',mtInformation,[mbOk],0);
   end;
end;

procedure TfrmMain.cmdCloseClick(Sender: TObject);
begin
   try
        tb.close;
        db.close;
    except
   end;
end;

procedure TfrmMain.cmdSnapshotClick(Sender: TObject);
var
   RowCnt:Integer;
begin
   ClearGrid;
   try
        RowCnt:=1;
        sp:=db.OpenRecordSet('Select * From Titles Where Title Like "*SQL*"',dbOpenSnapshot);
        while sp.EOF=0 Do
        begin
             with grdData Do
             begin
                  Cells[0,RowCnt]:= sp.Fields['Title'];
                  Cells[1,RowCnt]:= sp.Fields['Year Published'];
                  Cells[2,RowCnt]:= sp.Fields['ISBN'];
                  Cells[3,RowCnt]:= sp.Fields['PubID'];
             end;
             Inc(RowCnt);
             sp.MoveNext;
        end;
        sp.Close;
    except
        MessageDlg('Read Snapshot Data Error!',mtInformation,[mbOk],0);
   end;
end;

procedure TfrmMain.cmdExecSQLClick(Sender: TObject);
var
   RowCnt:Integer;
begin
   try
        db.Execute('Update Titles Set Title = "'+txtNewTitle.Text+'" Where PubId = 2 ');
    except
        MessageDlg('Execute SQL Error!',mtInformation,[mbOk],0);
   end;
end;

end.
