//**************************************************************************
//
// Sample3D - Shows the use of CTL3D.DLL
//
// Yes it is really this easy.
//
//
//**************************************************************************

#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include "ctl3d.h"

HINSTANCE _hInstance ;
HWND hwndApp;

#ifndef WIN32
#define	TEXT(a) a
#define TCHAR char
#endif


TCHAR szFilterSpec [128] =						 // file type filters
             TEXT("Text Files (*.TXT)\0*.TXT\0All Files (*.*)\0*.*\0");

TCHAR szFileName[120];

BOOL FAR PASCAL OpenHook(HWND hwnd, int wm, int wParam, long lParam)
{
    switch (wm) {
    case WM_INITDIALOG:
            // We must call this to subclass the directory listbox even
            // if the app calls Ctl3dAutoSubclass (commdlg bug)
			// Ctl3dSubclassDlg(hwnd, CTL3D_ALL);
        break;
    }
    return FALSE;
}


void FileOpen(HWND hwndOwner)
{
    OPENFILENAME ofn;

    /* fill in non-variant fields of OPENFILENAME struct. */
    ofn.lStructSize       = sizeof(OPENFILENAME);
    ofn.hwndOwner     = hwndOwner;
    ofn.lpstrFilter   = szFilterSpec;
    ofn.lpstrCustomFilter = NULL;
    ofn.nMaxCustFilter    = 0;
    ofn.nFilterIndex      = 1;
    ofn.lpstrFile         = szFileName;
    ofn.nMaxFile      = 120;
    ofn.lpstrInitialDir   = NULL;
    ofn.lpstrFileTitle    = NULL;
    ofn.nMaxFileTitle     = 120;
    ofn.lpstrTitle        = TEXT("3D Look");
    ofn.lpstrDefExt       = TEXT("TXT");
	// ofn.Flags = OFN_HIDEREADONLY | OFN_ENABLEHOOK;
	ofn.Flags = OFN_HIDEREADONLY;
	// ofn.lpfnHook = (FARPROC)MakeProcInstance(OpenHook, _hInstance);
	ofn.lpfnHook = NULL;
    ofn.lCustData = 0;
    ofn.lpTemplateName = 0;

    GetOpenFileName ((LPOPENFILENAME)&ofn);
    FreeProcInstance(ofn.lpfnHook);
}


//
// Dialog Procedure
//
BOOL FAR PASCAL DialogProc(HWND hdlg, UINT wm, WPARAM wParam, LPARAM lParam)
{
    switch(wm) {
        case WM_SYSCOLORCHANGE:
           Ctl3dColorChange();
           break;
                                        
        //
        // Remove the comments from the next block of code to
        // stop the dialog border form being drawn with 3D effects
        //                                
        // case WM_DLGBORDER:
        //      *(int FAR *)lParam = CTL3D_NOBORDER;
        //   return TRUE;
           
        //
        // Remove the comments from the next block of code to
        // stop subclassing the controls on this dialog
        //                                
        // case WM_DLGSUBCLASS:
        //   *(int FAR *)lParam = CTL3D_NOSUBCLASS;
        ///   return TRUE;

        case WM_COMMAND: {
               
               WORD wCommandID;
#ifdef WIN32
               wCommandID = LOWORD(wParam);
#else
               wCommandID = wParam;
#endif
                              
               if (wCommandID == IDOK) {
                   EndDialog(hdlg, TRUE);
               }
               else if (wCommandID == 130 ) {
                   MessageBox(hdlg, TEXT("This is a sample Message Box"),TEXT("3D Look"), MB_OK);
               }
               else if (wCommandID == 131 ) {
                   FileOpen(hdlg);
              }
            }
            break;
            
        default:
            return FALSE;

    }

    return TRUE;
}




int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
   FARPROC lpproc;

   _hInstance = hInstance;

   Ctl3dRegister(_hInstance);
   Ctl3dAutoSubclass(_hInstance);

   lpproc = MakeProcInstance((FARPROC) DialogProc, _hInstance);
   DialogBox(_hInstance, MAKEINTRESOURCE(100), NULL, lpproc);
   FreeProcInstance(lpproc);

   Ctl3dUnregister(_hInstance);
   return 0;
}
