// {$R Calculator.JFM}

//          I partially copied some of codes from following reference.
//          
//
//          - Copyright notice for Example reference -
//
//            Gary Cornell and Cay S. Horstmann, Core Java (Book/CD-ROM)
//            Published By SunSoft Press/Prentice-Hall
//            Copyright (C) 1996 Sun Microsystems Inc.
//            All Rights Reserved. ISBN 0-13-565755-5

import java.awt.*;
import java.applet.Applet;

// Class Calculator
public class Calculator extends Applet
{
    final int MenuBarHeight = 0;

    public double arg = 0;
    public String op = "=";
    public boolean start = true;

    // Component Declaration
    public TextField display;
    public Panel Panel1;
    public Button Button1;
    public Button Button2;
    public Button Button3;
    public Button Button4;
    public Button Button5;
    public Button Button6;
    public Button Button7;
    public Button Button8;
    public Button Button9;
    public Button Button10;
    public Button Button11;
    public Button Button12;
    public Button Button13;
    public Button Button14;
    public Button Button15;
    public Button Button16;
    // End of Component Declaration

    // init()
    public void init()
    {
        // Frame Initialization
        setForeground(Color.black);
        setBackground(Color.lightGray);
        setFont(new Font("Dialog",Font.BOLD,12));
        setLayout(null);
        // End of Frame Initialization

        // Component Initialization
        display = new TextField("0");
        display.setForeground(Color.black);
        display.setBackground(Color.lightGray);
        display.setFont(new Font("Dialog",Font.BOLD,12));
        display.setEditable(false);
        Panel1 = new Panel();
        Panel1.setLayout(null);
        Panel1.setForeground(Color.black);
        Panel1.setBackground(Color.lightGray);
        Panel1.setFont(new Font("Dialog",Font.BOLD,12));
        Button1 = new Button("1");
        Button1.setFont(new Font("Dialog",Font.BOLD,12));
        Button2 = new Button("2");
        Button2.setFont(new Font("Dialog",Font.BOLD,12));
        Button3 = new Button("3");
        Button3.setFont(new Font("Dialog",Font.BOLD,12));
        Button4 = new Button("4");
        Button4.setFont(new Font("Dialog",Font.BOLD,12));
        Button5 = new Button("5");
        Button5.setFont(new Font("Dialog",Font.BOLD,12));
        Button6 = new Button("6");
        Button6.setFont(new Font("Dialog",Font.BOLD,12));
        Button7 = new Button("7");
        Button7.setFont(new Font("Dialog",Font.BOLD,12));
        Button8 = new Button("8");
        Button8.setFont(new Font("Dialog",Font.BOLD,12));
        Button9 = new Button("9");
        Button9.setFont(new Font("Dialog",Font.BOLD,12));
        Button10 = new Button("0");
        Button10.setFont(new Font("Dialog",Font.BOLD,12));
        Button11 = new Button(".");
        Button11.setFont(new Font("Dialog",Font.BOLD,12));
        Button12 = new Button("=");
        Button12.setFont(new Font("Dialog",Font.BOLD,12));
        Button13 = new Button("+");
        Button13.setFont(new Font("Dialog",Font.BOLD,12));
        Button14 = new Button("-");
        Button14.setFont(new Font("Dialog",Font.BOLD,12));
        Button15 = new Button("*");
        Button15.setFont(new Font("Dialog",Font.BOLD,12));
        Button16 = new Button("/");
        Button16.setFont(new Font("Dialog",Font.BOLD,12));
        // End of Component Initialization

        // Add()s
        Panel1.add(Button16);
        Panel1.add(Button15);
        Panel1.add(Button14);
        Panel1.add(Button13);
        Panel1.add(Button12);
        Panel1.add(Button11);
        Panel1.add(Button10);
        Panel1.add(Button9);
        Panel1.add(Button8);
        Panel1.add(Button7);
        Panel1.add(Button6);
        Panel1.add(Button5);
        Panel1.add(Button4);
        Panel1.add(Button3);
        Panel1.add(Button2);
        Panel1.add(Button1);
        add(Panel1);
        add(display);
        // End of Add()s

        InitialPositionSet();
    } // End of init()

    // start()
    public void start()
    {
    } // End of start()

    // stop()
    public void stop()
    {
    } // End of stop()

    // destroy()
    public void destroy()
    {
    } // End of destroy()

    public void paint(Graphics g)
    {
        // paint()
        // End of paint()
    }

    public void InitialPositionSet()
    {
        // InitialPositionSet()
        resize(193,217);
        display.reshape(8,4+MenuBarHeight,179,24);
        Panel1.reshape(7,34+MenuBarHeight,179,177);
        Button1.reshape(9,8,40,40);
        Button2.reshape(49,8,40,40);
        Button3.reshape(89,8,40,40);
        Button4.reshape(129,8,40,40);
        Button5.reshape(9,48,40,40);
        Button6.reshape(49,48,40,40);
        Button7.reshape(89,48,40,40);
        Button8.reshape(129,48,40,40);
        Button9.reshape(9,88,40,40);
        Button10.reshape(49,88,40,40);
        Button11.reshape(89,88,40,40);
        Button12.reshape(129,88,40,40);
        Button13.reshape(9,128,40,40);
        Button14.reshape(49,128,40,40);
        Button15.reshape(89,128,40,40);
        Button16.reshape(129,128,40,40);
        // End of InitialPositionSet()
    }

    public boolean handleEvent(Event evt)
    {
        // handleEvent()
        if (evt.id == Event.WINDOW_DESTROY && evt.target == this) Calculator_WindowDestroy(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button1) Button1_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button11) Button1_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button2) Button1_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button3) Button1_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button4) Button1_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button5) Button1_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button6) Button1_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button7) Button1_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button8) Button1_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button9) Button1_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button10) Button1_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button14) Button14_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button13) Button13_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button15) Button13_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button16) Button13_Action(evt.target);
        else if (evt.id == Event.ACTION_EVENT && evt.target == Button12) Button13_Action(evt.target);
        // End of handleEvent()

        return super.handleEvent(evt);
    }

    // Event Handling Routines
    public void Calculator_WindowDestroy(Object target)
    {
        System.exit(0);
    }

    public void Button1_Action(Object target)
    {
        String str;
         
        str = ((Button)(target)).getLabel();
        
        if (start) display.setText(str);
        else display.setText(display.getText() + str);

        start = false;
    }

    public void Button14_Action(Object target)
    {
        String str;
        
        str = ((Button)(target)).getLabel();
    
        if (start)
        { 
            display.setText(str); 
            start = false; 
        }
        else
        {  
            calculate(atof(display.getText()));
            op = str;
            start = true;
        }
     
    }

    public void Button13_Action(Object target)
    {
        String str;
        
        str = ((Button)(target)).getLabel();
    
        if (start) op = str;
        else
        {  
            calculate(atof(display.getText()));
            op = str;
            start = true;
        }
    }

    // End of Event Handling Routines

    public void calculate(double n)
    {  
        if (op == "+") arg += n;
        else if (op == "-") arg -= n;
        else if (op == "*") arg *= n;
        else if (op == "/") arg /= n;
        else if (op == "%") arg %= n;
        else if (op == "=") arg = n;
        display.setText("" + arg);
   }
   
    public double atof(String s)
    {  
       int i = 0;
       int sign = 1;
       double r = 0; // integer part
       double f = 0; // fractional part
       double p = 1; // exponent of fractional part
       int state = 0; // 0 = int part, 1 = frac part
      
       while (i < s.length() && Character.isSpace(s.charAt(i))) i++;
       if (i < s.length() && s.charAt(i) == '-') { sign = -1; i++; }
       else if (i < s.length() && s.charAt(i) == '+') { i++; }
       while (i < s.length())
       {  
           char ch = s.charAt(i);
           if ('0' <= ch && ch <= '9')
           {  
               if (state == 0) r = r * 10 + ch - '0';
               else if (state == 1)
               {  
                   p = p / 10;
                   r = r + p * (ch - '0');
               }
           }
           else if (ch == '.') 
           {  
               if (state == 0) state = 1; 
               else return sign * r;
           }
           else if (ch == 'e' || ch == 'E')
           {  
               long e = (int)parseLong(s.substring(i + 1), 10);
               return sign * r * Math.pow(10, e);
           }
           else return sign * r;
           i++;
       }
       return sign * r;
    }

    public long parseLong(String s, int base)
    {  
        int i = 0;
        int sign = 1;
        long r = 0;
      
      while (i < s.length() && Character.isSpace(s.charAt(i))) i++;
      if (i < s.length() && s.charAt(i) == '-') { sign = -1; i++; }
      else if (i < s.length() && s.charAt(i) == '+') { i++; }
      while (i < s.length())
      {  char ch = s.charAt(i);
         if ('0' <= ch && ch < '0' + base)
            r = r * base + ch - '0';
         else if ('A' <= ch && ch < 'A' + base - 10)
            r = r * base + ch - 'A' + 10 ;
         else if ('a' <= ch && ch < 'a' + base - 10)
            r = r * base + ch - 'a' + 10 ;
         else 
            return r * sign;
         i++;
      }
      return r * sign;      
   }

   
} // End of Class Calculator

