/* rs485.c
**
** Windows 95/98 console mode application for RS485 port.
** Uses RTS to enable RS485 transmit driver.
** Cannot run under NT.
*/

#include <windows.h>
#include <stdio.h>
#include <string.h>

#include "wsc.h"

char Temp[80];
int Port;
int Baud;
 
/* return TRUE if user typed key */

int KeyPress(HANDLE Handle)
{DWORD NbrRead;
 INPUT_RECORD InputEvent;
 PeekConsoleInput(Handle,&InputEvent,1,&NbrRead);
 if(NbrRead==0) return FALSE;
 if( (InputEvent.EventType!=KEY_EVENT) ||
     (InputEvent.Event.KeyEvent.bKeyDown==FALSE) ||
     (InputEvent.Event.KeyEvent.uChar.AsciiChar==0) )
   {/* trash this event */
    ReadConsoleInput(Handle, &InputEvent, 1, &NbrRead);
    return FALSE;
   }
 /* character ready to read */
 return TRUE;
}

/* get input character */

char GetChar(HANDLE Handle)
{char TheChar;
 DWORD  BytesRead;
 ReadFile(Handle, &TheChar, 1, &BytesRead, 0);
 return TheChar;
}

/* write character to console */

void PutChar(HANDLE Handle, char TheChar)
{DWORD BytesWritten;
 WriteFile(Handle, &TheChar, 1, &BytesWritten, 0);
}

/* write string to console */

void PutString(HANDLE Handle, char *TheString)
{DWORD BytesWritten;
 WriteFile(Handle, TheString, strlen(TheString), &BytesWritten, 0);
}

/* trap WSC error codes */

int ErrorCheck(int Code)
{if(Code<0)
   {printf("ERROR %d ",Code);
    SioDone(Port);
    exit(1);
   }
 return Code;
}

/* display error & exit */

void SayError(char *Msg)
{printf("ERROR: %s: %d\n", Msg, GetLastError() );
 exit(1);
}

/* wait for last bit of last character to be transmitted */

void Wait4TxDone(int Port)
{int Code;
 while(1)
   {Code = SioRead(Port, 5);
    if((0x60&Code)==0x60) break;
    Sleep(0);
   }
}

/*** main ***/

void main(int argc, char *argv[])
{char c;
 int  n;
 HANDLE ConIn;
 HANDLE ConOut;
 DWORD OldMode;
 DWORD NewMode;
 BOOL  Success;
 static char Buffer[128];
 static char *Alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n";
 /* process args */
 if(argc!=3)
   {printf("Usage: RS485 <port> <baud>\n");
    return;
   }
 Port = atoi(argv[1]) - 1;
 Baud = atoi(argv[2]);
 /* get handles for stdin & stdout */
 ConIn  = GetStdHandle(STD_INPUT_HANDLE);
 ConOut = GetStdHandle(STD_OUTPUT_HANDLE);
 if(ConIn==ConOut) SayError("Console Handles");
 /* modify console mode: disable line input & line echo */
 Success = GetConsoleMode(ConIn, &OldMode);
 if(!Success) SayError("GetConsoleMode");
 NewMode = OldMode & ~ENABLE_LINE_INPUT & ~ENABLE_ECHO_INPUT;
 Success = SetConsoleMode(ConIn, NewMode);
 if(!Success) SayError("SetConsoleMode");
 /* reset the port */
 ErrorCheck( SioReset(Port,1024,1024) );
 ErrorCheck( SioBaud(Port,Baud) );
 /* set DTR */
 ErrorCheck( SioDTR(Port,'S') );
 PutString(ConOut,"\nEnter terminal loop ( Type ^Z to exit )\n");
 /* enter terminal loop */
 while(TRUE)
   {/* was key pressed ? */
    if(KeyPress(ConIn))
      {/* fetch character */
       c = GetChar(ConIn);
       if(c==0x1a)
         {/* restore COM port status & exit */
          SioDone(Port);
          SetConsoleMode(ConIn, OldMode);
          exit(1);
         }
       else if(c=='#')
         {/* set RTS */
          SioRTS(Port,'S');
          /* transmit alphabet plus CR/LF */
          SioPuts(Port,Alpha,28);
          /* wait till TX queue is empty */
          if(SioTxQue(Port)>1) SioEvent(Port, EV_TXEMPTY);
          /* wait for last bit of last character to be transmitted */
          Wait4TxDone(Port);
          Sleep(0);       
          /* drop RTS */
          SioRTS(Port,'C');
         }       
       else
         {/* set RTS */
          SioRTS(Port,'S');
          /* transmit character */
          SioPutc(Port,c);
          /* wait for last bit of last character to be transmitted */
          Wait4TxDone(Port);
          /* drop RTS */
          SioRTS(Port,'C');
         }
      } /* end if(KeyPress) */
    /* any incoming over serial port ? */
    n = SioGets(Port,Buffer,127);
    if(n>0) 
      {Buffer[n] = '\0';
       PutString(ConOut,Buffer);
      } 
   } /* end-while(TRUE) */
} /* end main */

