/***************************************************************************\
*                                                                           *
*   WINDIALO.H                                                              *
*                                                                           *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_WINDIALO_H)
#define _WINDIALO_H

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(RC_INVOKED)
#define IsDialogMessage TFUNCT(IsDialogMessage)
BOOL WINAPI IsDialogMessage(HWND hDlg, LPMSG lpMsg);
#define SendDlgItemMessage TFUNCT(SendDlgItemMessage)
LONG WINAPI SendDlgItemMessage(HWND hDlg, int nIDDlgItem, 
	UINT Msg, WPARAM wParam, LPARAM lParam);
#endif

#define BM_GETCHECK		0x00F0
#define BM_SETCHECK		0x00F1
#define BM_GETSTATE		0x00F2
#define BM_SETSTATE		0x00F3
#define BM_SETSTYLE		0x00F4
#define BM_CLICK		0x00F5
#define BM_GETIMAGE		0x00F6
#define BM_SETIMAGE		0x00F7

#define BN_CLICKED		0
#define BN_PAINT       		1
#define BN_HILITE           	2
#define BN_PUSHED           	BN_HILITE
#define BN_UNHILITE         	3
#define BN_UNPUSHED         	BN_UNHILITE
#define BN_DISABLE          	4
#define BN_DOUBLECLICKED    5
#define BN_DBLCLK           	BN_DOUBLECLICKED
#define BN_SETFOCUS         	6
#define BN_KILLFOCUS        	7

#define BS_PUSHBUTTON       0x00000000L
#define BS_DEFPUSHBUTTON    0x00000001L
#define BS_CHECKBOX         0x00000002L
#define BS_AUTOCHECKBOX     0x00000003L
#define BS_RADIOBUTTON      0x00000004L
#define BS_3STATE           0x00000005L
#define BS_AUTO3STATE       0x00000006L
#define BS_GROUPBOX         0x00000007L
#define BS_USERBUTTON       0x00000008L
#define BS_AUTORADIOBUTTON  0x00000009L
#define BS_OWNERDRAW        0x0000000BL
#define BS_LEFTTEXT         0x00000020L
#define BS_TEXT             0x00000000L
#define BS_ICON             0x00000040L
#define BS_BITMAP           0x00000080L
#define BS_LEFT             0x00000100L
#define BS_RIGHT            0x00000200L
#define BS_CENTER           0x00000300L
#define BS_TOP              0x00000400L
#define BS_BOTTOM           0x00000800L
#define BS_VCENTER          0x00000C00L
#define BS_PUSHLIKE         0x00001000L
#define BS_MULTILINE        0x00002000L
#define BS_NOTIFY           0x00004000L
#define BS_FLAT             0x00008000L
#define BS_RIGHTBUTTON      BS_LEFTTEXT

#define BST_UNCHECKED	0x0000
#define BST_CHECKED		0x0001
#define BST_INDETERMINATE	0x0002
#define BST_PUSHED		0x0004
#define BST_FOCUS		0x0008

#define CB_OKAY             0
#define CB_ERR              (-1)
#define CB_ERRSPACE         (-2)
#define CB_GETEDITSEL               0x0140
#define CB_LIMITTEXT                0x0141
#define CB_SETEDITSEL               0x0142
#define CB_ADDSTRING                0x0143
#define CB_DELETESTRING             0x0144
#define CB_DIR                      0x0145
#define CB_GETCOUNT                 0x0146
#define CB_GETCURSEL                0x0147
#define CB_GETLBTEXT                0x0148
#define CB_GETLBTEXTLEN             0x0149
#define CB_INSERTSTRING             0x014A
#define CB_RESETCONTENT             0x014B
#define CB_FINDSTRING               0x014C
#define CB_SELECTSTRING             0x014D
#define CB_SETCURSEL                0x014E
#define CB_SHOWDROPDOWN             0x014F
#define CB_GETITEMDATA              0x0150
#define CB_SETITEMDATA              0x0151
#define CB_GETDROPPEDCONTROLRECT    0x0152
#define CB_SETITEMHEIGHT            0x0153
#define CB_GETITEMHEIGHT            0x0154
#define CB_SETEXTENDEDUI            0x0155
#define CB_GETEXTENDEDUI            0x0156
#define CB_GETDROPPEDSTATE          0x0157
#define CB_FINDSTRINGEXACT          0x0158
#define CB_SETLOCALE                0x0159
#define CB_GETLOCALE                0x015A
#define CB_GETTOPINDEX              0x015b
#define CB_SETTOPINDEX              0x015c
#define CB_GETHORIZONTALEXTENT      0x015d
#define CB_SETHORIZONTALEXTENT      0x015e
#define CB_GETDROPPEDWIDTH          0x015f
#define CB_SETDROPPEDWIDTH          0x0160
#define CB_INITSTORAGE              0x0161
#define CB_MSGMAX                   0x0162

#define CBN_ERRSPACE        (-1)
#define CBN_SELCHANGE       1
#define CBN_DBLCLK          2
#define CBN_SETFOCUS        3
#define CBN_KILLFOCUS       4
#define CBN_EDITCHANGE      5
#define CBN_EDITUPDATE      6
#define CBN_DROPDOWN        7
#define CBN_CLOSEUP         8
#define CBN_SELENDOK        9
#define CBN_SELENDCANCEL    10

#define CBS_SIMPLE            0x0001L
#define CBS_DROPDOWN          0x0002L
#define CBS_DROPDOWNLIST      0x0003L
#define CBS_OWNERDRAWFIXED    0x0010L
#define CBS_OWNERDRAWVARIABLE 0x0020L
#define CBS_AUTOHSCROLL       0x0040L
#define CBS_OEMCONVERT        0x0080L
#define CBS_SORT              0x0100L
#define CBS_HASSTRINGS        0x0200L
#define CBS_NOINTEGRALHEIGHT  0x0400L
#define CBS_DISABLENOSCROLL   0x0800L
#define CBS_UPPERCASE           0x2000L
#define CBS_LOWERCASE           0x4000L

#define CTLCOLOR_MSGBOX         0
#define CTLCOLOR_EDIT           1
#define CTLCOLOR_LISTBOX        2
#define CTLCOLOR_BTN            3
#define CTLCOLOR_DLG            4
#define CTLCOLOR_SCROLLBAR      5
#define CTLCOLOR_STATIC         6
#define CTLCOLOR_MAX            7

#define COLOR_SCROLLBAR         0
#define COLOR_BACKGROUND        1
#define COLOR_ACTIVECAPTION     2
#define COLOR_INACTIVECAPTION   3
#define COLOR_MENU              4
#define COLOR_WINDOW            5
#define COLOR_WINDOWFRAME       6
#define COLOR_MENUTEXT          7
#define COLOR_WINDOWTEXT        8
#define COLOR_CAPTIONTEXT       9
#define COLOR_ACTIVEBORDER      10
#define COLOR_INACTIVEBORDER    11
#define COLOR_APPWORKSPACE      12
#define COLOR_HIGHLIGHT         13
#define COLOR_HIGHLIGHTTEXT     14
#define COLOR_BTNFACE           15
#define COLOR_BTNSHADOW         16
#define COLOR_GRAYTEXT          17
#define COLOR_BTNTEXT           18
#define COLOR_INACTIVECAPTIONTEXT 19
#define COLOR_BTNHIGHLIGHT      20
#define COLOR_3DDKSHADOW        21
#define COLOR_3DLIGHT           22
#define COLOR_INFOTEXT          23
#define COLOR_INFOBK            24
#define COLOR_DESKTOP           COLOR_BACKGROUND
#define COLOR_3DFACE            COLOR_BTNFACE
#define COLOR_3DSHADOW          COLOR_BTNSHADOW
#define COLOR_3DHIGHLIGHT       COLOR_BTNHIGHLIGHT
#define COLOR_3DHILIGHT         COLOR_BTNHIGHLIGHT
#define COLOR_BTNHILIGHT        COLOR_BTNHIGHLIGHT

#if !defined(RC_INVOKED)
DWORD WINAPI GetSysColor(int nIndex);
HBRUSH WINAPI GetSysColorBrush(int nIndex);
BOOL WINAPI SetSysColors(int cElements, CONST INT *lpaElements,
	CONST COLORREF *lpaRgbValues);
#endif

#define DC_HASDEFID         0x534B

#define DDL_READWRITE       0x0000
#define DDL_READONLY        0x0001
#define DDL_HIDDEN          0x0002
#define DDL_SYSTEM          0x0004
#define DDL_DIRECTORY       0x0010
#define DDL_ARCHIVE         0x0020
#define DDL_POSTMSGS        0x2000
#define DDL_DRIVES          0x4000
#define DDL_EXCLUSIVE       0x8000

#if !defined(RC_INVOKED)
#define DlgDirList TFUNCT(DlgDirList)
int WINAPI DlgDirList(HWND hDlg, LPTSTR lpPathSpec,
	int nIDListBox, int nIDStaticPath, UINT uFileType);
#define DlgDirSelectEx TFUNCT(DlgDirSelectEx)
BOOL WINAPI DlgDirSelectEx(HWND hDlg, LPTSTR lpString,
	int nCount, int nIDListBox);
#define DlgDirSelectComboBox TFUNCT(DlgDirSelectComboBox)
int WINAPI DlgDirListComboBox(HWND hDlg, LPTSTR lpPathSpec, 
	int nIDComboBox, int nIDStaticPath, UINT uFiletype);
#define DlgDirSelectComboBoxEx TFUNCT(DlgDirSelectComboBoxEx)
BOOL WINAPI DlgDirSelectComboBoxEx(HWND hDlg, LPTSTR lpString, 
	int nCount, int nIDComboBox);

#define DI_MASK         0x0001
#define DI_IMAGE        0x0002
#define DI_NORMAL       0x0003
#define DI_COMPAT       0x0004
#define DI_DEFAULTSIZE  0x0008

BOOL WINAPI DrawIconEx(HDC hdc, int xLeft, int yTop,
	HICON hIcon, int cxWidth, int cyWidth,
	UINT istepIfAniCur, HBRUSH hbrFlickerFreeDraw, UINT diFlags);
#endif

#define DLGC_WANTARROWS		0x0001
#define DLGC_WANTTAB        		0x0002
#define DLGC_WANTALLKEYS    	0x0004
#define DLGC_WANTMESSAGE    	0x0004
#define DLGC_HASSETSEL      		0x0008
#define DLGC_DEFPUSHBUTTON  	0x0010
#define DLGC_UNDEFPUSHBUTTON 	0x0020
#define DLGC_RADIOBUTTON    	0x0040
#define DLGC_WANTCHARS      		0x0080
#define DLGC_STATIC         		0x0100
#define DLGC_BUTTON         		0x2000

#define DM_GETDEFID         (WM_USER+0)
#define DM_SETDEFID         (WM_USER+1)
#define DM_REPOSITION       (WM_USER+2)

#define DS_ABSALIGN		0x01L
#define DS_SYSMODAL		0x02L
#define DS_LOCALEDIT		0x20L
#define DS_SETFONT		0x40L
#define DS_MODALFRAME	0x80L
#define DS_NOIDLEMSG	0x100L
#define DS_SETFOREGROUND	0x200L
#define DS_3DLOOK           	0x0004L
#define DS_FIXEDSYS         	0x0008L
#define DS_NOFAILCREATE     	0x0010L
#define DS_CONTROL          	0x0400L
#define DS_CENTER           	0x0800L
#define DS_CENTERMOUSE      	0x1000L
#define DS_CONTEXTHELP      	0x2000L

#define DT_TOP              0x00000000
#define DT_LEFT             0x00000000
#define DT_CENTER           0x00000001
#define DT_RIGHT            0x00000002
#define DT_VCENTER          0x00000004
#define DT_BOTTOM           0x00000008
#define DT_WORDBREAK        0x00000010
#define DT_SINGLELINE       0x00000020
#define DT_EXPANDTABS       0x00000040
#define DT_TABSTOP          0x00000080
#define DT_NOCLIP           0x00000100
#define DT_EXTERNALLEADING  0x00000200
#define DT_CALCRECT         0x00000400
#define DT_NOPREFIX         0x00000800
#define DT_INTERNAL         0x00001000
#define DT_EDITCONTROL      0x00002000
#define DT_PATH_ELLIPSIS    0x00004000
#define DT_END_ELLIPSIS     0x00008000
#define DT_MODIFYSTRING     0x00010000
#define DT_RTLREADING       0x00020000
#define DT_WORD_ELLIPSIS    0x00040000

#if !defined(RC_INVOKED)
#define DrawText TFUNCT(DrawText)
int WINAPI DrawText(HDC hDC, LPCTSTR lpString, int, LPRECT , UINT);

typedef struct {
    UINT    cbSize;
    int     iTabLength;
    int     iLeftMargin;
    int     iRightMargin;
    UINT    uiLengthDrawn;
} DRAWTEXTPARAMS, *LPDRAWTEXTPARAMS;

#define DrawTextEx TFUNCT(DrawTextEx)
int WINAPI DrawTextEx(HDC, LPTSTR, int, LPRECT, UINT, LPDRAWTEXTPARAMS);
#endif

#define DWL_MSGRESULT   0
#define DWL_DLGPROC     4
#define DWL_USER        8

#define ESB_ENABLE_BOTH	0x0000
#define ESB_DISABLE_BOTH	0x0003
#define ESB_DISABLE_LEFT	0x0001
#define ESB_DISABLE_RIGHT	0x0002
#define ESB_DISABLE_UP	0x0001
#define ESB_DISABLE_DOWN	0x0002
#define ESB_DISABLE_LTUP	ESB_DISABLE_LEFT
#define ESB_DISABLE_RTDN	ESB_DISABLE_RIGHT

#if !defined(RC_INVOKED)
BOOL WINAPI EnableScrollBar(HWND hWnd, UINT wSBflags, UINT wArrows);
#endif

#define EC_LEFTMARGIN       	0x0001
#define EC_RIGHTMARGIN      	0x0002
#define EC_USEFONTINFO      	0xffff

#define EM_GETSEL              	0x00B0
#define EM_SETSEL               	0x00B1
#define EM_GETRECT           	0x00B2
#define EM_SETRECT            	0x00B3
#define EM_SETRECTNP       	0x00B4
#define EM_SCROLL              	0x00B5
#define EM_LINESCROLL  	0x00B6
#define EM_SCROLLCARET	0x00B7
#define EM_GETMODIFY	0x00B8
#define EM_SETMODIFY 	0x00B9
#define EM_GETLINECOUNT	0x00BA
#define EM_LINEINDEX            	0x00BB
#define EM_SETHANDLE            	0x00BC
#define EM_GETHANDLE            	0x00BD
#define EM_GETTHUMB             	0x00BE
#define EM_LINELENGTH           	0x00C1
#define EM_REPLACESEL           	0x00C2
#define EM_GETLINE              	0x00C4
#define EM_LIMITTEXT            	0x00C5
#define EM_SETLIMITTEXT         EM_LIMITTEXT 
#define EM_CANUNDO              	0x00C6
#define EM_UNDO                 	0x00C7
#define EM_FMTLINES             	0x00C8
#define EM_LINEFROMCHAR     0x00C9
#define EM_SETTABSTOPS          0x00CB
#define EM_SETPASSWORDCHAR      	0x00CC
#define EM_EMPTYUNDOBUFFER      	0x00CD
#define EM_GETFIRSTVISIBLELINE 	 0x00CE
#define EM_SETREADONLY          	0x00CF
#define EM_SETWORDBREAKPROC     	0x00D0
#define EM_GETWORDBREAKPROC     	0x00D1
#define EM_GETPASSWORDCHAR      	0x00D2
#define EM_SETMARGINS      	0x00D3
#define EM_GETMARGINS           0x00D4
#define EM_GETLIMITTEXT         0x00D5
#define EM_POSFROMCHAR       0x00D6
#define EM_CHARFROMPOS       0x00D7

#define EN_SETFOCUS		0x0100
#define EN_KILLFOCUS        	0x0200
#define EN_CHANGE           	0x0300
#define EN_UPDATE           	0x0400
#define EN_ERRSPACE         	0x0500
#define EN_MAXTEXT          	0x0501
#define EN_HSCROLL          	0x0601
#define EN_VSCROLL          	0x0602

#define ES_LEFT             0x0000L
#define ES_CENTER           0x0001L
#define ES_RIGHT            0x0002L
#define ES_MULTILINE        0x0004L
#define ES_UPPERCASE        0x0008L
#define ES_LOWERCASE        0x0010L
#define ES_PASSWORD         0x0020L
#define ES_AUTOVSCROLL      0x0040L
#define ES_AUTOHSCROLL      0x0080L
#define ES_NOHIDESEL        0x0100L
#define ES_OEMCONVERT       0x0400L
#define ES_READONLY         0x0800L
#define ES_WANTRETURN       0x1000L
#define ES_NUMBER           0x2000L

#define IDOK           	1
#define IDCANCEL           2
#define IDABORT             3
#define IDRETRY             4
#define IDIGNORE           5
#define IDYES               	6
#define IDNO                	7
#define IDCLOSE         	8
#define IDHELP          	9

#define IDC_ARROW           MAKEINTRESOURCE(32512)
#define IDC_IBEAM           MAKEINTRESOURCE(32513)
#define IDC_WAIT            MAKEINTRESOURCE(32514)
#define IDC_CROSS           MAKEINTRESOURCE(32515)
#define IDC_UPARROW         MAKEINTRESOURCE(32516)
#define IDC_SIZE            MAKEINTRESOURCE(32640)
#define IDC_ICON            MAKEINTRESOURCE(32641)
#define IDC_SIZENWSE        MAKEINTRESOURCE(32642)
#define IDC_SIZENESW        MAKEINTRESOURCE(32643)
#define IDC_SIZEWE          MAKEINTRESOURCE(32644)
#define IDC_SIZENS          MAKEINTRESOURCE(32645)
#define IDC_SIZEALL         MAKEINTRESOURCE(32646)
#define IDC_NO              MAKEINTRESOURCE(32648)
#define IDC_APPSTARTING     MAKEINTRESOURCE(32650)
#define IDC_HELP            MAKEINTRESOURCE(32651)

#if !defined(RC_INVOKED)
typedef struct {
    int     xHotSpot;
    int     yHotSpot;
    int     cx;
    int     cy;
    int     cbWidth;
    BYTE    Planes;
    BYTE    BitsPixel;
} CURSORSHAPE, *LPCURSORSHAPE;

HCURSOR WINAPI CreateCursor(HINSTANCE hInst, int xHotSpot, int yHotSpot,
	int nWidth, int nHeight, CONST VOID *pvANDPlane, CONST VOID *pvXORPlane);
BOOL WINAPI DestroyCursor(HCURSOR hCursor);
#define CopyCursor(pcur) ((HCURSOR)CopyIcon((HICON)(pcur)))
BOOL WINAPI SetSystemCursor(HCURSOR hcur, DWORD id);
#endif

#define IDI_APPLICATION     MAKEINTRESOURCE(32512)
#define IDI_HAND            MAKEINTRESOURCE(32513)
#define IDI_QUESTION        MAKEINTRESOURCE(32514)
#define IDI_EXCLAMATION     MAKEINTRESOURCE(32515)
#define IDI_ASTERISK        MAKEINTRESOURCE(32516)
#define IDI_WINLOGO         MAKEINTRESOURCE(32517)

#if !defined(RC_INVOKED)
typedef struct {
    BOOL    fIcon;
    DWORD   xHotspot;
    DWORD   yHotspot;
    HBITMAP hbmMask;
    HBITMAP hbmColor;
} ICONINFO, *PICONINFO;

HICON WINAPI CreateIcon(HINSTANCE hInstance, int nWidth, int nHeight,
	BYTE cPlanes, BYTE cBitsPixel, CONST BYTE *lpbANDbits,
	CONST BYTE *lpbXORbits);
BOOL WINAPI DestroyIcon(HICON hIcon);
int WINAPI LookupIconIdFromDirectory(PBYTE presbits, BOOL fIcon);
int WINAPI LookupIconIdFromDirectoryEx(PBYTE presbits, BOOL  fIcon,
	int cxDesired, int cyDesired, UINT Flags);
HICON WINAPI CreateIconFromResource(PBYTE presbits, DWORD dwResSize,
	BOOL fIcon, DWORD dwVer);
HICON WINAPI CreateIconFromResourceEx(PBYTE presbits, DWORD dwResSize,
	BOOL  fIcon, DWORD dwVer, int cxDesired, int cyDesired, UINT  Flags);
HICON WINAPI CreateIconIndirect(PICONINFO piconinfo);
HICON WINAPI CopyIcon(HICON hIcon);
BOOL WINAPI GetIconInfo(HICON hIcon, PICONINFO piconinfo);
BOOL WINAPI DrawIcon(HDC hDC, int X, int Y, HICON hIcon);

#define IMAGE_BITMAP		0
#define IMAGE_ICON		1
#define IMAGE_CURSOR	2
#define IMAGE_ENHMETAFILE	3

HICON WINAPI CopyImage(HANDLE, UINT, int, int, UINT);
#endif

#define IMC_GETCANDIDATEPOS             0x0007
#define IMC_SETCANDIDATEPOS             0x0008
#define IMC_GETCOMPOSITIONFONT          0x0009
#define IMC_SETCOMPOSITIONFONT          0x000A
#define IMC_GETCOMPOSITIONWINDOW        0x000B
#define IMC_SETCOMPOSITIONWINDOW        0x000C
#define IMC_GETSTATUSWINDOWPOS          0x000F
#define IMC_SETSTATUSWINDOWPOS          0x0010
#define IMC_CLOSESTATUSWINDOW           0x0021
#define IMC_OPENSTATUSWINDOW            0x0022

#define IMN_CLOSESTATUSWINDOW      0x0001
#define IMN_OPENSTATUSWINDOW       0x0002
#define IMN_CHANGECANDIDATE        0x0003
#define IMN_CLOSECANDIDATE         0x0004
#define IMN_OPENCANDIDATE          0x0005
#define IMN_SETCONVERSIONMODE      0x0006
#define IMN_SETSENTENCEMODE        0x0007
#define IMN_SETOPENSTATUS          0x0008
#define IMN_SETCANDIDATEPOS        0x0009
#define IMN_SETCOMPOSITIONFONT     0x000A
#define IMN_SETCOMPOSITIONWINDOW   0x000B
#define IMN_SETSTATUSWINDOWPOS     0x000C
#define IMN_GUIDELINE              0x000D
#define IMN_PRIVATE                0x000E

#define LB_CTLCODE          0L
#define LB_OKAY             0
#define LB_ERR              (-1)
#define LB_ERRSPACE         (-2)
#define LB_ADDSTRING            0x0180
#define LB_INSERTSTRING         0x0181
#define LB_DELETESTRING         0x0182
#define LB_SELITEMRANGEEX       0x0183
#define LB_RESETCONTENT         0x0184
#define LB_SETSEL               0x0185
#define LB_SETCURSEL            0x0186
#define LB_GETSEL               0x0187
#define LB_GETCURSEL            0x0188
#define LB_GETTEXT              0x0189
#define LB_GETTEXTLEN           0x018A
#define LB_GETCOUNT             0x018B
#define LB_SELECTSTRING         0x018C
#define LB_DIR                  0x018D
#define LB_GETTOPINDEX          0x018E
#define LB_FINDSTRING           0x018F
#define LB_GETSELCOUNT          0x0190
#define LB_GETSELITEMS          0x0191
#define LB_SETTABSTOPS          0x0192
#define LB_GETHORIZONTALEXTENT  0x0193
#define LB_SETHORIZONTALEXTENT  0x0194
#define LB_SETCOLUMNWIDTH       0x0195
#define LB_ADDFILE              0x0196
#define LB_SETTOPINDEX          0x0197
#define LB_GETITEMRECT          0x0198
#define LB_GETITEMDATA          0x0199
#define LB_SETITEMDATA          0x019A
#define LB_SELITEMRANGE         0x019B
#define LB_SETANCHORINDEX       0x019C
#define LB_GETANCHORINDEX       0x019D
#define LB_SETCARETINDEX        0x019E
#define LB_GETCARETINDEX        0x019F
#define LB_SETITEMHEIGHT        0x01A0
#define LB_GETITEMHEIGHT        0x01A1
#define LB_FINDSTRINGEXACT      0x01A2
#define LB_SETLOCALE            0x01A5
#define LB_GETLOCALE            0x01A6
#define LB_SETCOUNT             0x01A7
#define LB_INITSTORAGE          0x01A8
#define LB_ITEMFROMPOINT        0x01A9
#define LB_MSGMAX               0x01B0

#define LBN_ERRSPACE        (-2)
#define LBN_SELCHANGE       1
#define LBN_DBLCLK          2
#define LBN_SELCANCEL       3
#define LBN_SETFOCUS        4
#define LBN_KILLFOCUS       5

#define LBS_NOTIFY            0x0001L
#define LBS_SORT              0x0002L
#define LBS_NOREDRAW          0x0004L
#define LBS_MULTIPLESEL       0x0008L
#define LBS_OWNERDRAWFIXED    0x0010L
#define LBS_OWNERDRAWVARIABLE 0x0020L
#define LBS_HASSTRINGS        0x0040L
#define LBS_USETABSTOPS       0x0080L
#define LBS_NOINTEGRALHEIGHT  0x0100L
#define LBS_MULTICOLUMN       0x0200L
#define LBS_WANTKEYBOARDINPUT 0x0400L
#define LBS_EXTENDEDSEL       0x0800L
#define LBS_DISABLENOSCROLL   0x1000L
#define LBS_NODATA            0x2000L
#define LBS_NOSEL             0x4000L
#define LBS_STANDARD          (LBS_NOTIFY | LBS_SORT | WS_VSCROLL | WS_BORDER)

#define LR_DEFAULTCOLOR     0x0000
#define LR_MONOCHROME       0x0001
#define LR_COLOR            0x0002
#define LR_COPYRETURNORG    0x0004
#define LR_COPYDELETEORG    0x0008
#define LR_LOADFROMFILE     0x0010
#define LR_LOADTRANSPARENT  0x0020
#define LR_DEFAULTSIZE      0x0040
#define LR_LOADMAP3DCOLORS  0x1000
#define LR_CREATEDIBSECTION 0x2000
#define LR_COPYFROMRESOURCE 0x4000      
#define LR_SHARED           0x8000      

#define MDIS_ALLCHILDSTYLES    0x0001
#define MDITILE_VERTICAL       0x0000 /*not in win3.1 */
#define MDITILE_HORIZONTAL     0x0001 /*not in win3.1 */
#define MDITILE_SKIPDISABLED   0x0002 /*not in win3.1 */

#if !defined(RC_INVOKED)
typedef struct
{
    LPCTSTR   szClass;
    LPCTSTR   szTitle;
    HANDLE hOwner;
    int x;
    int y;
    int cx;
    int cy;
    DWORD style;
    LPARAM lParam;
} MDICREATESTRUCT, *LPMDICREATESTRUCT;

typedef struct
{
    HANDLE hWindowMenu;
    UINT idFirstChild;
} CLIENTCREATESTRUCT, *LPCLIENTCREATESTRUCT;

#define DefFrameProc TFUNCT(DefFrameProc)
LRESULT WINAPI DefFrameProc(HWND hWnd, HWND hWndMDIClient ,
	UINT uMsg, WPARAM wParam, LPARAM lParam);
#define DefMDIChildProc TFUNCT(DefMDIChildProc)
LRESULT WINAPI DefMDIChildProc(HWND hWnd, UINT uMsg,
	WPARAM wParam, LPARAM lParam);
BOOL WINAPI TranslateMDISysAccel(HWND hWndClient, LPMSG lpMsg);
#define CreateMDIWindow TFUNCT(CreateMDIWindow)
HWND WINAPI CreateMDIWindow(LPTSTR lpClassName, LPTSTR lpWindowName,
	DWORD dwStyle, int X, int Y, int nWidth, int nHeight,
	HWND hWndParent, HINSTANCE hInstance, LPARAM lParam);
UINT WINAPI ArrangeIconicWindows(HWND hWnd);
WORD WINAPI TileWindows(HWND hwndParent, UINT wHow, 
	CONST RECT * lpRect, UINT cKids, CONST HWND *lpKids);
WORD WINAPI CascadeWindows(HWND hwndParent, UINT wHow, 
	CONST RECT * lpRect, UINT cKids,  CONST HWND *lpKids);
#endif

#define OBM_CLOSE       	32754
#define OBM_UPARROW      	32753
#define OBM_DNARROW    	32752
#define OBM_RGARROW         	32751
#define OBM_LFARROW       	32750
#define OBM_REDUCE       	32749
#define OBM_ZOOM        	32748
#define OBM_RESTORE     	32747
#define OBM_REDUCED   	32746
#define OBM_ZOOMD       	32745
#define OBM_RESTORED   	32744
#define OBM_UPARROWD   	32743
#define OBM_DNARROWD    	32742
#define OBM_RGARROWD    	32741
#define OBM_LFARROWD     	32740
#define OBM_MNARROW      	32739
#define OBM_COMBO       	32738
#define OBM_UPARROWI   	32737
#define OBM_DNARROWI      	32736
#define OBM_RGARROWI  	32735
#define OBM_LFARROWI  	32734
#define OBM_OLD_CLOSE    	32767
#define OBM_SIZE         		32766
#define OBM_OLD_UPARROW   32765
#define OBM_OLD_DNARROW   32764
#define OBM_OLD_RGARROW   32763
#define OBM_OLD_LFARROW    32762
#define OBM_BTSIZE          	32761
#define OBM_CHECK           	32760
#define OBM_CHECKBOXES      	32759
#define OBM_BTNCORNERS	32758
#define OBM_OLD_REDUCE 	32757
#define OBM_OLD_ZOOM        	32756
#define OBM_OLD_RESTORE     32755

#define OCR_NORMAL          32512
#define OCR_IBEAM           32513
#define OCR_WAIT            32514
#define OCR_CROSS           32515
#define OCR_UP              32516
#define OCR_SIZE            32640
#define OCR_ICON            32641
#define OCR_SIZENWSE        32642
#define OCR_SIZENESW        32643
#define OCR_SIZEWE          32644
#define OCR_SIZENS          32645
#define OCR_SIZEALL         32646
#define OCR_ICOCUR          32647
#define OCR_NO              32648
#define OCR_APPSTARTING     32650

#define ODA_DRAWENTIRE  0x0001
#define ODA_SELECT      0x0002
#define ODA_FOCUS       0x0004

#define ODS_SELECTED    0x0001
#define ODS_GRAYED      0x0002
#define ODS_DISABLED    0x0004
#define ODS_CHECKED     0x0008
#define ODS_FOCUS       0x0010
#define ODS_DEFAULT         0x0020
#define ODS_COMBOBOXEDIT    0x1000

#define ODT_MENU        1
#define ODT_LISTBOX     2
#define ODT_COMBOBOX    3
#define ODT_BUTTON      4
#define ODT_STATIC      5

#if !defined(RC_INVOKED)
typedef struct {
    UINT       CtlType;
    UINT       CtlID;
    UINT       itemID;
    UINT       itemWidth;
    UINT       itemHeight;
    DWORD      itemData;
} MEASUREITEMSTRUCT, *PMEASUREITEMSTRUCT, *LPMEASUREITEMSTRUCT;

typedef struct {
    UINT        CtlType;
    UINT        CtlID;
    UINT        itemID;
    UINT        itemAction;
    UINT        itemState;
    HWND        hwndItem;
    HDC         hDC;
    RECT        rcItem;
    DWORD       itemData;
} DRAWITEMSTRUCT, *PDRAWITEMSTRUCT, *LPDRAWITEMSTRUCT;
#endif

#define OIC_SAMPLE          32512
#define OIC_HAND            32513
#define OIC_QUES            32514
#define OIC_BANG            32515
#define OIC_NOTE            32516
#define OIC_WINLOGO         32517
#define OIC_WARNING         OIC_BANG
#define OIC_ERROR           OIC_HAND
#define OIC_INFORMATION     OIC_NOTE

#define ORD_LANGDRIVER    1

#define PSM_PAGEINFO        (WM_USER+100)
#define PSM_SHEETINFO       (WM_USER+101)

#define PSI_SETACTIVE       0x0001L
#define PSI_KILLACTIVE      0x0002L
#define PSI_APPLY           0x0003L
#define PSI_RESET           0x0004L
#define PSI_HASHELP         0x0005L
#define PSI_HELP            0x0006L
#define PSI_CHANGED         0x0001L
#define PSI_GUISTART        0x0002L
#define PSI_REBOOT          0x0003L
#define PSI_GETSIBLINGS     0x0004L

#define RES_ICON    1
#define RES_CURSOR  2

#define RT_CURSOR           MAKEINTRESOURCE(1)
#define RT_BITMAP           MAKEINTRESOURCE(2)
#define RT_ICON             MAKEINTRESOURCE(3)
#define RT_MENU             MAKEINTRESOURCE(4)
#define RT_DIALOG           MAKEINTRESOURCE(5)
#define RT_STRING           MAKEINTRESOURCE(6)
#define RT_FONTDIR          MAKEINTRESOURCE(7)
#define RT_FONT             MAKEINTRESOURCE(8)
#define RT_ACCELERATOR      MAKEINTRESOURCE(9)
#define RT_RCDATA           MAKEINTRESOURCE(10)
#define RT_MESSAGETABLE     MAKEINTRESOURCE(11)
#define RT_GROUP_CURSOR MAKEINTRESOURCE((DWORD)RT_CURSOR + 11)
#define RT_GROUP_ICON   MAKEINTRESOURCE((DWORD)RT_ICON + 11)
#define RT_VERSION      MAKEINTRESOURCE(16)
#define RT_DLGINCLUDE   MAKEINTRESOURCE(17)
#define RT_PLUGPLAY     MAKEINTRESOURCE(19)
#define RT_VXD          MAKEINTRESOURCE(20)

#define SB_HORZ	0
#define SB_VERT	1
#define SB_CTL		2
#define SB_BOTH	3
#define SB_LINEUP	0
#define SB_LINELEFT	0
#define SB_LINEDOWN	1
#define SB_LINERIGHT	1
#define SB_PAGEUP	2
#define SB_PAGELEFT	2
#define SB_PAGEDOWN	3
#define SB_PAGERIGHT	3
#define SB_THUMBPOSITION	4
#define SB_THUMBTRACK	5
#define SB_TOP		6
#define SB_LEFT	6
#define SB_BOTTOM	7
#define SB_RIGHT	7
#define SB_ENDSCROLL	8

#define SBS_HORZ                    0x0000L
#define SBS_VERT                    0x0001L
#define SBS_TOPALIGN                0x0002L
#define SBS_LEFTALIGN               0x0002L
#define SBS_BOTTOMALIGN             0x0004L
#define SBS_RIGHTALIGN              0x0004L
#define SBS_SIZEBOXTOPLEFTALIGN     0x0002L
#define SBS_SIZEBOXBOTTOMRIGHTALIGN 0x0004L
#define SBS_SIZEBOX                 0x0008L
#define SBS_SIZEGRIP                0x0010L

#define SBM_SETPOS                  0x00E0
#define SBM_GETPOS                  0x00E1
#define SBM_SETRANGE                0x00E2 
#define SBM_SETRANGEREDRAW          0x00E6
#define SBM_GETRANGE                0x00E3
#define SBM_ENABLE_ARROWS           0x00E4
#define SBM_SETSCROLLINFO           0x00E9
#define SBM_GETSCROLLINFO           0x00EA

#define SC_SIZE         0xF000
#define SC_MOVE         0xF010
#define SC_MINIMIZE     0xF020
#define SC_MAXIMIZE     0xF030
#define SC_NEXTWINDOW   0xF040
#define SC_PREVWINDOW   0xF050
#define SC_CLOSE        0xF060
#define SC_VSCROLL      0xF070
#define SC_HSCROLL      0xF080
#define SC_MOUSEMENU    0xF090
#define SC_KEYMENU      0xF100
#define SC_ARRANGE      0xF110
#define SC_RESTORE      0xF120
#define SC_TASKLIST     0xF130
#define SC_SCREENSAVE   0xF140
#define SC_HOTKEY       0xF150
#define SC_DEFAULT      0xF160
#define SC_MONITORPOWER 0xF170
#define SC_CONTEXTHELP  0xF180
#define SC_SEPARATOR    0xF00F

#define SIF_RANGE           0x0001
#define SIF_PAGE            0x0002
#define SIF_POS             0x0004
#define SIF_DISABLENOSCROLL 0x0008
#define SIF_TRACKPOS        0x0010
#define SIF_ALL             (SIF_RANGE | SIF_PAGE | SIF_POS | SIF_TRACKPOS)

#if !defined(RC_INVOKED)
typedef struct
{
    UINT    cbSize;
    UINT    fMask;
    int     nMin;
    int     nMax;
    UINT    nPage;
    int     nPos;
    int     nTrackPos;
}   SCROLLINFO, *LPSCROLLINFO;
typedef SCROLLINFO CONST *LPCSCROLLINFO;

int WINAPI SetScrollInfo(HWND, int, LPCSCROLLINFO, BOOL);
BOOL WINAPI GetScrollInfo(HWND, int, LPSCROLLINFO);
#endif

#define SM_CXSCREEN             0
#define SM_CYSCREEN             1
#define SM_CXVSCROLL            2
#define SM_CYHSCROLL            3
#define SM_CYCAPTION            4
#define SM_CXBORDER             5
#define SM_CYBORDER             6
#define SM_CXDLGFRAME           7
#define SM_CYDLGFRAME           8
#define SM_CYVTHUMB             9
#define SM_CXHTHUMB             10
#define SM_CXICON               11
#define SM_CYICON               12
#define SM_CXCURSOR             13
#define SM_CYCURSOR             14
#define SM_CYMENU               15
#define SM_CXFULLSCREEN         16
#define SM_CYFULLSCREEN         17
#define SM_CYKANJIWINDOW        18
#define SM_MOUSEPRESENT         19
#define SM_CYVSCROLL            20
#define SM_CXHSCROLL            21
#define SM_DEBUG                22
#define SM_SWAPBUTTON           23
#define SM_RESERVED1            24
#define SM_RESERVED2            25
#define SM_RESERVED3            26
#define SM_RESERVED4            27
#define SM_CXMIN                28
#define SM_CYMIN                29
#define SM_CXSIZE               30
#define SM_CYSIZE               31
#define SM_CXFRAME              32
#define SM_CYFRAME              33
#define SM_CXMINTRACK           34
#define SM_CYMINTRACK           35
#define SM_CXDOUBLECLK          36
#define SM_CYDOUBLECLK          37
#define SM_CXICONSPACING        38
#define SM_CYICONSPACING        39
#define SM_MENUDROPALIGNMENT    40
#define SM_PENWINDOWS           41
#define SM_DBCSENABLED          42
#define SM_CMOUSEBUTTONS        43
#define SM_CXFIXEDFRAME           SM_CXDLGFRAME
#define SM_CYFIXEDFRAME           SM_CYDLGFRAME
#define SM_CXSIZEFRAME            SM_CXFRAME
#define SM_CYSIZEFRAME            SM_CYFRAME
#define SM_SECURE               44
#define SM_CXEDGE               45
#define SM_CYEDGE               46
#define SM_CXMINSPACING         47
#define SM_CYMINSPACING         48
#define SM_CXSMICON             49
#define SM_CYSMICON             50
#define SM_CYSMCAPTION          51
#define SM_CXSMSIZE             52
#define SM_CYSMSIZE             53
#define SM_CXMENUSIZE           54
#define SM_CYMENUSIZE           55
#define SM_ARRANGE              56
#define SM_CXMINIMIZED          57
#define SM_CYMINIMIZED          58
#define SM_CXMAXTRACK           59
#define SM_CYMAXTRACK           60
#define SM_CXMAXIMIZED          61
#define SM_CYMAXIMIZED          62
#define SM_NETWORK              63
#define SM_CLEANBOOT            67
#define SM_CXDRAG               68
#define SM_CYDRAG               69
#define SM_SHOWSOUNDS           70
#define SM_CXMENUCHECK          71
#define SM_CYMENUCHECK          72
#define SM_SLOWMACHINE          73
#define SM_MIDEASTENABLED       74
#define SM_CMETRICS             75

#if !defined(RC_INVOKED)
int WINAPI GetSystemMetrics(int nIndex);
#endif

#define SS_LEFT             0x00000000L
#define SS_CENTER           0x00000001L
#define SS_RIGHT            0x00000002L
#define SS_ICON             0x00000003L
#define SS_BLACKRECT        0x00000004L
#define SS_GRAYRECT         0x00000005L
#define SS_WHITERECT        0x00000006L
#define SS_BLACKFRAME       0x00000007L
#define SS_GRAYFRAME        0x00000008L
#define SS_WHITEFRAME       0x00000009L
#define SS_USERITEM         0x0000000AL
#define SS_SIMPLE           0x0000000BL
#define SS_LEFTNOWORDWRAP   0x0000000CL
#define SS_BITMAP           0x0000000EL
#define SS_OWNERDRAW        0x0000000DL
#define SS_ENHMETAFILE      0x0000000FL
#define SS_ETCHEDHORZ       0x00000010L
#define SS_ETCHEDVERT       0x00000011L
#define SS_ETCHEDFRAME      0x00000012L
#define SS_TYPEMASK         0x0000001FL
#define SS_NOPREFIX         0x00000080L
#define SS_NOTIFY           0x00000100L
#define SS_CENTERIMAGE      0x00000200L
#define SS_RIGHTJUST        0x00000400L
#define SS_REALSIZEIMAGE    0x00000800L
#define SS_SUNKEN           0x00001000L

#define STM_SETICON         0x0170
#define STM_GETICON         0x0171
#define STM_SETIMAGE        0x0172
#define STM_GETIMAGE        0x0173
#define STM_MSGMAX          0x0174

#define STN_CLICKED         0
#define STN_DBLCLK          1
#define STN_ENABLE          2
#define STN_DISABLE         3

#define SW_SCROLLCHILDREN	0x0001
#define SW_INVALIDATE	0x0002
#define SW_ERASE	0x0004

#if !defined(RC_INVOKED)
BOOL WINAPI ScrollWindow(HWND hWnd, int XAmount, int YAmount,
	CONST RECT *lpRect, CONST RECT *lpClipRect);
int WINAPI ScrollWindowEx(HWND hWnd, int XAmount, int YAmount,
	CONST RECT *lpRect, CONST RECT *lpClipRect,
	HRGN hrgnUpdate, LPRECT prcUpdate, UINT flags);
int WINAPI SetScrollPos(HWND hWnd, int nBar, int nPos, BOOL bRedraw);
int WINAPI GetScrollPos(HWND hWnd, int nBar);
BOOL WINAPI SetScrollRange(HWND hWnd, int nBar, int nMinPos,
	int nMaxPos, BOOL bRedraw);
BOOL WINAPI GetScrollRange(HWND hWnd, int nBar, 
	LPINT lpMinPos, LPINT lpMaxPos);
BOOL WINAPI ShowScrollBar(HWND hWnd, int wBar, BOOL bShow);
#endif

#define TPM_LEFTBUTTON  0x0000L
#define TPM_RIGHTBUTTON 0x0002L
#define TPM_LEFTALIGN   0x0000L
#define TPM_CENTERALIGN 0x0004L
#define TPM_RIGHTALIGN  0x0008L
#define TPM_TOPALIGN        0x0000L
#define TPM_VCENTERALIGN    0x0010L
#define TPM_BOTTOMALIGN     0x0020L
#define TPM_HORIZONTAL      0x0000L
#define TPM_VERTICAL        0x0040L
#define TPM_NONOTIFY        0x0080L
#define TPM_RETURNCMD       0x0100L

#define WB_LEFT            0
#define WB_RIGHT           1
#define WB_ISDELIMITER     2

#define WC_DIALOG       (MAKEINTATOM(0x8002))

#if !defined(RC_INVOKED)
typedef BOOL WINAPI (*DLGPROC)(HWND, UINT, WPARAM, LPARAM);

#define DialogBoxParam TFUNCT(DialogBoxParam)
int WINAPI  DialogBoxParam(HINSTANCE hInst, LPCTSTR lpTemplate, 
	HWND hParent, DLGPROC lpDialogProc, LPARAM dwInitParam);
#define DialogBox(a,b,c,d) DialogBoxParam(a,b,c,d,0L)
#define CreateDialogParam TFUNCT(CreateDialogParam)
HWND WINAPI CreateDialogParam(HINSTANCE hInstance, LPCTSTR lpTemplateName,
	HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
#define CreateDialog(hInstance, lpName, hWndParent, lpDialogFunc) CreateDialogParam(hInstance, lpName, hWndParent, lpDialogFunc, 0L)

#pragma pack(2)
typedef struct {
    DWORD style;
    DWORD dwExtendedStyle;
    short x;
    short y;
    short cx;
    short cy;
    WORD id;
} DLGITEMTEMPLATE, *PDLGITEMTEMPLATE, *LPDLGITEMTEMPLATE;

typedef struct 
{
    DWORD style;
    DWORD dwExtendedStyle;
    WORD cdit;
    short x;
    short y;
    short cx;
    short cy;
} DLGTEMPLATE, *LPDLGTEMPLATE;
typedef CONST DLGTEMPLATE *LPCDLGTEMPLATE;
#pragma pack()

#define DialogBoxIndirectParam TFUNCT(DialogBoxIndirectParam)
int WINAPI DialogBoxIndirectParam(HINSTANCE hInstance, LPCDLGTEMPLATE hDialogTemplate,
	HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
#define DialogBoxIndirect(hInstance, lpTemplate, hWndParent, lpDialogFunc) DialogBoxIndirectParam(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0L)
#define CreateDialogIndirectParam TFUNCT(CreateDialogIndirectParam)
HWND WINAPI CreateDialogIndirectParam(HINSTANCE hInstance, LPCDLGTEMPLATE lpTemplate,
	HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
#define CreateDialogIndirect(hInstance, lpTemplate, hWndParent, lpDialogFunc) CreateDialogIndirectParam(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0L)
BOOL WINAPI EndDialog (HWND hDlg, int nResult);
#define DefDlgProc TFUNCT(DefDlgProc)
LRESULT WINAPI DefDlgProc(HWND hDlg, UINT Msg, WPARAM wParam,
	LPARAM lParam);
#define DLGWINDOWEXTRA 30

HWND WINAPI GetDlgItem (HWND hDlg, int nIDDlgItem);
HWND WINAPI GetNextDlgGroupItem(HWND hDlg, HWND hCtl, BOOL bPrevious);
HWND WINAPI GetNextDlgTabItem(HWND hDlg, HWND hCtl, BOOL bPrevious);
int WINAPI GetDlgCtrlID(HWND hWnd);

long WINAPI GetDialogBaseUnits(VOID);

BOOL WINAPI SetDlgItemInt(HWND hDlg, int nIDDlgItem, UINT uValue,
	BOOL bSigned);
UINT WINAPI GetDlgItemInt(HWND hDlg, int nIDDlgItem, BOOL *lpTranslated,
	BOOL bSigned);
#define SetDlgItemText TFUNCT(SetDlgItemText)
BOOL WINAPI SetDlgItemText(HWND h, int n, LPCTSTR lpString);
#define GetDlgItemText TFUNCT(GetDlgItemText)
UINT WINAPI GetDlgItemText(HWND h, int n, LPTSTR lpString, int c);

BOOL WINAPI CheckDlgButton(HWND hDlg, int nIDButton, UINT uCheck);
BOOL WINAPI CheckRadioButton(HWND hDlg, int nIDFirstButton, 
	int nIDLastButton, int nIDCheckButton);
UINT WINAPI IsDlgButtonChecked(HWND hDlg, int nIDButton);

#define FVIRTKEY	0x01
#define FNOINVERT	0x02
#define FSHIFT		0x04
#define FCONTROL	0x08
#define FALT		0x10

#pragma pack(2)
typedef struct {
    BYTE   fVirt;
    WORD   key;
    WORD   cmd;
} ACCEL, *LPACCEL;
#pragma pack()

#define LoadAccelerators TFUNCT(LoadAccelerators)
HACCEL WINAPI LoadAccelerators(HINSTANCE hInstance, LPCTSTR lpTableName);
#define LoadBitmap TFUNCT(LoadBitmap)
HBITMAP WINAPI LoadBitmap(HINSTANCE hInstance, LPCTSTR lpBitmapName);
#define LoadCursor TFUNCT(LoadCursor)
HCURSOR WINAPI LoadCursor(HINSTANCE hInst, LPCTSTR lpName);
#define LoadCursorFromFile TFUNCT(LoadCursorFromFile)
HCURSOR WINAPI LoadCursorFromFile(LPCTSTR lpFileName);
#define LoadIcon TFUNCT(LoadIcon)
HICON WINAPI LoadIcon(HINSTANCE hInst, LPCTSTR lpName);
#define LoadImage TFUNCT(LoadImage)
HANDLE WINAPI LoadImage(HINSTANCE hInst, LPCTSTR lpName,
	UINT, int, int, UINT);
#define LoadString TFUNCT(LoadString)
int WINAPI LoadString(HINSTANCE hInstance, UINT uID, 
	LPTSTR lpBuffer, int nBufferMax);

BOOL WINAPI MapDialogRect(HWND hDlg, LPRECT lpRect);

#define MAKELANGID(p, s)       ((((WORD  )(s)) << 10) | (WORD  )(p))
#define PRIMARYLANGID(lgid)    ((WORD  )(lgid) & 0x3ff)
#define SUBLANGID(lgid)        ((WORD  )(lgid) >> 10)
#endif /* RC_INVOKED */

#ifdef __cplusplus
}
#endif

#endif /* !defined (_WINDIALO_H) */
