/*

Type Representation

The Type field of a symbol table entry contains two bytes,

each byte representing type information.

The least-significant byte represents simple (base) data 

type, and the most-significant byte represents complex type, if any:

MSB			LSB

Complex type: none,	Base type: integer, floating-point, etc.

pointer, function, array	



The following values are defined for base type, although 

Microsoft tools generally do not use this field, setting 

the least-significant byte to 0. Instead, CodeView 

information is used to indicate types. The

possible COFF values are :

Constant	Value	

	Description

*/

#define IMAGE_SYM_TYPE_NULL	0

	/* No type information, or unknown base type. 

	Microsoft tools use this setting. */

#define IMAGE_SYM_TYPE_VOID	1

	/* No valid type; used with void pointers 

	and functions. */

#define IMAGE_SYM_TYPE_CHAR	2

	/* Character (signed byte). */

#define IMAGE_SYM_TYPE_SHORT	3

	/* Two-byte signed integer. */

#define IMAGE_SYM_TYPE_INT	4

	/* Natural integer type (normally four bytes in NT). */

#define IMAGE_SYM_TYPE_LONG	5

	/* Four-byte signed integer. */

#define IMAGE_SYM_TYPE_FLOAT	6

	/* Four-byte floating-point number. */

#define IMAGE_SYM_TYPE_DOUBLE	7

	/* Eight-byte floating-point number. */

#define IMAGE_SYM_TYPE_STRUCT	8

	/* Structure. */

#define IMAGE_SYM_TYPE_UNION	9

	/* Union. */

#define IMAGE_SYM_TYPE_ENUM	10

	/* Enumerated type. */

#define IMAGE_SYM_TYPE_MOE	11

	/* Member of enumeration (a specific value). */

#define IMAGE_SYM_TYPE_BYTE	12

	/* Byte; unsigned one-byte integer. */

#define IMAGE_SYM_TYPE_WORD	13

	/* Word; unsigned two-byte integer. */

#define IMAGE_SYM_TYPE_UINT	14

	/* Unsigned integer of natural size (normally, four bytes). */

#define IMAGE_SYM_TYPE_DWORD	15

	/* Unsigned four-byte integer. */

/*

The  most significant byte specifies whether the symbol 

is a pointer to, function returning, or array of the base 

type specified in the least significant byte. Microsoft tools 

use this field only to indicate whether or not the symbol is 

a function, so that the only two resulting values are 0x0 

and 0x20 for the Type field. However, other tools can use 

this field to communicate more information.



Constant	Value	Description

*/

#define IMAGE_SYM_DTYPE_NULL	0

	/* No derived type; the symbol is a simple scalar variable. */

#define IMAGE_SYM_DTYPE_POINTER	1

	/* Pointer to base type. */

#define IMAGE_SYM_DTYPE_FUNCTION	2

	/* Function returning base type. */

#define IMAGE_SYM_DTYPE_ARRAY	3	

	/* Array of base type. */

