# Makefile for libpng
# Watcom C++ 11.0 (Note: All modules are compiled in C mode)
# Will work with C++ 4.02 also
# To build the library, do:
#       "make -fmakefile.bor -DMODEL=f"
# or:   "make -fmakefile.bor -DMODEL=l"
#
# ------------- Watcom C++ 11.0 -------------

### Absolutely necessary for this makefile to work
#.AUTODEPEND

## Useful user options

# Where zlib.h and zconf.h and zlib.lib are
ZLIB_PATH=..\zlib

!ifndef MODEL
MODEL=f
!endif

#TARGET_CPU=3
# 2 = 286, 3 = 386, etc.
!ifndef TARGET_CPU
TARGET_CPU=5
!endif


# Use this if you don't want Borland's fancy exception handling.
NOEHLIB=noeh$(MODEL).lib

!ifdef DEBUG
CDEBUG=-v
LDEBUG=-v
!else
CDEBUG=
LDEBUG=
!endif

# STACKOFLOW=1
!ifdef STACKOFLOW
CDEBUG=$(CDEBUG) -N
LDEBUG=$(LDEBUG) -N
!endif


## Compiler, linker, and lib stuff
CC=wcc386
LD=wcc386
LIB=wlib -b -c -n

MODELARG=-m$(MODEL)

CFLAGS=-oneatx -i=$(ZLIB_PATH) -$(TARGET_CPU)r $(MODELARG) $(CDEBUG)

# -M  generate map file
LDFLAGS=-M $(LDEBUG)

O=obj

## variables
OBJS = &
 png.$(O) &
 pngerror.$(O) &
 pngmem.$(O)   &
 pngpread.$(O) &
 pngset.$(O)   &
 pngget.$(O)   &
 pngread.$(O)  &
 pngrio.$(O)   &
 pngrtran.$(O) &
 pngrutil.$(O) &
 pngtrans.$(O) &
 pngwrite.$(O) &
 pngwtran.$(O) &
 pngwio.$(O)   &
 pngwutil.$(O)

LIBOBJS =       &
 +png.$(O)      &
 +pngerror.$(O) &
 +pngmem.$(O)   &
 +pngpread.$(O) &
 +pngread.$(O)  &
 +pngset.$(O)   &
 +pngget.$(O)   &
 +pngrio.$(O)   &
 +pngrtran.$(O) &
 +pngrutil.$(O) &
 +pngtrans.$(O) &
 +pngwrite.$(O) &
 +pngwtran.$(O) &
 +pngwio.$(O)   &
 +pngwutil.$(O)

LIBNAME=libpng$(MODEL).lib


## Implicit rules
# Braces let make "batch" calls to the compiler,
# 2 calls instead of 12; space is important.
.c.obj:
        $(CC) $(CFLAGS) $*.c

.c.exe:
        $(CC) $(CFLAGS) $(LDFLAGS) $*.c


## Major targets
libpng: $(LIBNAME)

pngtest: pngtest$(MODEL).exe

test:    pngtest$(MODEL)


## Minor Targets

png.obj: png.c
pngset.obj: pngset.c
pngget.obj: pngget.c
pngread.obj: pngread.c
pngpread.obj: pngpread.c
pngrtran.obj: pngrtran.c
pngrutil.obj: pngrutil.c
pngerror.obj: pngerror.c
pngmem.obj: pngmem.c
pngrio.obj: pngrio.c
pngwio.obj: pngwio.c
pngtrans.obj: pngtrans.c
pngwrite.obj: pngwrite.c
pngwtran.obj: pngwtran.c
pngwutil.obj: pngwutil.c


$(LIBNAME): $(OBJS)
        del $(LIBNAME)
        @%create wlib.lnk
        @%append wlib.lnk $(LIBOBJS)
        $(LIB) $(LIBNAME) @wlib.lnk
        del wlib.lnk

#pngtest$(MODEL).obj: pngtest.c
#        $(CC) $(CFLAGS) -opngtest$(MODEL) -c pngtest.c

#pngtest$(MODEL).exe: pngtest$(MODEL).obj
#        $(CC) $(MODELARG) $(LDFLAGS) -L$(ZLIB_PATH) pngtest$(MODEL).obj $(LIBNAME) zlib$(MODEL).lib $(NOEHLIB)


# Clean up anything else you want
clean:
        -del *.obj
        -del *.lib
        -del *.lst


# End of makefile for libpng
