# This is a subinclude file used to define the rules needed
# to build the NULL network driver

# Driver description
DESCRIPTION.netmann = Crystal Space NULL network manager

#-------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Driver-specific help commands
DRVHELP += $(NEWLINE)echo $"  make netmann      Make the $(DESCRIPTION.netmann)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#-------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: netmann

all drivers netdrivers: netmann

netmann:
	$(MAKE_TARGET) MAKE_DLL=yes

endif # ifeq ($(MAKESECTION),roottargets)

#-------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp libs/csnetman/null

# The NULL Network driver
ifeq ($(USE_DLL),yes)
  NETMANN=$(OUTDLL)netmann$(DLL)
  DEP.NETMANN=$(CSCOM.LIB) $(CSSYS.LIB) $(CSUTIL.LIB)
else
  NETMANN=$(OUT)$(LIB_PREFIX)netmann$(LIB)
  DEP.EXE+=$(NETMANN)
  CFLAGS.STATIC_COM+=$(CFLAGS.D)SCL_NETMANNULL
endif
DESCRIPTION.$(NETMANN) = $(DESCRIPTION.netmann)
SRC.NETMANN = $(wildcard libs/csnetman/null/*.cpp)
OBJ.NETMANN = $(addprefix $(OUT),$(notdir $(SRC.NETMANN:.cpp=$O)))

endif # ifeq ($(MAKESECTION),postdefines)

#------------------------------------------------------------------ targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: netmann netmannclean netmanncleanlib

# Chain rules
net: netmann
clean: netmannclean
cleanlib: netmanncleanlib

netmann: $(OUTDIRS) $(NETMANN)

$(NETMANN): $(OBJ.NETMANN) $(DEP.NETMANN)
	$(DO.LIBRARY)

netmannclean:
	$(RM) $(NETMANN)

netmanncleanlib:
	$(RM) $(OBJ.NETMANN) $(NETMANN)

ifdef DO_DEPEND
depend: $(OUTOS)netmann.dep
$(OUTOS)netmann.dep: $(SRC.NETMANN)
	$(DO.DEP)
else
-include $(OUTOS)netmann.dep
endif

endif # ifeq ($(MAKESECTION),targets)
