/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include "sysdef.h"
#include "csgame/gstd.h"
#include "csgame/guserint.h"

geUserInterface::geUserInterface(geSystem* pSystem)
{
  ASSERT(pSystem); //We really need that pointer!

  m_pSystem        = pSystem;
  m_piG3D          = NULL;
  m_piG2D          = NULL;
  m_pView          = NULL;
  m_FrameWidth     = 0;
  m_FrameHeight    = 0;
}

geUserInterface::~geUserInterface()
{
  //do nothing (yet)
}

bool geUserInterface::Init(int /*argc*/, char* /*argv*/[])
{
  m_piG3D          = m_pSystem->piG3D;
  m_piG2D          = m_pSystem->piG2D;
  m_FrameWidth     = m_pSystem->FrameWidth;
  m_FrameHeight    = m_pSystem->FrameHeight;
  m_pView          = m_pSystem->GetView();
  
  return true;
}

void geUserInterface::EatKeypress (int /*key*/, bool /*shift*/, bool /*alt*/, bool /*ctrl*/)
{
  //do nothing (yet)
}

void geUserInterface::EatMousemove (int /*x*/, int /*y*/)
{
  //do nothing (yet)
}

void geUserInterface::PrepareFrame (long /*elapsed_time*/, long /*current_time*/)
{
  //do nothing (yet)
}

void geUserInterface::DrawFrame3d  (long /*elapsed_time*/, long /*current_time*/)
{
  //-----
  // Draw the frame 
  //-----
  m_pView->Draw();
}

void geUserInterface::DrawFrame2d  (long /*elapsed_time*/, long /*current_time*/)
{
  //do nothing (yet)
}

csSprite2D*  geUserInterface::CreateSprite(char* name)
{
  /*TextureMM* pTexMM = m_pSystem->GetTextureMM(name);
  if (!pTexMM) return NULL;
  
  Texture* pTex = pTexMM->get_texture(0);
  if (!pTex) return NULL;*/

  int w, h;
  csTextureHandle *pLogoTex = m_pSystem->GetTexture(name);
  ITextureHandle* phTex = pLogoTex->GetTextureHandle();
  phTex->GetBitmapDimensions(w,h);
  //return new csSprite2D (pLogoTex, 0, 0, pTex->get_width(), pTex->get_height()); //xet
  return new csSprite2D (pLogoTex, 0, 0, w, h);
}

void geUserInterface::DrawSprite(csSprite2D* pSprite, int x, int y, H_Align ha, V_Align va)
{
  ASSERT(pSprite);
  
  

  int w  = pSprite->Width()  * m_FrameWidth  / 640;
  int h  = pSprite->Height() * m_FrameHeight / 480;
  
  x = x * m_FrameWidth  / 640;
  y = y * m_FrameHeight / 480;

  int sx = x;

  if (ha==h_align_right)
  {
    sx = x-w;
  }
  else if (ha==h_align_mid)
  {
    sx = x-(w/2);
  }

  int sy = y;
  if (va == v_align_bottom)
  {
    sy = y-h;
  }
  else if (va == v_align_mid)
  {
    sy = y-h/2;
  }

  pSprite->Draw(m_piG2D, sx,sy,w,h);
}

