/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include "sysdef.h"
#include "csgame/gstd.h"
#include "csgame/gpos.h"

gePosition::gePosition()
  : m_Pos(0,0,0) 
{
  m_pSector = NULL;
}

gePosition::gePosition(csSector* pSector, csVector3 Pos)
{
  ASSERT(pSector);

  m_pSector   = pSector;
  m_Pos       = Pos;
}

gePosition::gePosition(const gePosition& Pos)
{
  m_pSector   = Pos.m_pSector;
  m_Pos       = Pos.m_Pos;
}

gePosition::~gePosition()
{
}

bool gePosition::Move  (csVector3 Offset)
{
  //A valid position needs to be set first!
  ASSERT(m_pSector);

  return MoveTo(m_Pos + Offset);
}

void gePosition::MoveTo(const gePosition& Pos)
{
  m_pSector   = Pos.m_pSector;
  m_Pos       = Pos.m_Pos;
}

bool gePosition::MoveTo(csVector3 Pos)
{
  //A valid position needs to be set first!
  ASSERT(m_pSector);

  csOrthoTransform OldPos (csMatrix3(1,0,0,0,1,0,0,0,1), m_Pos);

  csVector3 NewPos     = Pos;
  csSector* pNewSector = m_pSector;

  bool mirror = false;
  pNewSector = m_pSector->FollowSegment (OldPos, NewPos, mirror);

  if (pNewSector &&
      ABS (NewPos.x-Pos.x) < SMALL_EPSILON &&
      ABS (NewPos.y-Pos.y) < SMALL_EPSILON &&
      ABS (NewPos.z-Pos.z) < SMALL_EPSILON)
  {
    m_pSector = pNewSector;
    m_Pos     = NewPos;
    return true;
  }
  else
  {
    return false; //Object would leave space...
  }
}

void gePosition::MoveTo(csSector* pSector, csVector3 Pos)
{
  ASSERT(pSector);

  m_pSector   = pSector;
  m_Pos       = Pos;
}

