/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include "sysdef.h"
#include "csgame/gstd.h"
#include "csgame/gplayer.h"

gePlayer::gePlayer(geContainer* pContainer)
  : inherited(pContainer)
{
  m_Rotation      = 0.0f;
  m_Pitch         = 0.0f;
  m_TotalDistance = 0.0f; 
}

gePlayer::~gePlayer()
{
}
  
csVector3 gePlayer::GetViewDirection()
{
  float sr = sin(m_Rotation);
  float cr = cos(m_Rotation);
  float sp = sin(m_Pitch);
  float cp = cos(m_Pitch);

  return csVector3(sr*cp, -sp, cr*cp);
}

void gePlayer::SetPitch(float angle)
{
  //Set Pitch first.
  m_Pitch = angle;

  //Camera is restricted at upper and lower angle, so you can't
  //create a top-down reversed look.
  if (m_Pitch > 1.571)
  {
    m_Pitch =  1.571f;
  }
  else if (m_Pitch < -1.571)
  {
    m_Pitch = -1.571f;
  } 
}

void gePlayer::Walk  (float distance)
{
  m_Pos.Move(distance*csVector3(sin(m_Rotation), 0, cos(m_Rotation)));
  m_TotalDistance += distance; 
}

void gePlayer::Strafe(float distance)
{
  m_Pos.Move(distance*csVector3(cos(m_Rotation), 0, -sin(m_Rotation)));
  m_TotalDistance += distance;
}

void gePlayer::Shoot()
{
  geBullet* pBullet = new geBullet(m_pWorld);
  pBullet->Create(m_Pos, "fireball", "default", 10);
  pBullet->StartMove(100.0f*GetViewDirection(), 10.0f);
}

void gePlayer::PrepareFrame(long elapsed_time, long current_time)
{
  inherited::PrepareFrame(elapsed_time, current_time);
  
  //We will not just set the camera to our position. We will add
  //a sin(distance) to the height, to simulate the effect of steps,
  //and a sin(current_time) to simulate the effect of breathing
  //those two combined will ensure, that we will never have a
  //static picture, that might loose it's 3D effects. 
  gePosition CameraPos = m_Pos;
  CameraPos.Move(VEC_UP * (0.1f  * sin(m_TotalDistance) +
                           0.03f * sin(0.001*current_time)));

  m_pWorld->SetCamera(CameraPos, m_Rotation, m_Pitch);
}



