/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include "sysdef.h"
#include "csgame/gstd.h"
#include "csgame/gphysobj.h"

gePhysicalObject::gePhysicalObject(geContainer* pContainer)
 : inherited(pContainer)
{
  m_pSprite = NULL;
}

gePhysicalObject::~gePhysicalObject()
{
}

bool gePhysicalObject::Move(csVector3 Offset)
{
  bool collision = false;

  if (m_pSprite)
  {
    gePhysicalObject* pOther = NULL;
    gePosition NewPosition = m_Pos;

    collision = m_pSprite->FindFirstCollision(Offset, NewPosition, pOther);

    SetPosition(NewPosition);
  
    if (collision)
    {
      m_pSprite->OnCollision(pOther);
    }
  }

  return !collision;
}
