/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include "sysdef.h"
#include "csgame/gstd.h"
#include "csgame/gphoptr.h"

CSOBJTYPE_IMPL(gePhysObjectPointer,csObject);

gePhysObjectPointer::gePhysObjectPointer(gePhysicalObject* pPhysObj)
{
  m_pPhysicalObject = pPhysObj;
}

gePhysObjectPointer::~gePhysObjectPointer()
{
  //do nothing yet.
}

gePhysicalObject* gePhysObjectPointer::GetPointer(csObject& csobj)
{
  csObject *o = csobj.GetObj(gePhysObjectPointer::Type());
  if (o) 
  {
    return ((gePhysObjectPointer*) o)->m_pPhysicalObject;
  }
  else
  {
    return NULL;
  }
}

/// Give a pointer to an object
void gePhysObjectPointer::SetPointer(csObject& csobj, gePhysicalObject* pPhysObj)
{
  CHK(gePhysObjectPointer* pObj = new gePhysObjectPointer(pPhysObj));
  csobj.ObjAdd(pObj); 
}

