/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include "sysdef.h"
#include "csgame/gstd.h"
#include "csgame/gexplos.h"

geExplosion::geExplosion(geContainer* pContainer)
  : inherited(pContainer)

{
  m_Strength     = 1;
  m_pLight       = new geLight(this);
  m_CreationTime = 0;
}

geExplosion::~geExplosion()
{
  if (m_pLight)  m_pLight->Destroy();
}

void geExplosion::Create(gePosition Pos, float Strength)
{
  ASSERT(Strength>1.0);

  m_Strength = Strength;
  m_pLight->Create(Pos, 10, 0, 0, 0);
  SetPosition(Pos);
}

void geExplosion::Destroy()
{
  inherited::Destroy();
  m_pLight->Destroy();
  m_pLight=NULL;
}

void geExplosion::PrepareFrame(long ElapsedTime, long CurrentTime)
{
  inherited::PrepareFrame(ElapsedTime, CurrentTime);

  if (m_CreationTime == 0) m_CreationTime = CurrentTime;

  float DeltaTime = CurrentTime-m_CreationTime;

  float f = 0.008f;

  m_pLight->SetColor (1.0,2.0*sin(DeltaTime*f),0.0);
  m_pLight->SetRadius(m_Strength*sin(DeltaTime*f));

  if ((DeltaTime*f)>1.6) Destroy();
};

