/*
    Copyright (C) 1998 by Jorrit Tyberghein
    Written by Dan Ogles

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "sysdef.h"
#include "cscom/comdefs.h"

/// Interface Globally Unique Identifiers
/// ATTENTION! Don't add these manually. Only use GUIDGEN to create IIDs.
/// Or, if you don't have access to GUIDGEN, see the end of this file
///
/// This file is split into sections; please add new GUIDs to
/// corresponding section to avoid messing up entire file
///
/// * System-independent Interface Identifiers (IIDs)
///   * Network interfaces
/// * System-specific Interface Identifiers (IIDs)
///   * System drivers
///   * GraphicsInfo drivers
///   * Class factory interfaces
/// * System-specific Class Identifiers (CLSIDs)
///   * 2D drivers
///   * 3D drivers (renderers)
///   * Network drivers
/// * Useless Junk (unimplemented and reserved GUIDs)
/// * Unused identifiers (GUIDs)
///
/// Also please follow if possible the naming convention;
/// currently it looks like this:
///
///   [CLSID_|IID_I]<name>
///   CLSID_<name>Factory
///   IID_I<name>GraphicsInfo
///   CLSID_<name>Graphics2D
///   CLSID_<name>Graphics3D
///   CLSID_<name>SystemDriver
///   CLSID_<name>NetworkDriver
///   CLSID_<name>NetworkManager
///
/// Unfortunately, there are *lots* of identifiers which do not correspond
/// to above convention... but still less than a half ;-) Please, if possible,
/// change the identifiers you're responsible for ... - A.Z.
///

//-------------------------- System-independent Interface Identifiers (IIDs) ---

// {46197001-53F9-11d2-9C9A-00EA4EC10070}
extern const GUID IID_IMipMapContainer =
{ 0x46197001, 0x53f9, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {46197002-53F9-11d2-9C9A-00EA4EC10070}
extern const GUID IID_ILightMap =
{ 0x46197002, 0x53f9, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {A8D336AD-D7AE-11d2-9C10-00C04F8372FF}
extern const GUID IID_IImageFile = 
{ 0xa8d336ad, 0xd7ae, 0x11d2, { 0x9c, 0x10, 0x0, 0xc0, 0x4f, 0x83, 0x72, 0xff } };

// {A8D336B4-D7AE-11d2-9C10-00C04F8372FF}
extern const GUID IID_ITextureManager = 
{ 0xa8d336b4, 0xd7ae, 0x11d2, { 0x9c, 0x10, 0x0, 0xc0, 0x4f, 0x83, 0x72, 0xff } };

// {A8D336B3-D7AE-11d2-9C10-00C04F8372FF}
extern const GUID IID_ITextureHandle = 
{ 0xa8d336b3, 0xd7ae, 0x11d2, { 0x9c, 0x10, 0x0, 0xc0, 0x4f, 0x83, 0x72, 0xff } };

// {A8D336B2-D7AE-11d2-9C10-00C04F8372FF}
extern const GUID IID_IConfig = 
{ 0xa8d336b2, 0xd7ae, 0x11d2, { 0x9c, 0x10, 0x0, 0xc0, 0x4f, 0x83, 0x72, 0xff } };

// {46197003-53F9-11d2-9C9A-00EA4EC10070}
extern const GUID IID_IGraphics3D =
{ 0x46197003, 0x53f9, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {46197004-53F9-11d2-9C9A-00EA4EC10070}
extern const GUID IID_IGraphicsInfo =
{ 0x46197004, 0x53f9, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {46197006-53F9-11d2-9C9A-00EA4EC10070}
extern const GUID IID_IGraphics2D =
{ 0x46197006, 0x53f9, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {13ECE925-6927-11d2-9C9A-90EB4EC10203}
extern const GUID IID_IGraphics2DFactory =
{ 0x13ece925, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {99B19702-6156-11d2-9C9A-10B74EC10203}
//extern const GUID IID_ITextureCache =
//{ 0x99b19702, 0x6156, 0x11d2, { 0x9c, 0x9a, 0x10, 0xb7, 0x4e, 0xc1, 0x2, 0x3 } };

// {99B19704-6156-11d2-9C9A-10B74EC10203}
extern const GUID IID_IWorld =
{ 0x99b19704, 0x6156, 0x11d2, { 0x9c, 0x9a, 0x10, 0xb7, 0x4e, 0xc1, 0x2, 0x3 } };

// {99B19705-6156-11d2-9C9A-10B74EC10203}
extern const GUID IID_ISystem =
{ 0x99b19705, 0x6156, 0x11d2, { 0x9c, 0x9a, 0x10, 0xb7, 0x4e, 0xc1, 0x2, 0x3 } };

// {99B19706-6156-11d2-9C9A-10B74EC10203}
extern const GUID IID_IGraphicsContextFactory =
{ 0x99b19706, 0x6156, 0x11d2, { 0x9c, 0x9a, 0x10, 0xb7, 0x4e, 0xc1, 0x2, 0x3 } };

// {99B1970A-6156-11d2-9C9A-10B74EC10203}
extern const GUID IID_IPolygon3D =
{ 0x99b1970a, 0x6156, 0x11d2, { 0x9c, 0x9a, 0x10, 0xb7, 0x4e, 0xc1, 0x2, 0x3 } };

// {99B1970B-6156-11d2-9C9A-10B74EC10203}
extern const GUID IID_IPolygonSet =
{ 0x99b1970b, 0x6156, 0x11d2, { 0x9c, 0x9a, 0x10, 0xb7, 0x4e, 0xc1, 0x2, 0x3 } };

// {99B1970D-6156-11d2-9C9A-10B74EC10203}
extern const GUID IID_ICamera =
{ 0x99b1970d, 0x6156, 0x11d2, { 0x9c, 0x9a, 0x10, 0xb7, 0x4e, 0xc1, 0x2, 0x3 } };

// {A8D336B1-D7AE-11d2-9C10-00C04F8372FF}
extern const GUID IID_IEngineConfig = 
{ 0xa8d336b1, 0xd7ae, 0x11d2, { 0x9c, 0x10, 0x0, 0xc0, 0x4f, 0x83, 0x72, 0xff } };

// {99B1970E-6156-11d2-9C9A-10B74EC10203}
extern const GUID IID_ITextureContainer =
{ 0x99b1970e, 0x6156, 0x11d2, { 0x9c, 0x9a, 0x10, 0xb7, 0x4e, 0xc1, 0x2, 0x3 } };

// {99B1970F-6156-11d2-9C9A-10B74EC10203}
extern const GUID IID_ITextureMap =
{ 0x99b1970f, 0x6156, 0x11d2, { 0x9c, 0x9a, 0x10, 0xb7, 0x4e, 0xc1, 0x2, 0x3 } };

// {99B19715-6156-11d2-9C9A-10B74EC10203}
extern const GUID IID_IPolygonTexture =
{ 0x99b19715, 0x6156, 0x11d2, { 0x9c, 0x9a, 0x10, 0xb7, 0x4e, 0xc1, 0x2, 0x3 } };

// {B57AC761-96E7-11d2-9C9A-444553540000}
extern const GUID IID_IHaloRasterizer =
{ 0xb57ac761, 0x96e7, 0x11d2, { 0x9c, 0x9a, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0 } };

// --- Network interfaces

// {94454760-9F1A-11d2-811C-00606723088E}
extern const GUID IID_INetworkDriver =
{ 0x94454760, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {94454761-9F1A-11d2-811C-00606723088E}
extern const GUID IID_INetworkDriverFactory =
{ 0x94454761, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {94454768-9F1A-11d2-811C-00606723088E}
extern const GUID IID_INetworkManager = 
{ 0x94454768, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {94454769-9F1A-11d2-811C-00606723088E}
extern const GUID IID_INetworkManagerFactory = 
{ 0x94454769, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// --- Sound interfaces

// {F82D8FE7-9F19-11d2-811C-00606723088E}
extern const GUID IID_ISoundRender =
{ 0xf82d8fe7, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82D8FE8-9F19-11d2-811C-00606723088E}
extern const GUID IID_ISoundRenderFactory =
{ 0xf82d8fe8, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82D8FE2-9F19-11d2-811C-00606723088E}
extern const GUID IID_ISoundListener =
{ 0xf82d8fe2, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82D8FF2-9F19-11d2-811C-00606723088E}
extern const GUID IID_ISoundSource =
{ 0xf82d8ff2, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82D9FF2-9F19-11d2-811C-00606723088E}
extern const GUID IID_ISoundDriver =
{ 0xf82d9ff2, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82D8FE8-9F29-11d2-811C-00606723088E}
extern const GUID IID_ISoundDriverFactory =
{ 0xf82d8fe8, 0x9f29, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

//----------------------------- System-specific Interface Identifiers (IIDs) ---

// --- System drivers

// {3e0fb2e4-b6ef-11d2-af9f-00201881660c}
extern const GUID IID_ISVGALibSystemDriver =
{ 0x3e0fb2e4, 0xb6ef, 0x11d2, { 0xaf, 0x9f, 0x00, 0x20, 0x18, 0x81, 0x66, 0x0c } };

// {13ECE924-6927-11d2-9C9A-90EB4EC10203}
extern const GUID IID_IUnixSystemDriver =
{ 0x13ece924, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {D7DD2BA0-8511-11d2-8A95-B92FCA0D7938}
extern const GUID IID_IOS2SystemDriver =
{ 0xd7dd2ba0, 0x8511, 0x11d2, { 0x8a, 0x95, 0xb9, 0x2f, 0xca, 0xd, 0x79, 0x38 } };

// {13ECE92B-6927-11d2-9C9A-90EB4EC10203}
extern const GUID IID_IDosSystemDriver =
{ 0x13ece92b, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {F82D8FE0-9F19-11d2-811C-00606723088E}
extern const GUID IID_INeXTSystemDriver =
{ 0xf82d8fe0, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {2EA163A1-66DD-11d2-9C9A-E0EB4EC10070}
extern const GUID IID_IWin32SystemDriver =
{ 0x2ea163a1, 0x66dd, 0x11d2, { 0x9c, 0x9a, 0xe0, 0xeb, 0x4e, 0xc1, 0x0, 0x70 } };

// {13ECE928-6927-11d2-9C9A-90EB4EC10203}
extern const GUID IID_IBeLibSystemDriver =
{ 0x13ece928, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// --- GraphicsInfo drivers

// {13ECE92E-6927-11d2-9C9A-90EB4EC10203}
extern const GUID IID_IGlide2xGraphicsInfo =
{ 0x13ece92e, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {13FCE92E-6927-11d2-9C9A-90EB4EC10203}
extern const GUID IID_IGlide3xGraphicsInfo =
{ 0x13fce92e, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {13ECf92E-6927-11d2-9C9A-90EB4EC10203}
extern const GUID IID_IOpenGLGraphicsInfo =
{ 0x13ecf92e, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {46197005-53F9-11d2-9C9A-00EA4EC10070}
extern const GUID IID_IDDraw3GraphicsInfo =
{ 0x46197005, 0x53f9, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {46197005-53F9-11d2-9C9A-00EA4EC10070}
extern const GUID IID_IDDraw6GraphicsInfo =
{ 0x46197015, 0x53f9, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// --- 2D graphics info interfaces (better avoid them)

// {03712882-A57A-11d2-8B6D-0008C7CAE3C8}
extern const GUID IID_IMacGraphicsInfo =
{ 0x3712882, 0x57a7, 0x11d2, { 0x8b, 0x6d, 0x0, 0x8, 0xc7, 0xca, 0xe3, 0xc8 } };

// {13ECE929-6927-11d2-9C9A-90EB4EC10203}
extern const GUID IID_IBeLibGraphicsInfo =
{ 0x13ece929, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// --- Class factory interfaces

// {13ECE930-6927-11d2-9C9A-90EB4EC10203}
extern const GUID IID_IGraphics2DOpenGLFactory =
{ 0x13ece940, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {13ECE922-6927-11d2-9C9A-90EB4EC10203}
extern const GUID IID_IGraphics2DDirect3DFactory =
{ 0x13ece922, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {13ECE930-6927-11d2-9C9A-90EB4EC10203}
extern const GUID IID_IGraphics2DGlideFactory =
{ 0x13ece930, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {F82D8FE4-9F19-11d2-811C-00606723088E}
extern const GUID IID_IGraphics2DRaveFactory =
{ 0xf82d8fe4, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

//------------------------------- System-specific Class Identifiers (CLSIDs) ---

// --- 2D drivers

// {13EDE927-6927-11d2-9C9A-90EB4EC10203}
extern const GUID CLSID_XLibGraphics2D =
{ 0x13ede927, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {ae0e9430-b6e9-11d2-b7c6-00201881660c}
extern const GUID CLSID_SVGALibGraphics2D =
{ 0xae0e9430, 0xb6e9, 0x11d2, { 0xb7, 0xc6, 0x00, 0x20, 0x18, 0x81, 0x66, 0x0c } };

// {13ECE930-6927-11d2-9C9A-90EB4EC10203}
extern const GUID CLSID_GGIGraphics2D =
{ 0x13ece930, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {F82D8FE8-9F19-11d2-811C-00606723088E}
extern const GUID CLSID_BeLibGraphics2D =
{ 0xf82d8fe8, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {D7DD2BA1-8511-11d2-8A95-B92FCA0D7938}
extern const GUID CLSID_OS2DiveGraphics2D =
{ 0xd7dd2ba1, 0x8511, 0x11d2, { 0x8a, 0x95, 0xb9, 0x2f, 0xca, 0xd, 0x79, 0x38 } };

// {13ECE92C-6927-11d2-9C9A-90EB4EC10203}
extern const GUID CLSID_DosRawGraphics2D =
{ 0x13ece92c, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {D7DD2BA1-8511-11d2-8A95-B92FCA0D7938}
extern const GUID CLSID_OpenGLGraphics2D =
{ 0xd7dd2ba2, 0x8511, 0x11d2, { 0x8a, 0x95, 0xb9, 0x2f, 0xca, 0xd, 0x79, 0x38 } };

// {E7DD2BA1-8511-11d2-8A95-B92FCA0D7938}
extern const GUID CLSID_WGLGraphics2D =
{ 0xe7dd2ba2, 0x8511, 0x11d2, { 0x8a, 0x95, 0xb9, 0x2f, 0xca, 0xd, 0x79, 0x38 } };

// {96e47fa0-c5c0-11d2-8a24-00201881660c}
extern const GUID CLSID_GlideXGraphics2D =
{ 0x96e47fa0, 0xc5c0, 0x11d2, { 0x8a, 0x24, 0x00, 0x20, 0x18, 0x81, 0x66, 0x0c } };

// {F82D8FE1-9F19-11d2-811C-00606723088E}
extern const GUID CLSID_NeXTGraphics2D =
{ 0xf82d8fe1, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {03712883-A57A-11d2-8B6D-0008C7CAE3C8}
extern const GUID CLSID_MacGraphics2D =
{ 0x3712883, 0x57a7, 0x11d2, { 0x8b, 0x6d, 0x0, 0x8, 0xc7, 0xca, 0xe3, 0xc8 } };

// {13ECE926-6927-11d2-9C9A-90EB4EC10203}
extern const GUID CLSID_GLXGraphics2D =
{ 0x13ece926, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {2EA163A5-66DD-11d2-9C9A-E0EB4EC10070}
extern const GUID CLSID_DirectDrawGraphics2D =
{ 0x2ea163a5, 0x66dd, 0x11d2, { 0x9c, 0x9a, 0xe0, 0xeb, 0x4e, 0xc1, 0x0, 0x70 } };

// {13ECE921-6927-11d2-9C9A-90EB4EC10203}
extern const GUID CLSID_DirectDrawWith3DGraphics2D =
{ 0x13ece921, 0x6927, 0x11d2, { 0x9c, 0x9a, 0x90, 0xeb, 0x4e, 0xc1, 0x2, 0x3 } };

// {2EA163B5-66DD-11d2-9C9A-E0EB4EC10070}
extern const GUID CLSID_DirectDrawDX6With3DGraphics2D =
{ 0x2ea163B5, 0x66dd, 0x11d2, { 0x9c, 0x9a, 0xe0, 0xeb, 0x4e, 0xc1, 0x0, 0x70 } };

// {F82D8FE3-9F19-11d2-811C-00606723088E}
extern const GUID CLSID_GLBeGraphics2D =
{ 0xf82d8fe3, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {6B922AF4-1085-11d3-B6E0-0060085B2681}
extern const GUID CLSID_GlideBeGraphics2D =
{ 0x6b922af4, 0x1085, 0x11d3, { 0xb6, 0xe0, 0x0, 0x60, 0x8, 0x5b, 0x26, 0x81 } };

// {03712886-A57A-11d2-8B6D-0008C7CAE3C8}
extern const GUID CLSID_RaveGraphics2D =
{ 0x03712886, 0xa57a, 0x11d2, { 0x8b, 0x6d, 0x0, 0x8, 0xc7, 0xca, 0xe3, 0xc8 } };

// {F82D8FE5-9F19-11d2-811C-00606723088E}
extern const GUID CLSID_AAGraphics2D =
{ 0xf82d8fe5, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// --- 3D drivers (renderers)

// {EA5FDD01-57D4-11d2-9C9A-00EA4EC10070}
extern const GUID CLSID_SoftwareGraphics3D =
{ 0xea5fdd01, 0x57d4, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {EA5FDD02-57D4-11d2-9C9A-00EA4EC10070}
extern const GUID CLSID_Direct3DDX5Graphics3D =
{ 0xea5fdd02, 0x57d4, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {EA5FDDA2-57D4-11d2-9C9A-00EA4EC10070}
extern const GUID CLSID_Direct3DDX6Graphics3D =
{ 0xea5fdda2, 0x57d4, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {EA5FDD03-57D4-11d2-9C9A-00EA4EC10070}
extern const GUID CLSID_OpenGLGraphics3D =
{ 0xea5fdd03, 0x57d4, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {EA5FDD04-57D4-11d2-9C9A-00EA4EC10070}
extern const GUID CLSID_Glide2xGraphics3D =
{ 0xea5fdd04, 0x57d4, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {EA5FDDB4-57D4-11d2-9C9A-00EA4EC10070}
extern const GUID CLSID_Glide3xGraphics3D =
{ 0xea5fddb4, 0x57d4, 0x11d2, { 0x9c, 0x9a, 0x0, 0xea, 0x4e, 0xc1, 0x0, 0x70 } };

// {03712884-A57A-11d2-8B6D-0008C7CAE3C8}
extern const GUID CLSID_RaveGraphics3D =
{ 0x03712884, 0xa57a, 0x11d2, { 0x8b, 0x6d, 0x0, 0x8, 0xc7, 0xca, 0xe3, 0xc8 } };

// --- Network drivers

// {94454762-9F1A-11d2-811C-00606723088E}
extern const GUID CLSID_NullNetworkDriver =
{ 0x94454762, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {94454763-9F1A-11d2-811C-00606723088E}
extern const GUID CLSID_SocketsNetworkDriver =
{ 0x94454763, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {9445476A-9F1A-11d2-811C-00606723088E}
extern const GUID CLSID_NullNetworkManager =
{ 0x9445476A, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {9445476B-9F1A-11d2-811C-00606723088E}
extern const GUID CLSID_SimpleNetworkManager =
{ 0x9445476B, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// --- Sound Drivers (Low Level)

// {F82F8FE6-9F19-11d2-811C-00606723088E}
extern const GUID CLSID_NullSoundDriver =
{ 0xf82f8fe6, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82F8FE6-9F19-11d2-812C-00606723088E}
extern const GUID CLSID_waveOutSoundDriver =
{ 0xf82f8fe6, 0x9f19, 0x12d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82D8FE7-9F19-11d2-811C-00606723088E}
extern const GUID CLSID_OSSSoundDriver =
{ 0xf82d8fe7, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82D8FE2-9F19-11d2-811C-00606723088E}
extern const GUID CLSID_MacSoundDriver =
{ 0xa8d336b0, 0xd7ae, 0x11d2, { 0x9c, 0x10, 0x0, 0xc0, 0x4f, 0x83, 0x72, 0xff } };

// --- Sound Renderers

// {F82D8FE6-9F19-11d2-811C-00606723088E}
extern const GUID CLSID_NullSoundRender =
{ 0xf82d8fe6, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82D8FE3-9F19-11d2-811C-00606723088E}
extern const GUID CLSID_A3DSoundRender =
{ 0xf82d8fe3, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82D8FE4-9F19-11d2-811C-00606723088E}
extern const GUID CLSID_SoftwareSoundRender =
{ 0xf82d8fe4, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82D8FE5-9F19-11d2-811C-00606723088E}
extern const GUID CLSID_DS3DSoundRender =
{ 0xf82d8fe5, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {F82D8FE4-9F19-11d2-811D-00606723088E}
extern const GUID CLSID_EAXSoundRender =
{ 0xf82d8fe4, 0x9f19, 0x11d2, { 0x81, 0x1d, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// --------------------------------------------------- Useless Junk (UJs :-) ---


/*

// Following GUIDs are RESERVED by Serguei 'Snaar' Narojnyi for network subsystem

// {94454764-9F1A-11d2-811C-00606723088E}
extern const GUID <<name>> =
{ 0x94454764, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {94454765-9F1A-11d2-811C-00606723088E}
extern const GUID <<name>> =
{ 0x94454765, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {94454766-9F1A-11d2-811C-00606723088E}
extern const GUID <<name>> =
{ 0x94454766, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {94454767-9F1A-11d2-811C-00606723088E}
extern const GUID <<name>> =
{ 0x94454767, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {9445476C-9F1A-11d2-811C-00606723088E}
extern const GUID <<name>> =
{ 0x9445476C, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {9445476D-9F1A-11d2-811C-00606723088E}
extern const GUID <<name>> =
{ 0x9445476D, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {9445476E-9F1A-11d2-811C-00606723088E}
extern const GUID <<name>> =
{ 0x9445476E, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {9445476F-9F1A-11d2-811C-00606723088E}
extern const GUID <<name>> =
{ 0x9445476F, 0x9f1a, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

*/

//----------------------------------------------- Unused identifiers (GUIDs) ---
/*
    ATTN: If you need a GUID, these are generated ones that you may use.

// {F82D8FE6-9F19-11d2-811C-00606723088E}
extern const GUID <<name>> =
{ 0xf82d8fe6, 0x9f19, 0x11d2, { 0x81, 0x1c, 0x0, 0x60, 0x67, 0x23, 0x8, 0x8e } };

// {A8D336AE-D7AE-11d2-9C10-00C04F8372FF}
extern const GUID <<name>> = 
{ 0xa8d336ae, 0xd7ae, 0x11d2, { 0x9c, 0x10, 0x0, 0xc0, 0x4f, 0x83, 0x72, 0xff } };

// {A8D336AF-D7AE-11d2-9C10-00C04F8372FF}
extern const GUID <<name>> = 
{ 0xa8d336af, 0xd7ae, 0x11d2, { 0x9c, 0x10, 0x0, 0xc0, 0x4f, 0x83, 0x72, 0xff } };

*/
