/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GWORLD_H
#define GWORLD_H

#include "gobject.h"
#include "gplayer.h"

class geWorld : public geContainer
{
  typedef geContainer inherited;
public:
  geWorld(csWorld* pCsWorld);
  ~geWorld();
  IMPLEMENT_GETYPEINFO(geWorld)
  
  void      SetView  (csView* pView);
  void      SetCamera(gePosition Pos, float Rotation, float Pitch);

  //Creates collider objects for all sectors, things an sprites.
  //should be called after loading the level, beacause otherwise
  //it would Reinitialize some game objects, which is no good thing.
  void      InitCollisionDetection();

  gePlayer*        GetPlayer()  {return m_pPlayer;}
  csWorld*         GetCsWorld() {return m_pCsWorld;}
  virtual geWorld* GetWorld()   {return this;}

protected:
  gePlayer* m_pPlayer;
  csWorld*  m_pCsWorld;
  csView*   m_pView;
};

#endif //GWORLD_H