/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GUTIL_H
#define GUTIL_H

void DisplayFXTextpattern(IGraphics3D* piG3D, ITextureHandle *handle);

/**
  * Draws a line of text using the 3D renderer. 
  */
void WriteText (IGraphics3D* piG3D, ITextureHandle *handle,
  int x, int y, int w, int h, int fontadjust,
  RGBcolor topcolor, RGBcolor bottomcolor,
  UInt mixmode, const char* text);

/**
  * Draws a line of text using the 3D renderer. 
  */
void WriteShandowText(IGraphics3D* piG3D, ITextureHandle *FontHandle,
  ITextureHandle *ShadowHandle, int x, int y, int w, int h, int fontadjust,
  int shadowoffsetx, int shadowoffsety, RGBcolor topcolor, RGBcolor bottomcolor,
  const char* text);

#endif
