/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GUSERINT_H
#define GUSERINT_H

class geSystem;

class geUserInterface
{
public:
  typedef enum {v_align_top,  v_align_bottom, v_align_mid} V_Align;
  typedef enum {h_align_left, h_align_right,  h_align_mid} H_Align;

  geUserInterface(geSystem* pSystem);
  virtual ~geUserInterface();

  virtual bool Init(int argc, char* argv[]);

  virtual void EatKeypress (int key, bool shift, bool alt, bool ctrl);
  virtual void EatMousemove (int x, int y);

  virtual void PrepareFrame (long elapsed_time, long current_time);
  virtual void DrawFrame3d  (long elapsed_time, long current_time);
  virtual void DrawFrame2d  (long elapsed_time, long current_time);

  virtual void Activate()   {;}
  virtual void Deactivate() {;}

  csSprite2D*  CreateSprite(char* name);
  void         DrawSprite(csSprite2D* pSprite, int x, int y, H_Align ha, V_Align va);

protected:
  geSystem* m_pSystem;
  csView*   m_pView;

  /// 3D Graphics context
  IGraphics3D* m_piG3D;
  /// 2D Graphics context
  IGraphics2D* m_piG2D;
  /// the width of this frame
  int m_FrameWidth;
  /// the height of this frame
  int m_FrameHeight;
};


#endif