/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GSYSTEM_H
#define GSYSTEM_H

class geUserInterface;
class geCamera;

class geSystem : public SysSystemDriver
{
  public: 
    geSystem();
    ~geSystem();
    
    bool Init(int argc, char* argv[]);
    void Done();

    virtual void NextFrame (long elapsed_time, long current_time);
    
    virtual void EatKeypress (int key, bool shift, bool alt, bool ctrl);
    virtual void EatMousemove (int x, int y);

    void SetAllUIs   (geUserInterface** pAllUIs) {m_AllUIs = pAllUIs;}
    void SetCurrentUI(int Nr);

    csTextureHandle*  GetTexture(char* name);

    csMouseDriver*    GetMouse()    {return Mouse;}
    csKeyboardDriver* GetKeyboard() {return Keyboard;}
    csView*           GetView()     {return m_pView;}

    //geCamera*         GetCamera()   {return &m_Camera;}

    void EndLoop() {Shutdown = true;}

    geWorld*          m_pWorld;
  protected:
    csWorld*          m_pCsWorld;
    csView*           m_pView;
    geUserInterface*  m_pCurrentUI;
    geUserInterface** m_AllUIs;
    //geCamera          m_Camera;
}; //geSystem

#endif
