/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GESTD_H
#define GESTD_H

//This file is intended to contain all standard headers, to make
//creation of new sourcefiles a bit simpler, but of course this
//will cost some compilertime. Maybe on should declare this file
//as precompiled header.

#include <stdarg.h>

#include "sysdef.h"
#include "igraph3d.h"
#include "itxtmgr.h"
#include "csgeom/math2d.h"
#include "csgeom/math3d.h"
#include "csgeom/csrect.h"
#include "cssys/common/sysdriv.h"
#include "csengine/csview.h"
#include "csengine/dumper.h"
#include "csutil/archive.h"
#include "csutil/inifile.h"
#include "csengine/texture.h"
#include "csengine/sector.h"
#include "csengine/polytext.h"
#include "csengine/library.h"
#include "csengine/world.h"
#include "csengine/csspr2d.h"
#include "csengine/light.h"
#include "csengine/lghtmap.h"
#include "csengine/dynlight.h"
#include "csparser/csloader.h"
#include "csgfxldr/csimage.h"
#include "csgfxldr/gifimage.h"
#include "csgfxldr/rgbpixel.h"
#include "csengine/thing.h"
#include "csengine/thingtpl.h"
#include "csengine/textrans.h"
#include "csengine/collider.h"
#include "csengine/being.h"
#include "csengine/cdobj.h"

//game-engine specific includes:

#include "csgame/gcon.h"

#include "csgame/gpos.h"
#include "csgame/gcollide.h"
#include "csgame/gphoptr.h"

#include "csgame/gobject.h"
#include "csgame/glight.h"
#include "csgame/gspr3d.h"
#include "csgame/gcontain.h"
#include "csgame/gworld.h"
#include "csgame/gexplos.h"
#include "csgame/gphysobj.h"
#include "csgame/gbullet.h"
#include "csgame/gbeing.h"
#include "csgame/gplayer.h"
#include "csgame/gmonster.h"
#include "csgame/gutil.h"
#include "csgame/gsystem.h"
#include "csgame/guserint.h"

#endif //GESTD_H
