/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GPLAYER_H
#define GPLAYER_H

#include "gphysobj.h"
#include "gbeing.h"

class gePlayer : public geBeing 
{
  typedef geBeing inherited;
public:
  gePlayer(geContainer* pContainer);
  virtual ~gePlayer();
  IMPLEMENT_GETYPEINFO(gePlayer)
  
  csVector3 GetViewDirection();

  virtual void PrepareFrame(long elapsed_time, long current_time);

  virtual void Walk  (float distance);
  virtual void Strafe(float distance);
  virtual void Shoot ();

  void  Pitch      (float angle) {SetPitch(m_Pitch + angle);}
  void  Rotate     (float angle) {m_Rotation += angle;}
  
  void  SetPitch   (float angle);
  void  SetRotation(float angle) {m_Rotation  = angle;}

  float GetPitch   ()            {return m_Pitch;}
  float GetRotation()            {return m_Rotation;}

protected:
  float m_Rotation;
  float m_Pitch;

  float m_TotalDistance;
};

#endif //GPLAYER_H