/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GPHYSOBJ_H
#define GPHYSOBJ_H

#include "gcontain.h"

class gePhysicalObject : public geContainer
{
  typedef geContainer inherited;
public:
  gePhysicalObject(geContainer* pContainer);
  ~gePhysicalObject();
  IMPLEMENT_GETYPEINFO(gePhysicalObject)

/** Is called, if a contained object is having a collision with another 
  * physical object
  *
  * Param:
  * pOther: Pointer to the other physical Object involved in the collision. 
  */
  virtual void OnCollision(gePhysicalObject* /*pOther*/) {}

/** Is called, when a conatined sprite has finished an animation cycle.
  * That can be used to switch to another animation (For instance, switch
  * to a lying animation, after falling has finished.
  *
  * Param:
  * pSprite: The sprite that finished the animation. 
  */
  virtual void OnFinishedAnimation(geSprite3D* /*pSprite*/) {}

/** Is called when a physical object is being hit by a bullet, or is being 
  * given damage in another way. 
  *
  * Param:
  * Damage:     The original Damage intended for the Object. Can be decreased
  *             by armour or special skills in derived classes 
  * pHitObject: Pointer to the object that caused the "hit" event. Usually
  *             an object of class geBullet. (at the moment)
  */
  virtual void Hit(int /*Damage*/, gePhysicalObject* /*pHitObject*/) {}

/** Sets the current position, and might do further initialisation in the 
  * future.
  *
  * Param: 
  * Pos: The position of the Object
  */
  void Create(gePosition Pos) {m_Pos = Pos;}

  /// Overridden from geObject
  virtual bool Move(csVector3 Offset);
protected:
  geSprite3D* m_pSprite;
};

#endif //GPHYSOBJ_H
