/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GLIGHT_H
#define GLIGHT_H

#include "gobject.h"

const DWORD TypeGeLight = 1;

class geLight : public geObject
{
  typedef geObject inherited;
public:
  geLight(geContainer* pContainer);
  ~geLight();
  IMPLEMENT_GETYPEINFO(geLight)
  
  //Every Light needs to be created once.
  virtual void Create   (gePosition Pos, float radius, float r, float g, float b);

  //You can modify Color and radius as often as you like. But be
  //aware, that this operation is pretty expensive!
  virtual void SetColor (float r, float g, float b);
  virtual void SetRadius(float radius);

protected:
  virtual void OnMove(gePosition OldPos);

  csDynLight* m_pLight;
};

#endif //GLIGHT_H

