/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GCONTAIN_H
#define GCONTAIN_H

#include "gobject.h"

class geContainer : public geObject
{
  typedef geObject inherited;
public:
  geContainer(geContainer* pContainer);
  virtual ~geContainer();
  IMPLEMENT_GETYPEINFO(geContainer)

  virtual void AddObject(geObject* pObject);
  
  int       GetNumObjects()   {return m_ContainedObjects.Length();}
  geObject* GetObject(int Nr) {return (geObject*) m_ContainedObjects[Nr];}

/** Adds a object to the list of objects to be purged, but will 
  * not remove it from the list of objects. Objects will be deleted
  * the next time PurgeObjects() will be called. */
  virtual void FreeObject(geObject* pObject);

/** Adds a object to the list of objects to be removed, but will not 
  * remove it from the list of objects. Objects will be removed
  * from that the next time PurgeObjects() will be called, but will
  * not be deleted.*/
  virtual void UnmanageObject(geObject* pObject);

/** Purges all objects*/
  virtual void PurgeObjects();

/** Is called before the rendering of a frame*/
  virtual void PrepareFrame(long elapsed_time, long current_time);

protected:
  csVector  m_ContainedObjects;
  csVector  m_ObjectsToBePurged;
  csVector  m_ObjectsToBeRemoved;
};

#endif //GCONTAIN_H



