/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef GBULLET_H
#define GBULLET_H

#include "gphysobj.h"

class geLight;
class geSprite3D;

class geBullet : public gePhysicalObject
{
  typedef gePhysicalObject inherited;
public:
  geBullet(geContainer* pContainer);
  ~geBullet();
  IMPLEMENT_GETYPEINFO(geBullet)

  virtual void Create(gePosition Pos, const char* SpriteName, const char* ActionName, int damage);
  virtual void Destroy();


/** Is called, if a contained object is having a collision with another object*/
  virtual void OnCollision(gePhysicalObject* pOther);

/** removes the bullet and replaces it by an explosion*/
  virtual void Explode();

protected:
  virtual void OnMove(gePosition OldPos);

  int         m_Damage;
  geLight*    m_pLight;
};

#endif //GBULLET_H