/*
    Copyright (C) 1998 by Jorrit Tyberghein

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef SIMPLE_H
#define SIMPLE_H

#include <stdarg.h>
#include "cssys/common/sysdriv.h"
#include "csgeom/math2d.h"
#include "csgeom/math3d.h"

class csSector;
class csView;
class csWorld;
class csDynLight;

class Simple : public SysSystemDriver
{
public:
  csSector* room;
  csView* view;
  csWorld* world;
  csDynLight* dynlight;
  float angle;

public:
  Simple ();
  virtual ~Simple ();

  void InitApp ();

  virtual void NextFrame (long elapsed_time, long current_time);
  void eatkeypress (int key, bool shift, bool alt, bool ctrl, float elapsed_time);
};

#endif // SIMPLE_H

