# Application description
DESCRIPTION.shoot = Crystal Shooter demo game

#-------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Application-specific help commands
APPHELP += $(NEWLINE)echo $"  make shoot        Make the $(DESCRIPTION.shoot)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#-------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: shoot

all apps: shoot
shoot:
	$(MAKE_TARGET)

endif # ifeq ($(MAKESECTION),roottargets)

#-------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp apps/shooter apps/support

SHOOTER.EXE=shooter$(EXE)
SRC.SHOOTER = $(wildcard apps/shooter/*.cpp) \
  apps/support/static.cpp apps/support/cspace.cpp apps/support/command.cpp
OBJ.SHOOTER = $(addprefix $(OUT),$(notdir $(SRC.SHOOTER:.cpp=$O)))
DESCRIPTION.$(SHOOTER.EXE) = $(DESCRIPTION.shoot)

endif # ifeq ($(MAKESECTION),postdefines)

#------------------------------------------------------------------ targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: shoot shootclean

all: $(SHOOTER.EXE)
shoot: $(OUTDIRS) $(SHOOTER.EXE)
clean: shootclean

$(SHOOTER.EXE): $(DEP.EXE) $(OBJ.SHOOTER) \
  $(CSGAME.LIB) $(CSPARSER.LIB) $(CSSCRIPT.LIB) $(CSENGINE.LIB) \
  $(CSTOOLS.LIB) $(CSGEOM.LIB) $(CSSNDLDR.LIB) $(CSGFXLDR.LIB) \
  $(CSUTIL.LIB) $(CSCOM.LIB) $(CSSYS.LIB) $(CSINPUT.LIB) $(CSOBJECT.LIB)
	$(DO.LINK.EXE)

shootclean:
	-$(RM) $(SHOOTER.EXE)

ifdef DO_DEPEND
depend: $(OUTOS)shooter.dep
$(OUTOS)shooter.dep: $(SRC.SHOOTER)
	$(DO.DEP)
else
-include $(OUTOS)shooter.dep
endif

endif # ifeq ($(MAKESECTION),targets)
