/*  
    Crystal Shooter, a first person shooter game engine.
    Homepage: http://members.xoom.com/thieber/cs

    Copyright (C) 1999 Thomas Hieber (thieber@gmx.net)
 
    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program; if not, write to the Free Software 
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef SHOOTER_H
#define SHOOTER_H

class geSystem;

//---------------------------------------------------------------------------

//---------------------------------------------------------------------------

class geMenuInterface : public geUserInterface
{
  typedef geUserInterface inherited;
public:
  geMenuInterface(geSystem* pSystem);
  virtual ~geMenuInterface();

  virtual bool Init(int argc, char* argv[]);

  virtual void EatKeypress (int key, bool shift, bool alt, bool ctrl);

  virtual void PrepareFrame (long elapsed_time, long current_time);

  virtual void DrawFrame3d  (long elapsed_time, long current_time);
  virtual void DrawFrame2d  (long elapsed_time, long current_time);

  virtual void Write(int x, int y, int size, RGBcolor topcolor, RGBcolor bottomcolor, const char* text);

  virtual void Activate();

protected:
  int             m_CurrentOption;

  ITextureHandle* m_Font;
  ITextureHandle* m_Shadow;

  csSprite2D* m_pLogo;
  csSprite2D* m_pLegal;
  csSprite2D* m_pCslogo;
  csSprite2D* m_pCslegal;
  csSprite2D* m_pNew1;
  csSprite2D* m_pNew2;
  csSprite2D* m_pLoad1;
  csSprite2D* m_pLoad2;
  csSprite2D* m_pOptions1;
  csSprite2D* m_pOptions2;
  csSprite2D* m_pQuit1;
  csSprite2D* m_pQuit2;
};

//---------------------------------------------------------------------------

class geGameInterface : public geUserInterface
{
  typedef geUserInterface inherited;
public:
  geGameInterface(geSystem* pSystem);
  virtual ~geGameInterface();

  virtual bool Init(int argc, char* argv[]);

  virtual void EatKeypress (int key, bool shift, bool alt, bool ctrl);
  virtual void EatMousemove (int x, int y);

  virtual void PrepareFrame (long elapsed_time, long current_time);
  virtual void DrawFrame2d  (long elapsed_time, long current_time);

  virtual void MoveCamera(long elapsed_time);
  virtual void DoCollisionDetection();

protected:
};

//---------------------------------------------------------------------------

class geCamera
{
public:
  geCamera();
  ~geCamera();
  void AdjustCamera(csCamera* pCamera);

  csVector3 m_CameraPosition;
  double    m_CameraRotation;
  double    m_CameraPitch;
};

//---------------------------------------------------------------------------

class geShooter
{
public:
  enum 
  {
    MenuUI,
    GameUI,
    NumUIs
  };

  geShooter();
  virtual ~geShooter();

  virtual bool Init(int argc, char* argv[]);
  virtual void Go();

protected:
  geUserInterface** m_AllUIs;
  geSystem*         m_pSystem;
};  //geShooter

#endif //SHOOTER_H