/*
    Copyright (C) 1998 by Jorrit Tyberghein

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define SYSDEF_ACCESS
#include "sysdef.h"
#include "version.h"
#include "cssys/common/system.h"
#include "ndrvdemo/core.h"
#include "cstools/simpcons.h"
#include "csgeom/csrect.h"
#include "csengine/being.h"
#include "csutil/inifile.h"
#include "igraph3d.h"
#include "itxtmgr.h"

#if defined(OS_DOS) || defined(OS_WIN32) || defined (OS_OS2)
#  include <io.h>
#elif defined(OS_UNIX)
#  include <unistd.h>
#endif

App *Sys;

#define Gfx3D System->piG3D
#define Gfx2D System->piG2D

void cleanup ()
{
  pprintf ("Cleaning up...\n");
  csBeing::EndWorld ();
  CHK (delete Sys); Sys = NULL;
  pprintf_close();
}

void debug_dump ()
{
}

struct DemoInfo
{
  csWorld* world;
};

App::App () : SysSystemDriver ()
{
}

App::~App ()
{
}

DemoInfo* demo_info = NULL;

void start_demo ()
{
  CHK (demo_info = new DemoInfo);
  CHK (Sys->world = demo_info->world = new csWorld ());

  ITextureManager* txtmgr;
  Gfx3D->GetTextureManager (&txtmgr);
  demo_info->world->Initialize (GetISystemFromSystem (System), Gfx3D, config);
  txtmgr->Initialize ();
  txtmgr->ReserveColor (0, 0, 0);
  txtmgr->ReserveColor (255, 255, 255);
  txtmgr->Prepare ();
  ((csSimpleConsole *)System->Console)->SetupColors (txtmgr);
  ((csSimpleConsole *)System->Console)->SetMaxLines (1000);       // Some arbitrary high value.
  ((csSimpleConsole *)System->Console)->SetTransparent (0);
  txtmgr->AllocPalette ();

  if (Gfx2D->BeginDraw() == S_OK)
  {
    Gfx2D->Print (NULL);
    Gfx2D->FinishDraw ();
  }
  System->DemoReady = true;
}

void stop_demo ()
{
  if (demo_info)
  {
    CHK (delete demo_info->world);
    CHK (delete demo_info);
  }
}

int main (int argc, char* argv[])
{
  CHK (Sys = new App ());

  CHK (config = new csIniFile ("ndrvdemo.cfg"));

  CHK (csWorld* world = new csWorld ());

  if (!Sys->Initialize (argc, argv, world->GetEngineConfigCOM ()))
  {
    Sys->Printf (MSG_FATAL_ERROR, "Error initializing system!\n");
    cleanup ();
    fatal_exit (0, false);
  }

  if (!Sys->Open (appname))
  {
    Sys->Printf (MSG_FATAL_ERROR, "Error opening system!\n");
    cleanup ();
    fatal_exit (0, false);
  }

  CHK (System->Console = new csSimpleConsole ());

  start_demo ();

  Sys->Printf (MSG_INITIALIZATION, "Crystal Space version %s (%s).\n", VERSION, RELEASE_DATE);
  Sys->Printf (MSG_INITIALIZATION, appname);
  Sys->Printf (MSG_INITIALIZATION, "\n");
  Sys->Printf (MSG_INITIALIZATION, "Created by Serguei 'Snaar' Narojnyi and others...\n\n");

  InitNet();

  Sys->Loop ();

  stop_demo ();

  cleanup ();

  return 1;
}
