/*
   Copyright (C) 1998, 1999 by Serguei 'Snaar' Narojnyi
   Copyright (C) 1998, 1999 by Jorrit Tyberghein
   Written by Serguei 'Snaar' Narojnyi

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "sysdef.h"
#include "ndrvdemo/core.h"
#include "inetdrv.h"

char appname[] = "Crystal Space Network Driver Demo: Client";

DWORD dwClientSocket;
bool bConnected;

DWORD dwLastConnect = 0;

void DoSomething ()
{
  DWORD dwSize = 512;
  DWORD retval;
  char buf[512];

  retval = Sys->piNetDrv->Receive (dwClientSocket, &dwSize, buf);

  if (retval == S_FALSE)
  {
    Sys->Printf (MSG_INITIALIZATION, "Receive error %i\n", Sys->piNetDrv->GetLastError ());
  }
  else
  {
    Sys->piNetDrv->Kill (dwClientSocket);

    buf[dwSize - 2] = '\n';
    buf[dwSize - 1] = '\0';

    Sys->Printf (MSG_INITIALIZATION, "Received: %s", buf);

    bConnected = false;
    System->Shutdown = true;
  }
}

void Connect ()
{
  CS_NET_ADDRESS addr;

  strcpy (addr.hostnm, "localhost");
  addr.port = 2222;

  DWORD retval;

  retval = Sys->piNetDrv->Connect (dwClientSocket, &addr);

  if (retval == S_FALSE)
  {
    Sys->Printf (MSG_INITIALIZATION, "Connect error %i\n", Sys->piNetDrv->GetLastError ());
  }
  else
  {
    char buf[] = "Where do we want you to go for today?\n";
    DWORD bufsize = sizeof (buf);

    if (Sys->piNetDrv->Send (dwClientSocket, bufsize, buf) == S_FALSE)
    {
      Sys->Printf (MSG_INITIALIZATION, "Send error %i\n", Sys->piNetDrv->GetLastError ());
    }

    Sys->Printf (MSG_INITIALIZATION, "Sent: %s", buf);

    bConnected = true;
  }
}

void App::NextFrame (long elapsed_time, long current_time)
{
  SysSystemDriver::NextFrame (elapsed_time, current_time);

  if (!bConnected)
  {
    if ((Sys->Time () - dwLastConnect) > 1000)
    {
      dwLastConnect = Sys->Time ();
      Connect ();
    }
  }
  else
  {
    DoSomething ();
  }

  csEvent *Event;

  while ((Event = Sys->EventQueue->Get ()) != NULL)
  {
    switch (Event->Type)
    {
      case csevKeyDown:
	if (Event->Key.Code == CSKEY_ESC)
	  System->Shutdown = true;
	break;
    }
    CHK (delete Event);
  }
}

void InitNet ()
{
  dwLastConnect = Sys->Time ();
  DWORD retval;

  bConnected = false;

  retval = Sys->piNetDrv->Spawn (&dwClientSocket, CS_NET_CONNORIENTED);

  if (retval == S_FALSE)
  {
    Sys->Printf (MSG_INITIALIZATION, "Spawn error %i\n", Sys->piNetDrv->GetLastError ());
  }
}
