# Application description
DESCRIPTION.meta = Crystal Space MetaBalls example

#-------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Application-specific help commands
APPHELP += $(NEWLINE)echo $"  make meta         Make the $(DESCRIPTION.meta)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#-------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: meta

all apps: meta
meta:
	$(MAKE_TARGET)

endif # ifeq ($(MAKESECTION),roottargets)

#-------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp apps/metademo apps/support

META.EXE=metademo$(EXE)
SRC.META = $(wildcard apps/metademo/*.cpp) \
  apps/support/static.cpp apps/support/cspace.cpp
OBJ.META = $(addprefix $(OUT),$(notdir $(SRC.META:.cpp=$O)))
DESCRIPTION.$(META.EXE) = $(DESCRIPTION.meta)

endif # ifeq ($(MAKESECTION),postdefines)

#------------------------------------------------------------------ targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: meta metaclean

all: $(META.EXE)
meta: $(OUTDIRS) $(META.EXE)
clean: metaclean

$(META.EXE): $(DEP.EXE) $(OBJ.META) \
  $(CSPARSER.LIB) $(CSENGINE.LIB) $(CSSCRIPT.LIB) \
  $(CSSNDLDR.LIB) $(CSGFXLDR.LIB) $(CSUTIL.LIB) \
  $(CSCOM.LIB) $(CSSYS.LIB) $(CSGEOM.LIB) $(CSINPUT.LIB) $(CSOBJECT.LIB)
	$(DO.LINK.EXE)

metaclean:
	-$(RM) $(META.EXE)

ifdef DO_DEPEND
depend: $(OUTOS)metademo.dep
$(OUTOS)metademo.dep: $(SRC.META)
	$(DO.DEP)
else
-include $(OUTOS)metademo.dep
endif

endif # ifeq ($(MAKESECTION),targets)
