/*
  Maze editor: 3D model class
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Andrew Zabolotny <bit@eltech.ru>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ME_VERTX_H__
#define __ME_VERTX_H__

#include "csgeom/math2d.h"
#include "csgeom/math3d.h"

/**
 * The mz3DVertex class represents a vertex of the 3D model
 */
class mz3DVertex : public csVector3
{
public:
  /// Vertex is selected?
  bool selected;
  /// Texture X & Y
  float u,v;

  /// Initialize needed fields
  mz3DVertex ()
  { selected = false; u = v = 0; }

  /// Initialize a 3D vertex from a 3D vector
  mz3DVertex (const csVector3 &copy)
  { x = copy.x; y = copy.y; z = copy.z; selected = false; u = v = 0; }

  inline void SetTexel (csVector2 &iTexel)
  { u = iTexel.x; v = iTexel.y; }

  /// Assign a 3D vector to 3D vertex
  inline void operator = (const csVector3 &v)
  { x = v.x; y = v.y; z = v.z; selected = false; u = this->v = 0; }

  /// Compare two vertices for equality
  inline bool operator == (const mz3DVertex &v) const
  { return (v.x == x) && (v.y == y) && (v.z == z); }
};

#endif // __ME_VERTX_H__
