/*
  Maze editor: toolbar resources
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Andrew Zabolotny <bit@eltech.ru>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "me_res.h"
#include "me_app.h"

#define TOOLBAR_BUTTON_STYLE (CSBS_DISMISS | CSBS_SELECTABLE | CSBS_SHIFT | CSBS_MULTICHOOSE)

csSprite2D *GetBitmap (csApp *app, int iCode)
{
  switch (iCode)
  {
    case cscmdMzVertex:
      return NewBitmap (app, TOOLBAR_BITMAPS, 288, 0, 32, 32);
    case cscmdMzCreate2D:
      return NewBitmap (app, TOOLBAR_BITMAPS, 0, 0, 32, 32);
    case cscmdMzCreate3D:
      return NewBitmap (app, TOOLBAR_BITMAPS, 32, 0, 32, 32);
    case cscmdMzCreateLight:
      return NewBitmap (app, TOOLBAR_BITMAPS, 64, 0, 32, 32);
    case cscmdMzCreatePoly:
      return NewBitmap (app, TOOLBAR_BITMAPS, 96, 0, 32, 32);
    case cscmdMzSelect:
      return NewBitmap (app, TOOLBAR_BITMAPS, 128, 0, 32, 32);
    case cscmdMzMove:
      return NewBitmap (app, TOOLBAR_BITMAPS, 160, 0, 32, 32);
    case cscmdMzScale2D:
      return NewBitmap (app, TOOLBAR_BITMAPS, 160, 32, 32, 32);
    case cscmdMzScale3D:
      return NewBitmap (app, TOOLBAR_BITMAPS, 160, 64, 32, 32);
    case cscmdMzRotate:
      return NewBitmap (app, TOOLBAR_BITMAPS, 160, 96, 32, 32);
    case cscmdMzSetupAxis:
      return NewBitmap (app, TOOLBAR_BITMAPS, 160, 128, 32, 32);

    case cscmdMzCreateVertex:
      return NewBitmap (app, TOOLBAR_BITMAPS, 288, 32, 32, 32);
    case cscmdMzDeleteVertex:
      return NewBitmap (app, TOOLBAR_BITMAPS, 288, 64, 32, 32);
    case cscmdMzDeleteSelVertices:
      return NewBitmap (app, TOOLBAR_BITMAPS, 288, 96, 32, 32);
    case cscmdMzDeleteSelPolygons:
      return NewBitmap (app, TOOLBAR_BITMAPS, 288, 128, 32, 32);

    case cscmdMzCreateTriangle:
      return NewBitmap (app, TOOLBAR_BITMAPS, 0, 32, 32, 32);
    case cscmdMzCreateSquare:
      return NewBitmap (app, TOOLBAR_BITMAPS, 0, 64, 32, 32);
    case cscmdMzCreateHexagon:
      return NewBitmap (app, TOOLBAR_BITMAPS, 0, 96, 32, 32);
    case cscmdMzCreateOctagon:
      return NewBitmap (app, TOOLBAR_BITMAPS, 0, 128, 32, 32);
    case cscmdMzCreateNgon:
      return NewBitmap (app, TOOLBAR_BITMAPS, 0, 160, 32, 32);

    case cscmdMzCreateBox:
      return NewBitmap (app, TOOLBAR_BITMAPS, 32, 32, 32, 32);
    case cscmdMzCreatePrism:
      return NewBitmap (app, TOOLBAR_BITMAPS, 32, 64, 32, 32);
    case cscmdMzCreatePyramid:
      return NewBitmap (app, TOOLBAR_BITMAPS, 32, 96, 32, 32);
    case cscmdMzCreateTorus:
      return NewBitmap (app, TOOLBAR_BITMAPS, 32, 128, 32, 32);
    case cscmdMzCreateSphere:
      return NewBitmap (app, TOOLBAR_BITMAPS, 32, 160, 32, 32);

    case cscmdMzCreatePolyConnect:
      return NewBitmap (app, TOOLBAR_BITMAPS, 96, 32, 32, 32);
    case cscmdMzCreatePolyTriFan:
      return NewBitmap (app, TOOLBAR_BITMAPS, 96, 64, 32, 32);
    case cscmdMzCreatePolyTriStrip:
      return NewBitmap (app, TOOLBAR_BITMAPS, 96, 96, 32, 32);
    case cscmdMzCreatePolyQuadStrip:
      return NewBitmap (app, TOOLBAR_BITMAPS, 96, 128, 32, 32);

    case cscmdMzVertexSelect:
      return NewBitmap (app, TOOLBAR_BITMAPS, 128, 32, 32, 32);
    case cscmdMzVertexDeselect:
      return NewBitmap (app, TOOLBAR_BITMAPS, 128, 64, 32, 32);
    case cscmdMzVertexInvert:
      return NewBitmap (app, TOOLBAR_BITMAPS, 128, 96, 32, 32);
    case cscmdMzPolySelect:
      return NewBitmap (app, TOOLBAR_BITMAPS, 128, 128, 32, 32);
    case cscmdMzPolyDeselect:
      return NewBitmap (app, TOOLBAR_BITMAPS, 128, 160, 32, 32);
    case cscmdMzPolyInvert:
      return NewBitmap (app, TOOLBAR_BITMAPS, 128, 192, 32, 32);

    case cscmdMzWindowLayout1:
      return NewBitmap (app, TOOLBAR_BITMAPS, 256, 0, 32, 32);
    case cscmdMzWindowLayout2:
      return NewBitmap (app, TOOLBAR_BITMAPS, 256, 32, 32, 32);
    case cscmdMzWindowLayout3:
      return NewBitmap (app, TOOLBAR_BITMAPS, 256, 64, 32, 32);
    case cscmdMzWindowLayout4:
      return NewBitmap (app, TOOLBAR_BITMAPS, 256, 96, 32, 32);
    case cscmdMzWindowCloseAll:
      return NewBitmap (app, TOOLBAR_BITMAPS, 256, 128, 32, 32);
    case cscmdMzWindowLayoutReset:
      return NewBitmap (app, TOOLBAR_BITMAPS, 256, 160, 32, 32);
    case cscmdMzCoordRotate:
      return NewBitmap (app, TOOLBAR_BITMAPS, 320, 0, 32, 32);
    case cscmdMzZoomInOut:
      return NewBitmap (app, TOOLBAR_BITMAPS, 320, 32, 32, 32);
    case cscmdMzZoomToRect:
      return NewBitmap (app, TOOLBAR_BITMAPS, 320, 96, 32, 32);
    case cscmdMzSlideView:
      return NewBitmap (app, TOOLBAR_BITMAPS, 320, 128, 32, 32);
    case cscmdMzToggleGrid:
      return NewBitmap (app, TOOLBAR_BITMAPS, 320, 64, 32, 32);
    case cscmdMzToggleAxis:
      return NewBitmap (app, TOOLBAR_BITMAPS, 320, 160, 32, 32);

    default:
      return NULL;
  } /* endswitch */
}

void InitializeToolbox (csApp *app, csDialog *toolbar)
{
  csNewToolbarButton (toolbar, cscmdMzCreateLight,
    GetBitmap (app, cscmdMzCreateLight), NULL, csbfsThinRect, CSBS_SHIFT | CSBS_MULTICHOOSE);
  csNewToolbarButton (toolbar, cscmdMzVertex,
    GetBitmap (app, GLOBAL_VERTEXMODE), NULL, csbfsThinRect, CSBS_SHIFT | CSBS_MULTICHOOSE);
  csNewToolbarButton (toolbar, cscmdMzCreate2D,
    GetBitmap (app, GLOBAL_CREATE2DMODE), NULL, csbfsThinRect, CSBS_SHIFT | CSBS_MULTICHOOSE);
  csNewToolbarButton (toolbar, cscmdMzCreate3D,
    GetBitmap (app, GLOBAL_CREATE3DMODE), NULL, csbfsThinRect, CSBS_SHIFT | CSBS_MULTICHOOSE);
  csNewToolbarButton (toolbar, cscmdMzCreatePoly,
    GetBitmap (app, GLOBAL_CREATEPOLYMODE), NULL, csbfsThinRect, CSBS_SHIFT | CSBS_MULTICHOOSE);
  csNewToolbarButton (toolbar, cscmdMzSelect,
    GetBitmap (app, GLOBAL_SELECTMODE), NULL, csbfsThinRect, CSBS_SHIFT | CSBS_MULTICHOOSE);
  csNewToolbarButton (toolbar, cscmdMzModify,
    GetBitmap (app, GLOBAL_MODIFYMODE), NULL, csbfsThinRect, CSBS_SHIFT | CSBS_MULTICHOOSE);
  toolbar->SetDragStyle (CS_DRAG_MOVEABLE | CS_DRAG_SIZEABLE);
}

void InitializeVertexToolbar (csApp *app, csDialog *toolbar)
{
  csNewToolbarButton (toolbar, cscmdMzCreateVertex,
    GetBitmap (app, cscmdMzCreateVertex), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzDeleteVertex,
    GetBitmap (app, cscmdMzDeleteVertex), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzDeleteSelVertices,
    GetBitmap (app, cscmdMzDeleteSelVertices), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzDeleteSelPolygons,
    GetBitmap (app, cscmdMzDeleteSelPolygons), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  toolbar->SetDragStyle (CS_DRAG_MOVEABLE);
}

void InitializeCreate2DToolbar (csApp *app, csDialog *toolbar)
{
  csNewToolbarButton (toolbar, cscmdMzCreateTriangle,
    GetBitmap (app, cscmdMzCreateTriangle), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzCreateSquare,
    GetBitmap (app, cscmdMzCreateSquare), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzCreateHexagon,
    GetBitmap (app, cscmdMzCreateHexagon), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzCreateOctagon,
    GetBitmap (app, cscmdMzCreateOctagon), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzCreateNgon,
    GetBitmap (app, cscmdMzCreateNgon), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  toolbar->SetDragStyle (CS_DRAG_MOVEABLE);
}

void InitializeCreate3DToolbar (csApp *app, csDialog *toolbar)
{
  csNewToolbarButton (toolbar, cscmdMzCreateBox,
    GetBitmap (app, cscmdMzCreateBox), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzCreatePrism,
    GetBitmap (app, cscmdMzCreatePrism), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzCreatePyramid,
    GetBitmap (app, cscmdMzCreatePyramid), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzCreateTorus,
    GetBitmap (app, cscmdMzCreateTorus), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzCreateSphere,
    GetBitmap (app, cscmdMzCreateSphere), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  toolbar->SetDragStyle (CS_DRAG_MOVEABLE);
}

void InitializeCreatePolyToolbar (csApp *app, csDialog *toolbar)
{
  csNewToolbarButton (toolbar, cscmdMzCreatePolyConnect,
    GetBitmap (app, cscmdMzCreatePolyConnect), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzCreatePolyTriFan,
    GetBitmap (app, cscmdMzCreatePolyTriFan), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzCreatePolyTriStrip,
    GetBitmap (app, cscmdMzCreatePolyTriStrip), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzCreatePolyQuadStrip,
    GetBitmap (app, cscmdMzCreatePolyQuadStrip), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  toolbar->SetDragStyle (CS_DRAG_MOVEABLE);
}

void InitializeSelectToolbar (csApp *app, csDialog *toolbar)
{
  csNewToolbarButton (toolbar, cscmdMzVertexSelect,
    GetBitmap (app, cscmdMzVertexSelect), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzVertexDeselect,
    GetBitmap (app, cscmdMzVertexDeselect), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzVertexInvert,
    GetBitmap (app, cscmdMzVertexInvert), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzPolySelect,
    GetBitmap (app, cscmdMzPolySelect), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzPolyDeselect,
    GetBitmap (app, cscmdMzPolyDeselect), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzPolyInvert,
    GetBitmap (app, cscmdMzPolyInvert), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  toolbar->SetDragStyle (CS_DRAG_MOVEABLE);
}

void InitializeModifyToolbar (csApp *app, csDialog *toolbar)
{
  csNewToolbarButton (toolbar, cscmdMzMove,
    GetBitmap (app, cscmdMzMove), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzScale2D,
    GetBitmap (app, cscmdMzScale2D), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzScale3D,
    GetBitmap (app, cscmdMzScale3D), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzRotate,
    GetBitmap (app, cscmdMzRotate), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
/*
  csNewToolbarButton (toolbar, cscmdMzSetupAxis,
    GetBitmap (app, cscmdMzSetupAxis), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
*/
  toolbar->SetDragStyle (CS_DRAG_MOVEABLE);
}

void InitializeInfobar (csApp *app, csDialog *toolbar)
{
  (void)app;
  int x;
  int th = toolbar->TextHeight ();
  int y1 = 3 + th * 1;
  int y2 = 3 + th * 2;
  int y3 = 3 + th * 3;
  int y4 = 3 + th * 4;

  CHK (csStatic *px = new csStatic (toolbar, NULL, "X", csscsText));
  CHK (csStatic *py = new csStatic (toolbar, NULL, "Y", csscsText));
  CHK (csStatic *pz = new csStatic (toolbar, NULL, "Z", csscsText));
  CHK (csStatic *pf = new csStatic (toolbar, NULL, "Pointer", csscsFrameLabel));
  x = 4;
  pf->SetRect (x, 2, x + 92, 2 + th * 5);
  px->SetRect (x + 4, y1, x + 16, y2);
  py->SetRect (x + 4, y2, x + 16, y3);
  pz->SetRect (x + 4, y3, x + 16, y4);

  CHK (px = new csStatic (toolbar, NULL, "", csscsText));
  CHK (py = new csStatic (toolbar, NULL, "", csscsText));
  CHK (pz = new csStatic (toolbar, NULL, "", csscsText));
  px->id = MZID_INFO_PTR_X; px->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  px->SetRect (x + 16, y1, x + 88, y2); px->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);
  py->id = MZID_INFO_PTR_Y; py->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  py->SetRect (x + 16, y2, x + 88, y3); py->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);
  pz->id = MZID_INFO_PTR_Z; pz->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  pz->SetRect (x + 16, y3, x + 88, y4); pz->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);

  CHK (csStatic *cx = new csStatic (toolbar, NULL, "Phi", csscsText));
  CHK (csStatic *cy = new csStatic (toolbar, NULL, "Theta", csscsText));
  CHK (csStatic *cz = new csStatic (toolbar, NULL, "Scale", csscsText));
  CHK (csStatic *cf = new csStatic (toolbar, NULL, "View", csscsFrameLabel));
  x = 100;
  cf->SetRect (x, 2, x + 184, 2 + th * 5);
  cx->SetRect (x + 4, y1, x + 44, y2);
  cy->SetRect (x + 4, y2, x + 44, y3);
  cz->SetRect (x + 4, y3, x + 44, y4);

  CHK (cx = new csStatic (toolbar, NULL, "", csscsText));
  CHK (cy = new csStatic (toolbar, NULL, "", csscsText));
  CHK (cz = new csStatic (toolbar, NULL, "", csscsText));
  cx->id = MZID_INFO_VIEW_PHI;   cx->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  cx->SetRect (x + 44, y1, x + 84, y2); cx->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);
  cy->id = MZID_INFO_VIEW_THETA; cy->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  cy->SetRect (x + 44, y2, x + 84, y3); cy->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);
  cz->id = MZID_INFO_VIEW_SCALE; cz->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  cz->SetRect (x + 44, y3, x + 84, y4); cz->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);

  CHK (px = new csStatic (toolbar, NULL, "X", csscsText));
  CHK (py = new csStatic (toolbar, NULL, "Y", csscsText));
  CHK (pz = new csStatic (toolbar, NULL, "Z", csscsText));
  px->SetRect (x + 88, y1, x + 108, y2);
  py->SetRect (x + 88, y2, x + 108, y3);
  pz->SetRect (x + 88, y3, x + 108, y4);

  CHK (px = new csStatic (toolbar, NULL, "", csscsText));
  CHK (py = new csStatic (toolbar, NULL, "", csscsText));
  CHK (pz = new csStatic (toolbar, NULL, "", csscsText));
  px->id = MZID_INFO_VIEW_X; px->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  px->SetRect (x + 108, y1, x + 180, y2); px->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);
  py->id = MZID_INFO_VIEW_Y; py->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  py->SetRect (x + 108, y2, x + 180, y3); py->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);
  pz->id = MZID_INFO_VIEW_Z; pz->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  pz->SetRect (x + 108, y3, x + 180, y4); pz->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);

  CHK (csStatic *sv = new csStatic (toolbar, NULL, "Vertices", csscsText));
  CHK (csStatic *sp = new csStatic (toolbar, NULL, "Polygons", csscsText));
  CHK (csStatic *sl = new csStatic (toolbar, NULL, "Lights", csscsText));
  CHK (csStatic *st = new csStatic (toolbar, NULL, "Textures", csscsText));
  CHK (csStatic *sr = new csStatic (toolbar, NULL, "Frames", csscsText));
  CHK (csStatic *sf = new csStatic (toolbar, NULL, "Statistics", csscsFrameLabel));
  x = 288;
  sf->SetRect (x, 2, x + 210, 2 + th * 5);
  sv->SetRect (x + 4, y1, x + 64, y2);
  sp->SetRect (x + 4, y2, x + 64, y3);
  sl->SetRect (x + 4, y3, x + 64, y4);
  st->SetRect (x + 106, y1, x + 166, y2);
  sr->SetRect (x + 106, y2, x + 166, y3);

  CHK (sv = new csStatic (toolbar, NULL, "", csscsText));
  CHK (sp = new csStatic (toolbar, NULL, "", csscsText));
  CHK (sl = new csStatic (toolbar, NULL, "", csscsText));
  CHK (st = new csStatic (toolbar, NULL, "", csscsText));
  CHK (sr = new csStatic (toolbar, NULL, "", csscsText));
  sv->id = MZID_INFO_VERTICES; sv->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  sv->SetRect (x + 64, y1, x + 104, y2); sv->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);
  sp->id = MZID_INFO_POLYGONS; sp->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  sp->SetRect (x + 64, y2, x + 104, y3); sp->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);
  sl->id = MZID_INFO_LIGHTS; sl->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  sl->SetRect (x + 64, y3, x + 104, y4); sl->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);
  st->id = MZID_INFO_TEXTURES; st->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  st->SetRect (x + 166, y1, x + 206, y2); st->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);
  sr->id = MZID_INFO_FRAMES; sr->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_D);
  sr->SetRect (x + 166, y2, x + 206, y3); sr->SetTextAlign (CSSTA_RIGHT | CSSTA_VCENTER);

  CHK (csStatic *op = new csStatic (toolbar, NULL, "", csscsText));
  op->id = MZID_INFO_CURRENTOP; op->SetColor (CSPAL_STATIC_ITEXT, cs_Color_Red_M);
  op->SetRect (4, 2 + th * 5, 498, 2 + th * 6); op->SetTextAlign (CSSTA_HCENTER | CSSTA_VCENTER);
  op->SetFont (csFontPolice);

  toolbar->SetDragStyle (CS_DRAG_MOVEABLE);
  toolbar->SetSuggestedSize (0, 0);
}

void InitializeWindowManager (csApp *app, csDialog *toolbar)
{
  csButton *b;
  b = csNewToolbarButton (toolbar, cscmdMzWindowLayout1,
    GetBitmap (app, cscmdMzWindowLayout1), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  b->SetState (CSS_GROUP, true);
  csNewToolbarButton (toolbar, cscmdMzWindowLayout2,
    GetBitmap (app, cscmdMzWindowLayout2), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzWindowLayout3,
    GetBitmap (app, cscmdMzWindowLayout3), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzWindowLayout4,
    GetBitmap (app, cscmdMzWindowLayout4), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  b = csNewToolbarButton (toolbar, cscmdMzWindowCloseAll,
    GetBitmap (app, cscmdMzWindowCloseAll), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE & ~CSBS_MULTICHOOSE);
  b->SetState (CSS_GROUP, true);
  csNewToolbarButton (toolbar, cscmdMzWindowLayoutReset,
    GetBitmap (app, cscmdMzWindowLayoutReset), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE & ~CSBS_MULTICHOOSE);
  b = csNewToolbarButton (toolbar, cscmdMzCoordRotate,
    GetBitmap (app, cscmdMzCoordRotate), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  b->SetState (CSS_GROUP, true);
  csNewToolbarButton (toolbar, cscmdMzSlideView,
    GetBitmap (app, cscmdMzSlideView), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzZoomInOut,
    GetBitmap (app, cscmdMzZoomInOut), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  csNewToolbarButton (toolbar, cscmdMzZoomToRect,
    GetBitmap (app, cscmdMzZoomToRect), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE);
  b = csNewToolbarButton (toolbar, cscmdMzToggleGrid,
    GetBitmap (app, cscmdMzToggleGrid), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE & ~CSBS_MULTICHOOSE);
  b->SetState (CSS_GROUP, true);
  b->SetPressed (F_DRAFT_GRID);
  b = csNewToolbarButton (toolbar, cscmdMzToggleAxis,
    GetBitmap (app, cscmdMzToggleAxis), NULL, csbfsThinRect, TOOLBAR_BUTTON_STYLE & ~CSBS_MULTICHOOSE);
  b->SetState (CSS_GROUP, true);
  b->SetPressed (F_DRAFT_AXIS);

  toolbar->SetDragStyle (CS_DRAG_MOVEABLE | CS_DRAG_SIZEABLE);
}
