/*
  Maze editor: 3D model class
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Andrew Zabolotny <bit@eltech.ru>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ME_SPACT_H__
#define __ME_SPACT_H__

#include "csutil/csstrvec.h"
#include "csengine/cssprite.h"

/**
 * This class is used to store actions for 3D sprites. An action is a
 * specific sequence of frames with specific delays. Actions are kept
 * in a csObjVector object in mz3DModel class.
 */
class mzSpriteAction : public csBase
{
  /// Array of frame names
  csStrVector Names;
  /// Array of frame delays
  csVector Delays;

public:
  /// Name of this action
  char *Name;

  /// Create a sprite action object from a csSpriteAction object
  mzSpriteAction (csSpriteAction *iAction);
  /// Destroy a sprite action object
  virtual ~mzSpriteAction ();

  /// Notify action that a frame has been deleted
  void NotifyFrameDeleted (char *iFrameName);

  /// Check if two actions are same
  bool operator == (const mzSpriteAction &a);

  /// Return number of frames in action
  int Frames () const { return Names.Length (); }

  /// Return a reference to given frame delay
  int& Delay (int iFrame) const { return (int &)Delays.Get (iFrame); }

  /// Return given frame name
  char *FrameName (int iFrame) const { return (char *)Names.Get (iFrame); }

  /// Set given frame name
  bool SetFrameName (int iFrame, char *iName);
};

#endif // __ME_SPACT_H__
