/*
  Maze editor: menus, toolbars etc
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Andrew Zabolotny <bit@eltech.ru>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ME_RES_H__

#include "csws/csws.h"
#include "mazed.h"

#define TOOLBAR_BITMAPS		"img/MazeD/ToolBar.png"

// Identification numbers for toolbars and their components
#define MZID_TOOLBOX		0x80000000
#define MZID_WINDOWBAR		0x80000010

#define MZID_INFOBAR		0x80000020
#define MZID_INFO_PTR_X		0x80000021
#define MZID_INFO_PTR_Y		0x80000022
#define MZID_INFO_PTR_Z		0x80000023
#define MZID_INFO_VIEW_X	0x80000024
#define MZID_INFO_VIEW_Y	0x80000025
#define MZID_INFO_VIEW_Z	0x80000026
#define MZID_INFO_VIEW_PHI	0x80000027
#define MZID_INFO_VIEW_THETA	0x80000028
#define MZID_INFO_VIEW_SCALE	0x80000029
#define MZID_INFO_VERTICES	0x8000002a
#define MZID_INFO_POLYGONS	0x8000002b
#define MZID_INFO_LIGHTS	0x8000002c
#define MZID_INFO_TEXTURES	0x8000002d
#define MZID_INFO_FRAMES	0x8000002e
#define MZID_INFO_CURRENTOP	0x8000002f

#define MZID_ACCELERATOR	0x80000040
#define MZID_DRAFTVIEW		0x80000050
#define MZID_3DVIEW		0x80000060

// me_menu.cpp
extern void InitializeMainMenu (csApp *app);
extern void InitializeKeyboardAccelerator (csApp *app);

// me_tbar.cpp
extern csSprite2D *GetBitmap (csApp *app, int iCode);
extern void InitializeToolbox (csApp *app, csDialog *toolbar);
extern void InitializeVertexToolbar (csApp *app, csDialog *toolbar);
extern void InitializeCreate2DToolbar (csApp *app, csDialog *toolbar);
extern void InitializeCreate3DToolbar (csApp *app, csDialog *toolbar);
extern void InitializeCreatePolyToolbar (csApp *app, csDialog *toolbar);
extern void InitializeSelectToolbar (csApp *app, csDialog *toolbar);
extern void InitializeModifyToolbar (csApp *app, csDialog *toolbar);
extern void InitializeInfobar (csApp *app, csDialog *toolbar);
extern void InitializeWindowManager (csApp *app, csDialog *toolbar);

// me_dlg.cpp
struct mzModificationAxis;
extern void ShowAbout (csComponent *app);
extern int ClearModelDialog (csApp *iApp, bool &ioRemoveVertices,
  bool &ioRemoveFaces, bool &ioRemoveLights, bool &ioRemoveFrames,
  bool &ioRemoveActions);
extern int SetupAxisDialog (csApp *iApp, mzModificationAxis &Axis);
extern int NumberOfSidesDialog (csApp *iApp, char *iTitle, int &iSides);
extern int TorusParmDialog (csApp *iApp, int &iRadialDetail,
  int &iCrossSectionDetail);
extern int SphereParmDialog (csApp *iApp, int &iSphereDetail);
extern csWindow *PleaseWaitBox (csApp *iApp, char *iText);
extern void ModelManagerDialog (csApp *iApp);
extern int DraftSetupDialog (csApp *iApp);
extern int LightParmDialog (csApp *iApp, float &iRadius, csColor &iColorValues);
extern void PortalManagerDialog (csApp *iApp);
extern int PolygonInfoDialog (csApp *iApp, mz3DPolygon &sel_poly);

#endif // __ME_RES_H__
