/*
  Maze editor: 3D model class
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Andrew Zabolotny <bit@eltech.ru>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __ME_LIGHT_H__
#define __ME_LIGHT_H__

#include "csgeom/math3d.h"
#include "csengine/cscolor.h"

class mz3DModel;

class mz3DLight : public csBase
{
public:
  /// Light name (initially automatically generated)
  char *Name;
  /// Light is selected?
  bool selected;
  /// Parent model
  mz3DModel *parent;
  /// Light color;
  csColor Color;
  /// Light position
  csVector3 Position;
  /// Light Radius
  float Radius;
  /// Light Halo (Don't quite know what it does, but it's 
  int Cso_type;
  /// Is this light dynamic?
  int Dynamic;

  /// Initialize the light object
  mz3DLight (mz3DModel *iParent);
  /// Copy constructor
  mz3DLight (mz3DLight &iCopy);
  /// Kill light
  virtual ~mz3DLight ();
  /// Set the light's name
  void SetName (const char *iName);
  /// Compare two lights for equality
  bool operator == (const mz3DLight &p) const;
};

#endif // __ME_LIGHT_H__
