/*
  Maze editor: 3D model class
  Copyright (C) 1998 by Jorrit Tyberghein
  Written by Andrew Zabolotny <bit@eltech.ru>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "sysdef.h"
#include "me_model.h"
#include "csutil/util.h"
#include "cssys/common/system.h"

//-----------------------------------------------------// 3D Light class //---//

mz3DLight::mz3DLight (mz3DModel *iParent)
{
  Color.Set (0.0f, 0.0f, 0.0f);
  Radius = 0.0f;
  Cso_type = Dynamic = 0;
  Name = NULL;
  parent = iParent;
  selected = false;
}

mz3DLight::mz3DLight (mz3DLight &iCopy)
{
  Color.Set (iCopy.Color.red, iCopy.Color.green, iCopy.Color.blue);
  Radius = iCopy.Radius;
  selected = iCopy.selected;
  Dynamic = iCopy.Dynamic;
  Cso_type = iCopy.Cso_type;
  parent = iCopy.parent;

  // Generate a name for current polygon
  char tmp [16];
  sprintf (tmp, "p%lX", System->Time ());
  SetName (tmp);
}

void mz3DLight::SetName (const char *iName)
{
  if (Name)
    delete [] Name;
  Name = strnew (iName);
}

bool mz3DLight::operator == (const mz3DLight &p) const {
  if (parent != p.parent || Position != p.Position)
    return false;
  if (Color.red != p.Color.red || Color.green != p.Color.green || 
      Color.blue !=p.Color.blue || Radius != p.Radius)
    return false;
  return true;
}

mz3DLight::~mz3DLight ()
{
  if (Name)
    delete [] Name;

}
