# Application description
DESCRIPTION.mkdep = Dependency generation tool

#-------------------------------------------------------------- rootdefines ---#
ifeq ($(MAKESECTION),rootdefines)

# Application-specific help commands
APPHELP += $(NEWLINE)echo $"  make mkdep        Make the $(DESCRIPTION.mkdep)$"

endif # ifeq ($(MAKESECTION),rootdefines)

#-------------------------------------------------------------- roottargets ---#
ifeq ($(MAKESECTION),roottargets)

.PHONY: mkdep

#all apps: mkdep
mkdep:
	$(MAKE_TARGET)

endif # ifeq ($(MAKESECTION),roottargets)

#-------------------------------------------------------------- postdefines ---#
ifeq ($(MAKESECTION),postdefines)

vpath %.cpp apps/makedep

MAKEDEP.EXE=makedep$(EXE)
SRC.MAKEDEP = $(wildcard apps/makedep/*.cpp)
OBJ.MAKEDEP = $(addprefix $(OUT),$(notdir $(SRC.MAKEDEP:.cpp=$O)))
DESCRIPTION.$(MAKEDEP.EXE) = $(DESCRIPTION.mkdep)

endif # ifeq ($(MAKESECTION),postdefines)

#------------------------------------------------------------------ targets ---#
ifeq ($(MAKESECTION),targets)

.PHONY: mkdep mkdepclean

all: $(MAKEDEP.EXE)
mkdep: $(OUTDIRS) $(MAKEDEP.EXE)
clean: mkdepclean

# $(CSCOM.LIB) $(CSUTIL.LIB) $(CSSYS.LIB)
$(MAKEDEP.EXE): $(DEP.EXE) $(OBJ.MAKEDEP)
	$(DO.LINK.CONSOLE.EXE)

mkdepclean:
	-$(RM) $(MAKEDEP.EXE)

ifdef DO_DEPEND
depend: $(OUTOS)mkdep.dep
$(OUTOS)mkdep.dep: $(SRC.MAKEDEP)
	$(DO.DEP)
else
-include $(OUTOS)mkdep.dep
endif

endif # ifeq ($(MAKESECTION),targets)
