#include "cl_graph.h"

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow )
{
    // create the application
    ClumsyApp app( hInstance, hPrevInstance, lpszCmdLine, nCmdShow );

    // create the window class and register it
    WindowClass wc( "ClumsyTest" );
    // any settings to the window class (icon, cursor, background)
    // should be done before registering the window class
    wc.Register();

    // create the graphic object space
    Space s;

    // create the graphic objects
    CRectangle r1( Coord(-220, -60), Coord(-140, 60), 0, BLACK );
    CRectangle r2( Coord(-200, -40), Coord(-160, 40), 0, RED, BLUE );

    CEllipse e1( Coord(-120, -120), Coord(-40, 120), RED | BLUE );
    CEllipse e2( Coord(-100, -100), Coord(-60, 100), RED, GREEN );

    CPie p1( Coord(0, -50), Coord(100, 50), Coord(40, -25), Coord(60,-25),
             BLACK );
    CPie p2( Coord(0, -60), Coord(100, 40), Coord(60,-35), Coord(40, -35),
             RED|GREEN, (HBRUSH)GetStockObject( GRAY_BRUSH ) );

    CRectangle r3( Coord(140, 0), Coord(220, 0), 45, BLACK );
    CRectangle r4( Coord(160, 0), Coord(200, 0), 45, RED, BLUE );

    // create the pens for drawing the lines and arcs
    HPEN pen1, pen2, pen3;

    pen1 = CreatePen( PS_SOLID, 3, BLACK );
    pen2 = CreatePen( PS_DOT, 1, RED );
    pen3 = CreatePen( PS_DASH, 1, GREEN );

    Line l1( Coord(-220, -155), Coord (220, -155), pen1 );
    Line l2( Coord(-220, -145), Coord (220, -145), pen2 );
    Line l3( Coord(-220, -135), Coord (220, -135), pen3 );

    CArc c1( Coord(-220,-155), Coord(220,155), Coord(-220,135), Coord(220,135),
             pen1 );
    CArc c2( Coord(-210,-145), Coord(210,145), Coord(-220,135), Coord(220,135),
             pen2 );
    CArc c3( Coord(-200,-135), Coord(200,135), Coord(-220,135), Coord(220,135),
             pen3 );

    // add all the objects to the space
    s.AddObject( r1 );
    s.AddObject( r2 );
    s.AddObject( e1 );
    s.AddObject( e2 );
    s.AddObject( p1 );
    s.AddObject( p2 );
    s.AddObject( r3 );
    s.AddObject( r4 );
    s.AddObject( l1 );
    s.AddObject( l2 );
    s.AddObject( l3 );
    s.AddObject( c1 );
    s.AddObject( c2 );
    s.AddObject( c3 );

    // create the graphic window and assign it the space created above    
    GraphicWindow wnd(s);
    wnd.SetTitle( "Clumsy Computing" );
    wnd.Create(wc);

    // the graphic space is always centered on the screen
    wnd.CenterAlways();

    // show the window on the screen
    wnd.Show();

    // run the application until the window is closed
    return( app.Run() );
}
