#ifndef boolean
  typedef char boolean;
#endif

template <class DataType>
class DataSource
{
friend DataIterator<DataType>;

protected:
  long        capacity;
  long        size;

public:
              DataSource( long maxSize = 0xFFFFFFF ) {
                capacity = maxSize;
                size = 0;
              };
  virtual     ~DataSource() {};
  virtual
  boolean     Insert( DataType data ) = 0;
  virtual
  boolean     Delete( long cell ) = 0;
  virtual
  DataType    operator[]( long cell ) = 0;
  long        Size()               { return( size ); };
  boolean     Empty()              { return( size == 0 ); };
  boolean     Full()               { return( size == capacity ); };
};
      

template <class DataType>
class DataIterator
{
  DataSource<DataType>& container;
  long        current; 
public:
              DataIterator( void *contAdd );
  long        Position();
  boolean     First();
  boolean     Next();
  boolean     Previous();
  boolean     Last();
  boolean     End();
  boolean     Empty();
  boolean     Goto( long cell );
  DataType    Get();
};


template <class DataType>
DataIterator<DataType>::DataIterator( void *contAdd ) :
              container(*(DataSource<DataType> *)contAdd)
{
 current = 0;
}


template <class DataType>
long DataIterator<DataType>::Position()
{                             
  return( current );
}


template <class DataType>
boolean DataIterator<DataType>::First()
{
  current = 0;
  if ( container.Empty() ) {
    return( FALSE );
  }
  return( TRUE );
 }


template <class DataType>
boolean DataIterator<DataType>::Last()
{
  current = container.Size();
  if ( container.Empty() ) {
    return( FALSE );
  }
  return( TRUE );
}


template <class DataType>
boolean DataIterator<DataType>::Next()
{
  if ( current < (container.Size() - 1) ) {
    current++;
    return( TRUE );
  }
  return( FALSE );
}


template <class DataType>
boolean DataIterator<DataType>::Previous()
{
  if ( current > 0 ) {
    current--;
    return( TRUE );
  }
  return( FALSE );
}


template <class DataType>
boolean DataIterator<DataType>::Goto( long cell )
{
  if ( ! container.Empty() ) {
    if ( (cell >= 0) && (cell < container.Size()) ) {
      current = cell;
      return( TRUE );
    }
  }
  return( FALSE );
}


template <class DataType>
boolean DataIterator<DataType>::End()
{
  return( current == container.Size() );
}


template <class DataType>
boolean DataIterator<DataType>::Empty()
{
  return( container.Empty() );
}


template <class DataType>
DataType DataIterator<DataType>::Get()
{
  return( container[current] );
}


#ifdef __BORLANDC__
  #pragma warn -inl
#endif
template <class DataType>
class LinkedList : public DataSource<DataType>
{
private:
  class Node
  {
    public:
    DataType  data;
    Node      *previous;
    Node      *next;
              Node( DataType d ) : data(d) {};
  };

  Node        *head;
  Node        *tail;
  Node        *Goto( long cell ) {
                 Node *n;

                 if ( head == NULL ) {
                   return( NULL );
                 } else {
                   n = head;
                   for ( n = head; cell > 0; cell-- ) {
                     n = n->next;
                     if ( n == NULL ) {
                       return( NULL );
                     }
                   }                                
                 }
                 return( n );
              };

public:                                    
              LinkedList( long maxSize = 0xFFFFFF );
              ~LinkedList();
  boolean     Insert( DataType data );
  boolean     Delete( long cell );
  DataType    operator[]( long cell );
};
#ifdef __BORLANDC__
  #pragma warn .inl
#endif


template <class DataType>
LinkedList<DataType>::LinkedList( long maxSize ) :
                      DataSource<DataType>(maxSize)
{
  head = tail = NULL;
}


template <class DataType>
LinkedList<DataType>::~LinkedList()
{
  for ( ; head != NULL; ) {
    Node *temp;
    temp = head;
    head = head->next;
    delete temp;
  }
}


template <class DataType>
boolean LinkedList<DataType>::Insert( DataType data )
{
  if ( size >= capacity ) {
    return( FALSE );
  } else {
    if ( tail == NULL ) {
      head = tail = new Node(data);
      head->previous = NULL;
    } else {
      tail->next = new Node(data);
      tail->next->previous = tail;
      tail = tail->next;
    }
    size++;
    return( TRUE );
  }
}


template <class DataType>
boolean LinkedList<DataType>::Delete( long cell )
{
  if ( (cell >= 0) && (cell <= size) ) {
    Node *n = Goto( cell );
    if ( n == head ) {
      head = n->next;
    } else {
      n->previous->next = n->next;
    }
    if ( n == tail ) {
      tail = n->previous;
    } else {
      n->next->previous = n->next;
    }
    delete n;
    size--;
    return( TRUE );
  }
  return( FALSE );
}


template <class DataType>
DataType LinkedList<DataType>::operator[]( long cell )
{
  static char buffer[sizeof(DataType)];

  Node *n = Goto( cell );

  if ( n != NULL ) {
    return( n->data );
  }
  return( *(DataType *)buffer );
}


