/*  xmath.h

  extended math library  belonging to Vectory.

  will contain more functions in future releases.

  Copyright (c) 1996-1998 by Martin Sander
  All Rights Reserved.
*/

#if !defined( __XMATH_H )
#define __XMATH_H
#if !defined( __VECLIB_H )
   #include <VecLib.h>
#endif

#define VF_tabsz2 2048
#define VD_tabsz2 1024
#define VE_tabsz2 1024
#define VF_log2tabsz2 11
#define VD_log2tabsz2 10
#define VE_log2tabsz2 10
#define VF_tabsz3  360
#define VD_tabsz3  180
#define VE_tabsz3  180

#ifdef __cplusplus
extern "C" {
#endif

extern float    _cdecl   VF_sintab2[ VF_tabsz2+1 ];
extern double   _cdecl   VD_sintab2[ VD_tabsz2+1 ];
extern extended _cdecl   VE_sintab2[ VE_tabsz2+1 ];
extern float    _cdecl   VF_sintab3[ VF_tabsz3+1 ];
extern double   _cdecl   VD_sintab3[ VD_tabsz3+1 ];
extern extended _cdecl   VE_sintab3[ VE_tabsz3+1 ];
extern float    _cdecl   VF_tantab2[ VF_tabsz2+1 ];
extern double   _cdecl   VD_tantab2[ VD_tabsz2+1 ];
extern extended _cdecl   VE_tantab2[ VE_tabsz2+1 ];
extern float    _cdecl   VF_tantab3[ VF_tabsz3+1 ];
extern double   _cdecl   VD_tantab3[ VD_tabsz3+1 ];
extern extended _cdecl   VE_tantab3[ VE_tabsz3+1 ];
extern float    _cdecl   VF_cosectab2[ VF_tabsz2+1 ];
extern double   _cdecl   VD_cosectab2[ VD_tabsz2+1 ];
extern extended _cdecl   VE_cosectab2[ VE_tabsz2+1 ];
extern float    _cdecl   VF_cosectab3[ VF_tabsz3+1 ];
extern double   _cdecl   VD_cosectab3[ VD_tabsz3+1 ];
extern extended _cdecl   VE_cosectab3[ VE_tabsz3+1 ];

#if defined __BORLANDC__ || defined _MSC_VER
    double      __vf  log2( double x );
    extended    __vf  log2l( extended x );
#endif   /* Optima++ has log2 already built in */

int         __vf  isint( double x );
int         __vf  isintl( extended x );
#define           iseven( x )  !(x & 1)    /* for all integer types */
#define           sispositive( x )  !(x & HIBITS)  /* for short int */
#define           ispositive( x )   !(x & HIBITI)  /* for int */
#define           lispositive( x )  !(x & HIBITL)  /* for long int */


#ifdef __cplusplus
}
#endif
#endif /* __XMATH_H */
