UNIT VolMeter;

{Sibyl Sample component.
 Install using Component|Install from the menu bar}

INTERFACE

USES Classes,Forms,Buttons;

TYPE
    TVolumeMeter=CLASS(TOwnerDrawButton)
         PRIVATE
                FPosition:LONGINT;
         PRIVATE
                PROCEDURE SetPosition(NewPosition:LONGINT);
         PUBLIC
                PROCEDURE SetupComponent;OVERRIDE;
                PROCEDURE Redraw(CONST rc:TRect);OVERRIDE;
         PUBLISHED
                PROPERTY Position:LONGINT read FPosition write SetPosition;
    END;

EXPORTS
  TVolumeMeter, 'User', 'VolMeter.Bmp';


IMPLEMENTATION

PROCEDURE TVolumeMeter.SetPosition(NewPosition:LONGINT);
VAR w:LONGINT;
BEGIN
     IF Handle=0 THEN
     BEGIN
          FPosition:=NewPosition;
          exit;
     END;

     w:=Width;
     {alten Zeiger lschen}
     Canvas.LineType:=ltInvisible;
     Canvas.DrawArc(w DIV 2,0,w-(w DIV 3)-10,40,100-FPosition);
     Canvas.LineType:=ltSolid;
     Canvas.FgMode:=fgInvert;
     Canvas.Color:=clBlack;
     Canvas.DrawLineTo(w DIV 2,4);
     Canvas.FgMode:=fgOverpaint;

     FPosition:=NewPosition;
     {Zeiger Zeichnen}
     Canvas.LineType:=ltInvisible;
     Canvas.DrawArc(w DIV 2,0,w-(w DIV 3)-10,40,100-FPosition);
     Canvas.LineType:=ltSolid;
     Canvas.FgMode:=fgInvert;
     Canvas.Color:=clBlack;
     Canvas.DrawLineTo(w DIV 2,4);
     Canvas.FgMode:=fgOverpaint;
END;

PROCEDURE TVolumeMeter.SetupComponent;
BEGIN
     Inherited SetupComponent;

     WinBackColor:=clLtGray;
     FPosition:=50;
END;

PROCEDURE TVolumeMeter.Redraw(CONST rc:TRect);
VAR
    w,t:LONGINT;
    left,right:TPoint;
BEGIN
     Inherited Redraw(ClientRect);

     w:=Width;
     Canvas.Color:=clBlack;
     Canvas.DrawArc(Width DIV 2,0,w DIV 3,40,0);
     right:=Canvas.PenPos;
     Canvas.DrawArc(Width DIV 2,0,w DIV 3,40,100);
     left:=Canvas.PenPos;
     Canvas.DrawArc(w DIV 2,0,w-(w DIV 3),40,0);
     Canvas.DrawLineTo(right.X,right.Y);
     Canvas.DrawArc(w DIV 2,0,w-(w DIV 3),40,100);
     Canvas.DrawLineTo(Left.X,Left.Y);
     {Zeiger-Anchor}
     Canvas.DrawFilledCircle(w DIV 2,4,2);
     {Innenraum fllen}
     Canvas.Color:=clWhite;
     Canvas.FloodFill(Point(w DIV 2,Height DIV 2),clBlack,FALSE);

     Canvas.Color:=clBlack;
     t:=40;
     WHILE t<=140 DO
     BEGIN
          Canvas.LineType:=ltInvisible;
          Canvas.DrawArc(w DIV 2,0,w-(w DIV 3),t,0);
          Left:=Canvas.PenPos;
          IF t IN [65,90,115] THEN Canvas.DrawArc(w DIV 2,0,w-(w DIV 3)-10,t,0)
          ELSE Canvas.DrawArc(w DIV 2,0,w-(w DIV 3)-5,t,0);
          Canvas.LineType:=ltSolid;
          Canvas.DrawLineTo(Left.X,Left.Y);
          inc(t,5);
     END;

     {Zeiger Zeichnen}
     Canvas.LineType:=ltInvisible;
     Canvas.DrawArc(w DIV 2,0,w-(w DIV 3)-12,40,100-FPosition);
     Canvas.LineType:=ltSolid;
     Canvas.FgMode:=fgInvert;
     Canvas.Color:=clBlack;
     Canvas.DrawLineTo(w DIV 2,4);
     Canvas.FgMode:=fgOverpaint;
END;

BEGIN
     RegisterComponents([TVolumeMeter]);
END.
