
    'FFEXP.BAS
    'Freeform for Liberty BASIC

    'Copyright 1995 Shoptalk Systems
	'All rights reserved

    'This program lets you graphically lay out
    'windows and their controls, and then converts
    'this visual layout to Liberty BASIC source code
    'that you can paste into your Liberty BASIC
    'programming session.

	'*** This current version is a quick hack of the
    '*** Windows version of FreeForm.
    '*** It's a little messy looking, but it works.

    'This program REQUIRES Liberty BASIC for Windows v1.1
    'or Liberty BASIC for OS/2 v0.7 beta or better

    'set up an arrays to hold control specs

    dim type$(100)
    dim label$(100)
    dim names$(100)
    dim xOrg(100)
    dim yOrg(100)
    dim width(100)
    dim height(100)
    dim corner$(100)
    dim branchLabel$(100)
    dim segment(100)
    dim handle$(100)
    dim bmpName$(100)
    dim arrayName$(100)
    dim menu$(20)
    dim menuItem$(20, 30)
    dim menuItemLocal$(30)
    dim menuItemCount(20)
    dim winType$(20)
    index = 0
    resizeable$ = " combobox textbox listbox groupbox windowframe "   'add more as you go
    newControlNumber = 0  'increment by one each time a new control is added
    qu$ = chr$(34)
    controlsThatBranch$ = " button listbox combobox bmpbutton checkbox radiobutton "
    snapOn = 1
    xInterval = 8
    yInterval = 5

    formName$ = "untitled.fre"
    windowXOrigin = 70
    windowYOrigin = 10
    windowXExtent = 550
    windowYExtent = 410
    windowLabel$ = "untitled"
    windowType$ = "dialog"
    winHandle$ = "#main"
    menuCount = 0

    loadbmp "systemBox", "systembx.bmp"
    loadbmp "minBox", "minbx.bmp"
    loadbmp "maxBox", "maxbx.bmp"
    loadbmp "comboButton", "cmbobttn.bmp"
    loadbmp "radioButton", "radibttn.bmp"
    loadbmp "checkBox", "checkbox.bmp"
    loadbmp "scrollUp", "scrlup.bmp"
    loadbmp "scrollDown", "scrldown.bmp"
    loadbmp "scrollRight", "scrlrght.bmp"
    loadbmp "scrollLeft", "scrlleft.bmp"

    winType$(0) = "window"
    winType$(1) = "window_nf"
    winType$(2) = "dialog"
    winType$(3) = "dialog_nf"

[setUpWindowAndOpenIt]

    nomainwin

    menu #form, "&Files", "&New", [newFile], "&Open", [openFile], "&Save", [saveFile]
    menu #form, "&Control", "&Inspect", [inspectControl], "&Delete", [deleteControl], |, "Move to &front", [moveToFront], "Move to &back", [moveToBack]
    menu #form, "&Output", "&Produce Code", [produceCode], "Produce Code + Outline", [produceCodeAndOutline]
    menu #form, "&Window", "&Title", [changeTitle], "T&ype", [changeWindowType], "&Handle", [changeHandle]
    menu #form, "O&ptions", "&Auto Snap to Grid", [gridDialog]
    menu #form, "&Menu", "&Add a Menu", [addAMenu], "&Remove a Menu", [removeMenu], "&Edit Menus", [editMenus]
    bmpbutton #form, "textbttn.bmp", [addStaticText], UL, 5, 40
    bmpbutton #form, "efldbttn.bmp", [addField], UL, 35, 40
    bmpbutton #form, "bttnbttn.bmp", [addButton], UL, 5, 70
    bmpbutton #form, "usrdbttn.bmp", [addBmpButton], UL, 35, 70
    bmpbutton #form, "lboxbttn.bmp", [addListBox], UL, 5, 100
    bmpbutton #form, "cboxbttn.bmp", [addComboBox], UL, 35, 100
    bmpbutton #form, "rdiobttn.bmp", [addRadioButton], UL, 5, 130
    bmpbutton #form, "chbxbttn.bmp", [addCheckBox], UL, 35, 130
    bmpbutton #form, "gboxbttn.bmp", [addGroupBox], UL, 5, 160

    open "FreeForm v1.0 for Liberty BASIC" for graphics_fs_nsb as #form
    if Platform$ = "OS/2" then print #form, "font systemmonospaced 8 12";
    if Platform$ = "Windows" then print #form, "font fixedsys 8 15";
    print #form, "trapclose [quit]";


[drawTheWindow]

    gosub [renderWindow]
    gosub [addWindowFrame]

    goto [setForSelection]


[addWindowFrame]    'add the window frame as the first object

    objectCount = objectCount + 1
    idx = objectCount
    xOrg(idx) = 70
    yOrg(idx) = 10
    width(idx) = 550
    height(idx) = 410
    type$(idx) = "windowframe"
    return


[addButton]     'add a new button to the form

    text$ = ""
    prompt "Please enter text for this button"; text$
    if left$(text$, 1) = qu$ then text$ = mid$(text$, 2)
    if right$(text$, 1) = qu$ then text$ = left$(text$, len(text$) - 1)
    if text$ = "" then [inputLoop]

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    xOrg(idx) = 80
    yOrg(idx) = 40
    type$(idx) = "button"
    names$(idx) = "button"+str$(newControlNumber)
    corner$(idx) = "UL"
    label$(idx) = text$
    branchLabel$(idx) = "["+names$(idx)+"Click]"
    gosub [renderButton]
    goto [inputLoop]


[addBmpButton]     'add a new bmpButton to the form

    bmp$ = ""
    filedialog "Select a bitmap for this button", "*.bmp", bmp$
    if bmp$ = "" then [inputLoop]

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    xOrg(idx) = 100
    yOrg(idx) = 50
    type$(idx) = "bmpbutton"
    names$(idx) = "bmpbutton"+str$(newControlNumber)
    corner$(idx) = "UL"
    bmpName$(idx) = bmp$
    loadbmp bmp$, bmp$
    branchLabel$(idx) = "["+names$(idx)+"Click]"
    gosub [renderBmpButton]
    goto [inputLoop]


[addField]     'add a new field (textBox) to the form

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    xOrg(idx) = 100
    yOrg(idx) = 50
    width(idx) = 100
    height(idx) = 25
    type$(idx) = "textbox"
    names$(idx) = "textbox"+str$(newControlNumber)
    gosub [renderTextBox]
    goto [inputLoop]


[addComboBox]     'add a new combobox to the form

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    xOrg(idx) = 100
    yOrg(idx) = 50
    width(idx) = 100
    height(idx) = 100
    type$(idx) = "combobox"
    names$(idx) = "combobox"+str$(newControlNumber)
    branchLabel$(idx) = "["+names$(idx)+"DoubleClick]"
    arrayName$(idx) = "array$("
    gosub [renderComboBox]
    goto [inputLoop]


[addListBox]     'add a new listbox to the form

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    xOrg(idx) = 100
    yOrg(idx) = 50
    width(idx) = 100
    height(idx) = 100
    type$(idx) = "listbox"
    names$(idx) = "listbox"+str$(newControlNumber)
    branchLabel$(idx) = "["+names$(idx)+"DoubleClick]"
    arrayName$(idx) = "array$("
    gosub [renderListBox]
    goto [inputLoop]


[addStaticText]     'add statictext to the form

    text$ = ""
    prompt "Please enter the text you would like to add:"; text$
    if left$(text$, 1) = qu$ then text$ = mid$(text$, 2)
    if right$(text$, 1) = qu$ then text$ = left$(text$, len(text$) - 1)
    if text$ = "" then [inputLoop]

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    xOrg(idx) = 100
    yOrg(idx) = 50
    type$(idx) = "statictext"
    names$(idx) = "statictext"+str$(newControlNumber)
    corner$(idx) = ""
    label$(idx) = text$
    gosub [renderStaticText]
    goto [inputLoop]


[addGroupBox]     'add groupbox to the form

    text$ = "No Text"
    prompt "Please enter the text this GroupBox :"; text$
    if left$(text$, 1) = qu$ then text$ = mid$(text$, 2)
    if right$(text$, 1) = qu$ then text$ = left$(text$, len(text$) - 1)
    if text$ = "" then [inputLoop]
    if text$ = "No Text" then text$ = ""

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    xOrg(idx) = 100
    yOrg(idx) = 50
    width(idx) = 100
    height(idx) = 100
    type$(idx) = "groupbox"
    names$(idx) = "groupbox"+str$(newControlNumber)
    corner$(idx) = ""
    label$(idx) = text$
    gosub [renderGroupBox]
    goto [inputLoop]


[addRadioButton]     'add radiobutton to the form

    text$ = ""
    prompt "Please enter a label for the radiobutton:"; text$
    if left$(text$, 1) = qu$ then text$ = mid$(text$, 2)
    if right$(text$, 1) = qu$ then text$ = left$(text$, len(text$) - 1)
    if text$ = "" then [inputLoop]

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    xOrg(idx) = 100
    yOrg(idx) = 50
    type$(idx) = "radiobutton"
    names$(idx) = "radiobutton"+str$(newControlNumber)
    corner$(idx) = "UL"
    label$(idx) = text$
    branchLabel$(idx) = "["+names$(idx)+"Set] ["+names$(idx)+"Reset]"
    gosub [renderRadioButton]
    goto [inputLoop]


[addCheckBox]     'add checkbox to the form

    text$ = ""
    prompt "Please enter a label for the checkbox"; text$
    if left$(text$, 1) = qu$ then text$ = mid$(text$, 2)
    if right$(text$, 1) = qu$ then text$ = left$(text$, len(text$) - 1)
    if text$ = "" then [inputLoop]

    newControlNumber = newControlNumber + 1
    objectCount = objectCount + 1
    idx = objectCount
    xOrg(idx) = 100
    yOrg(idx) = 50
    type$(idx) = "checkbox"
    names$(idx) = "checkbox"+str$(newControlNumber)
    corner$(idx) = "UL"
    label$(idx) = text$
    branchLabel$(idx) = "["+names$(idx)+"CheckboxSet] ["+names$(idx)+"CheckboxReset]"
    gosub [renderCheckBox]
    goto [inputLoop]


[inputLoop]

    input r$
    goto [inputLoop]


[renderWindow]

    'render the window depending on the value of windowType$

    xOrg = windowXOrigin
    yOrg = windowYOrigin
    xExt = windowXExtent
    yExt = windowYExtent

    print #form, "cls";
    print #form, "backcolor white ; color black ; down ; size 1";
    print #form, "place "; xOrg + 4; " "; yOrg + 4;
    if Platform$ = "OS/2" then print #form, "backcolor lightgray";
    print #form, "boxfilled "; xOrg + xExt - 4; " "; yOrg + yExt - 4;
    if instr(windowType$, "_nf") > 0 then [noResizingFrame]

    'draw resizing frame
    print #form, "color lightgray ; size 3";
	if Platform$ = "OS/2" then print #form, "color yellow";
    if windowType$ = "dialog" then print #form, "color darkgray";
    if windowType$ = "dialog" and Platform$ = "OS/2" then print #form, "color darkcyan";
    print #form, "place "; xOrg + 2; " "; yOrg + 2;
    print #form, "box "; xOrg + xExt - 2; " "; yOrg + yExt - 2;
    print #form, "color black ; backcolor white ; size 1";
    print #form, "place "; xOrg; " "; yOrg;
    print #form, "box "; xOrg + xExt ; " "; yOrg + yExt;

  [noResizingFrame]
    'draw titlebar
    print #form, "color black ; backcolor darkblue";
    if left$(windowType$, 6) = "dialog" then print #form, "backcolor darkgray";
    if Platform$ = "OS/2" then print #form, "color darkgray ; backcolor darkcyan";
    print #form, "place "; 4 + xOrg; " "; 4 + yOrg;
    print #form, "boxfilled "; xOrg + xExt - 4; " "; 4 + yOrg + 20;
    print #form, "place "; int(xExt/2) + xOrg - len(windowLabel$) * 4; " "; 18 + yOrg;
    if Platform$ = "OS/2" then print #form, "place "; 48 + xOrg; " "; 18 + yOrg;
    print #form, "color white";
    print #form, "\"; windowLabel$;

    'draw buttons
    print #form, "drawbmp systemBox "; xOrg + 4; " "; 4 + yOrg;
    print #form, "backcolor white ; color black ; down ; size 1";
    if windowType$ = "dialog" then print #form, "color white" ;
    if windowType$ = "dialog" and Platform$ = "OS/2" then print #form, "color darkgray" ;
    print #form, "place "; xOrg + 4; " "; yOrg + 4;
    print #form, "box "; xOrg + xExt - 4; " "; yOrg + yExt - 4;
    if left$(windowType$, 6) = "dialog" then [drawMenus]
    if instr(windowType$, "_nf") then print #form, "drawbmp minBox "; xOrg + xExt - 24; " "; 4 + yOrg; : goto [drawMenus]
    print #form, "drawbmp minBox "; xOrg + xExt - 43; " "; 4 + yOrg;
    print #form, "drawbmp maxBox "; xOrg + xExt - 24; " "; 4 + yOrg;

  [drawMenus]
    if menuCount = 0 then [dontDrawMenus]
    print #form, "color black ; backcolor white" ;
    if Platform$ = "Windows" then print #form, "place "; 4 + xOrg; " "; 23 + yOrg;
    if Platform$ = "OS/2" then print #form, "color darkgray ; place "; 4 + xOrg; " "; 25 + yOrg;
    print #form, "box "; xOrg + xExt - 4; " "; 24 + yOrg + 20 ;
    string$ = ""
    underline$ = ""
    for x = 0 to menuCount - 1
        item$ = menu$(x)
        hkIndex = instr(menu$(x), "&")
        if hkIndex = 0 then [noHotKey]
        item$ = left$(item$, hkIndex - 1) + mid$(item$, hkIndex + 1)
        underline$ = underline$ + chr$(len(string$)+hkIndex)
      [noHotKey]
        string$ = string$ + item$ + "  "
    next x
    print #form, "color black ; backcolor white" ;
    print #form, "place "; xOrg + 10; " "; 38 + yOrg ;
    print #form, "\"; string$;
    if len(underline$) = 0 then [dontDrawMenus]
    for x = 1 to len(underline$)
        print #form, "place "; xOrg + 10 + (asc(mid$(underline$, x, 1)) - 1) * 8; " "; yOrg + 40 ;
        print #form, "north ; turn 90 ; go 8";
    next x

  [dontDrawMenus]
    print #form, "flush" ;

    return


[changeTitle]

    'change the window's title
    prompt "Specify the window's title"; windowLabel$
    gosub [redrawAll]
    goto [inputLoop]


[changeWindowType]

    WindowWidth = 380
    WindowHeight = 200

    'change the window's type
    statictext #type.statictext1, "Select the type of window desired:", 14, 11, 272, 20
    combobox #type.types, winType$(, [selectWinType], 22, 36, 256, 115
    button #type, "Accept", [acceptWinType], UL, 302, 36
    button #type, "Cancel", [cancelWinType], UL, 302, 71
    open "Select Window Type" for dialog as #type
    print #type.types, "select "; windowType$ 
    print #type, "trapclose [cancelWinType]"
    defaultType$ = windowType$

    goto [inputLoop]


[selectWinType]   'Perform action for the combobox named 'types'

    'select the type of window desired
    print #type.types, "selection?";
    input #type.types, defaultType$

    goto [inputLoop]


[acceptWinType]   'Perform action for the button named 'acceptWinType'

    'accept the selected window type
    windowType$ = defaultType$
    close #type
    gosub [redrawAll]
    goto [inputLoop]


[cancelWinType]   'Perform action for the button named 'cancelWinType'

    'close the window, don't accept type change
    close #type
    goto [inputLoop]


[changeHandle]

    'change the window's handle
    prompt "Specify the window's handle (starts with a #)"; result$
    if result$ = "" then [inputLoop]
    winHandle$ = result$
    if left$(winHandle$, 1) <> "#" then winHandle$ = "#" + winHandle$ : notice "Window handle defaults to: " + winHandle$
    goto [inputLoop]


[renderButton]

    'render the statictext at idx.
    'assume an font 8 bits wide
    type$(idx) = "button"
    width(idx) = 8 * (len(label$(idx))) + 10
    height(idx) = 15 + 10
    xOrgIdx = xOrg(idx)
    yOrgIdx = yOrg(idx)
    print #form, "place "; xOrgIdx; " "; yOrgIdx ;
    print #form, "place "; xOrgIdx; " "; yOrgIdx ;
    print #form, "color black ; backcolor lightgray ; size 1" ;
    print #form, "down ; boxfilled "; xOrgIdx+width(idx); " "; yOrgIdx+height(idx) ;
    if Platform$ = "Windows" then print #form, "size 2";
	if Platform$ = "Windows" then print #form, "color darkgray ; place "; xOrgIdx+2; " "; yOrgIdx+2 ;
	if Platform$ = "OS/2" then print #form, "color darkgray ; place "; xOrgIdx+1; " "; yOrgIdx+1 ;
    print #form, "box "; xOrgIdx+width(idx)-1; " "; yOrgIdx+height(idx)-1 ;
    print #form, "color white" ;
    print #form, "place  "; xOrgIdx+2; " "; yOrgIdx+height(idx)-3 ;
    print #form, "goto "; xOrgIdx+2; " "; yOrgIdx+2 ;
    print #form, "goto "; xOrgIdx+width(idx)-3; " "; yOrgIdx+2 ;
    print #form, "color black ; backcolor lightgray ; size 1" ;
    print #form, "place "; xOrgIdx+4; " "; yOrgIdx+17 ;
    print #form, "\"; label$(idx);
    print #form, "up ; flush" ;
    print #form, "segment" : input #form, id
    segment(idx) = id

    return


[renderStaticText]

    'render the statictext at idx.
    'assume an font 8 bits wide, 15 high
    type$(idx) = "statictext"
    width(idx) = 8 * len(label$(idx))
    height(idx) = 20
    print #form, "place "; xOrg(idx); " "; yOrg(idx)+15-3 ; " ; place "; xOrg(idx); " "; yOrg(idx)+15-3 ;
    print #form, "down ; color black ; backcolor white" ;
    print #form, "\"; label$(idx);
    print #form, "up ; flush" ;
    print #form, "segment" : input #form, id
    segment(idx) = id

    return


[renderRadioButton]

    'render the radiobutton at idx.
    'assume an font 8 bits wide, 15 high
    type$(idx) = "radiobutton"
    width(idx) = 8 * len(label$(idx)) + 16
    height(idx) = 15
    print #form, "down" ;
    print #form, "place "; xOrg(idx); " "; yOrg(idx);
    print #form, "drawbmp radioButton "; xOrg(idx); " "; yOrg(idx);
    print #form, "color black ; backcolor white" ;
    print #form, "place "; xOrg(idx)+16; " "; yOrg(idx)+15-3 ;
    print #form, "\"; label$(idx);
    print #form, "up ; flush" ;
    print #form, "segment" : input #form, id
    segment(idx) = id

    return


[renderCheckBox]

    'render the checkbox at idx.
    'assume an font 8 bits wide, 15 high
    type$(idx) = "checkbox"
    width(idx) = 8 * len(label$(idx)) + 16
    height(idx) = 15
    print #form, "place "; xOrg(idx); " "; yOrg(idx) ;
    print #form, "down" ;
    print #form, "drawbmp checkBox "; xOrg(idx); " "; yOrg(idx);
    print #form, "color black ; backcolor white" ;
    print #form, "place "; xOrg(idx)+16; " "; yOrg(idx)+15-3 ;
    print #form, "\"; label$(idx);
    print #form, "up ; flush" ;
    print #form, "segment" : input #form, id
    segment(idx) = id

    return


[renderBmpButton]

    'render the bmpbutton at idx.
    'assume an font 8 bits wide
    type$(idx) = "bmpbutton"
    width(idx) = 20
    height(idx) = 20
    print #form, "place "; xOrg(idx); " "; yOrg(idx) ;
    print #form, "drawbmp "; bmpName$(idx); " "; xOrg(idx); " "; yOrg(idx);
    print #form, "flush" ;
    print #form, "segment" : input #form, id
    segment(idx) = id

    return


[renderComboBox]

    'render the comboBox at idx.
    type$(idx) = "combobox"
    print #form, "place "; xOrg(idx); " "; yOrg(idx) ;
    print #form, "place "; xOrg(idx); " "; yOrg(idx) ;
    print #form, "color black ; backcolor white ; size 1" ;
    print #form, "down ; boxfilled "; xOrg(idx)+width(idx)-24; " "; yOrg(idx)+22 ;
    print #form, "drawbmp comboButton "; xOrg(idx)+width(idx)-16 ; " "; yOrg(idx) ;
    print #form, "up ; flush" ;
    print #form, "segment" : input #form, id
    segment(idx) = id

    return

[renderTextBox]

    'render the textbox at idx.
    type$(idx) = "textbox"
    print #form, "place "; xOrg(idx); " "; yOrg(idx) ; " ; place "; xOrg(idx); " "; yOrg(idx) ;
    print #form, "color black ; backcolor white ; size 1" ;
    print #form, "down ; boxfilled "; xOrg(idx)+width(idx); " "; yOrg(idx)+height(idx) ;
    print #form, "up ; flush" ;
    print #form, "segment" : input #form, id
    segment(idx) = id

    return


[renderListBox]

    'render the listbox at idx.
    type$(idx) = "listbox"
    print #form, "place "; xOrg(idx); " "; yOrg(idx) ;
    print #form, "place "; xOrg(idx); " "; yOrg(idx) ;
    print #form, "color black ; backcolor white ; size 1" ;
    print #form, "down ; boxfilled "; xOrg(idx)+width(idx); " "; yOrg(idx)+height(idx) ;
    print #form, "color black ; backcolor lightgray" ;
    print #form, "place "; xOrg(idx)+width(idx)-17; " "; yOrg(idx);
    print #form, "boxfilled "; xOrg(idx)+width(idx); " "; yOrg(idx)+height(idx) ;
    print #form, "drawbmp scrollUp "; xOrg(idx)+width(idx)-17; " "; yOrg(idx);
    print #form, "drawbmp scrollDown "; xOrg(idx)+width(idx)-17; " "; yOrg(idx)+height(idx)-17;
    print #form, "up ; flush" ;
    print #form, "segment" : input #form, id
    segment(idx) = id

    return


[renderGroupBox]

    'render the groupbox at idx.  assume a font 8x15.
    type$(idx) = "groupbox"
    print #form, "place "; xOrg(idx); " "; yOrg(idx) ;
    print #form, "place "; xOrg(idx)+4 ; " "; yOrg(idx)+8 ;
    print #form, "color black ; backcolor white ; size 1" ;
    print #form, "down ; boxfilled "; xOrg(idx)+width(idx)-4; " "; yOrg(idx)+height(idx)-7 ;
    print #form, "place "; xOrg(idx)+8; " "; yOrg(idx)+15 ;
    print #form, "\"; label$(idx);
    print #form, "up ; flush" ;
    print #form, "segment" : input #form, id
    segment(idx) = id

    return


[inspectControl]

    'pop up a dialog for displaying/modifying control
    'properties

    if index < 2 then [inputLoop]

    WindowHeight = 240
    WindowWidth = 410

    textbox #inspect.labelField, 130, 15, 158, 25
    textbox #inspect.nameField, 130, 46, 158, 25
    textbox #inspect.branchLabelField, 130, 77, 158, 25
    textbox #inspect.arrayNameField, 130, 108, 158, 25
    statictext #inspect.type, "Label:", 17, 21, 200, 20
    statictext #inspect.type, "Type:", 17, 52, 200, 20
    statictext #inspect.statictext2, "Name:", 17, 83, 45, 20
    statictext #inspect.statictext4, "Branch Label(s):", 17, 113, 114, 20
    button #inspect, "Accept", [acceptInspect], UL, 300, 16
    button #inspect, "Cancel", [cancelInspect], UL, 300, 46
    statictext #inspect.statictext15, "n/a =", 302, 79, 40, 20
    statictext #inspect.statictext16, "not applicable", 302, 95, 112, 20
    open "Modify Control" for dialog as #inspect
    print #inspect, "trapclose [cancelInspect]";

    print #inspect.labelField, label$(index)
    print #inspect.type, "Type: " + type$(index)
    print #inspect.nameField, names$(index)
    print #inspect.branchLabelField, branchLabel$(index)
    if instr(" button statictext checkbox radiobutton groupbox ", type$(index)) = 0 then print #inspect.labelField, "n/a"
    if instr(controlsThatBranch$, type$(index)) = 0 then print #inspect.branchLabelField, "n/a"
    if instr(" listbox combobox ", type$(index)) > 0 then print #inspect.arrayNameField, arrayName$(index) else print #inspect.arrayNameField, "n/a"

    goto [inputLoop]


[acceptInspect]

    'set the properties as modified by the user
    isModified = 1  'the form has been modified
    hasLabel =  instr(" button statictext checkbox radiobutton groupbox ", type$(index))
    if hasLabel > 0 then print #inspect.labelField, "!contents?" : input #inspect.labelField, label$ : label$(index) = label$
    print #inspect.nameField, "!contents?" : input #inspect.nameField, names$ : names$(index) = names$
    branches = instr(controlsThatBranch$, type$(index))
    if branches > 0 then print #inspect.branchLabelField, "!contents?" : input #inspect.branchLabelField, bLabel$ : branchLabel$(index) = bLabel$
    usesArray = instr(" listbox combobox ", type$(index))
    if usesArray > 0 then print #inspect.arrayNameField, "!contents?" : input #inspect.arrayNameField, aName$ : arrayName$(index) = aName$
    close #inspect

    if hasLabel > 0 then gosub [redrawAll]

    goto [inputLoop]


[cancelInspect]

    'close the inspector window
    close #inspect
    goto [inputLoop]


[setForSelection]

    'set up event handling for the default behavior (selection)
    print #form, "when leftButtonDown [selectControl]";
    print #form, "when leftButtonDouble [inspectControl]";
    print #form, "when leftButtonMove" ;
    print #form, "when leftButtonUp" ;

    goto [inputLoop]


[selectControl]

    'set up event handling
    print #form, "when leftButtonUp [setForSelection]" ;
    print #form, "when leftButtonDown" ;

    'highlight the control at the mouse click position
    x = MouseX : y = MouseY

    if index = 0 then [dontDeselect]

    'check to see if the resize handle has been clicked on, if applicable
    if instr(resizeable$, type$(index)) = 0 then [deselect]
    if x < xOrg(index)+width(index)-3 or x > xOrg(index)+width(index)+3 then [deselect]
    if y < yOrg(index)+height(index)-3 or y > yOrg(index)+height(index)+3 then [deselect]
    goto [resizeControl]

[deselect]
    print #form, "delsegment "; selectId -1 ;
    gosub [selectDeselect]
    index = 0
    print #form, "delsegment "; selectId - 1 ;

[dontDeselect]
    gosub [determineControl]
    if newIndex = 0 then [setUpMovementEvent]

    index = newIndex
    gosub [selectDeselect]
    lastMouseX = MouseX
    lastMouseY = MouseY

[setUpMovementEvent]

    if type$(newIndex) = "windowframe" then [inputLoop]
    print #form, "when leftButtonMove [beginObjectMove]" ;
    goto [inputLoop]


[determineControl]

    'based on x/y, determine which control is selected
    'set newIndex to point to this control, if found
    'otherwise set newIndex to 0

    if objectCount = 0 then return

    newIndex = 0
    for i = objectCount to 1 step -1
        if newIndex > 0 then [skipControl]
        if type$(i) = "" then [skipControl]
        if x < xOrg(i) or x > xOrg(i)+width(i) then [skipControl]
        if y < yOrg(i) or y > yOrg(i)+height(i) then [skipControl]
        newIndex = i
        i = 1
[skipControl]
    next i

    return


[selectDeselect]

    'select or deselect the object at index by drawing handles
    xOrgIdx = xOrg(index)
    yOrgIdx = yOrg(index)
    xow = xOrgIdx+width(index)
    yoh = yOrgIdx+height(index)
    print #form, "rule xor ; down";
    if type$(index) = "windowframe" then [drawSizingHandle]
    print #form, "color darkgray ; backcolor white" ;
    print #form, "place "; xOrgIdx-3; " "; yOrgIdx-3 ;
    print #form, "box "; xOrgIdx+3; " "; yOrgIdx+3 ;
    print #form, "place "; xow-3; " "; yOrgIdx-3 ;
    print #form, "box "; xow+3; " "; yOrgIdx+3 ;
    print #form, "place "; xOrgIdx-3; " "; yoh-3 ;
    print #form, "box "; xOrgIdx+3; " "; yoh+3 ;

  [drawSizingHandle]
    if instr(resizeable$, type$(index)) > 0 then print #form, "backcolor black" ;
    print #form, "place "; xow-3; " "; yoh-3 ;
    print #form, "boxfilled "; xow+3; " "; yoh+3 ;
    print #form, "rule over ; flush" ;
    print #form, "segment" ;
    input #form, selectId


    return


[beginObjectMove]

    'if the mouse has only slightly moved, ignore the event
    if abs(MouseX - x) < 3 and abs(MouseY - y) < 3 then [inputLoop]

    'set up to begin moving the selected object
    print #form, "delsegment "; selectId - 1 ;
    print #form, "when leftButtonMove [additionalObjectMoves]" ;
    print #form, "when leftButtonUp [acceptMovement]" ;


[additionalObjectMoves]

    'adjust the position of the selected object, then draw an object frame the size of the
    'selected object at that new position using xor rule.  set event handling to manage
    'additional movements or termination of this object's movement.


    gosub [eraseObjectFrame]

    gosub [snapMouse]
    xOrg(index) = xOrg(index) + (MouseX - lastMouseX)
    yOrg(index) = yOrg(index) + (MouseY - lastMouseY)
    gosub [snapXY]
    lastMouseX = MouseX
    lastMouseY = MouseY

    print #form, "color black ; backcolor white ; size 1" ;
    print #form, "place "; xOrg(index); " "; yOrg(index) ;
    print #form, "down ; rule xor ; box "; xOrg(index)+width(index); " "; yOrg(index)+height(index) ;
    print #form, "rule over ; up ; flush" ;
    print #form, "segment" : input #form, id
    print #form, "delsegment "; id - 1 ;

    goto [inputLoop]


[eraseObjectFrame]

    'erase the object frame (for movement)
    print #form, "color black ; backcolor white ; size 1" ;
    print #form, "place "; xOrg(index); " "; yOrg(index) ;
    print #form, "down ; rule xor ; box "; xOrg(index)+width(index); " "; yOrg(index)+height(index) ;
    print #form, "rule over ; up ; flush" ;
    print #form, "segment" : input #form, id
    print #form, "delsegment "; id - 1 ;

    return


[acceptResizing]

    if width(index) < 25 then width(index) = 25
    if height(index) < 25 then height(index) = 25

    if type$(index) <> "windowframe" then [acceptMovement]
    if width(index) < 100 then width(index) = 100
    if height(index) < 50 then height(index) = 50
    windowXExtent = width(index)
    windowYExtent = height(index)


[acceptMovement]

    'end the movement phase, and redraw all objects
    print #form, "delsegment "; segment(index) - 1 ;
    gosub [redrawAll]
    'index = 0
    gosub [selectDeselect]
    firstObjectMove = false
    goto [setForSelection]


[resizeControl]

    'set up to begin resizing the selected object
    firstObjectMove = true
    print #form, "delsegment "; selectId - 1 ;
    print #form, "when leftButtonMove [additionalResizes]" ;
    print #form, "when leftButtonUp [acceptResizing]" ;
    gosub [snapMouse]
    lastMouseX = MouseX
    lastMouseY = MouseY

[additionalResizes]

    'adjust the position of the selected object, then draw an object frame the size of the
    'selected object at that new position using xor rule.  set event handling to manage
    'additional movements or termination of this object's movement.

    if firstObjectMove = false then gosub [eraseObjectFrame]

    gosub [snapMouse]
    width(index) = width(index) + (MouseX - lastMouseX)
    height(index) = height(index) + (MouseY - lastMouseY)
    gosub [snapWH]
    lastMouseX = MouseX
    lastMouseY = MouseY

    print #form, "color black ; backcolor white ; size 1" ;
    print #form, "place "; xOrg(index); " "; yOrg(index) ;
    print #form, "down ; rule xor ; box "; xOrg(index)+width(index); " "; yOrg(index)+height(index) ;
    print #form, "rule over ; up ; flush" ;
    print #form, "segment" : input #form, id
    print #form, "delsegment "; id - 1 ;

    goto [inputLoop]


[snapMouse]  'if snapOn is selected, then snap the mouse to grid

    if snapOn = 0 then return

    MouseX = int((MouseX + int(xInterval / 2)) / xInterval) * xInterval
    MouseY = int((MouseY + int(yInterval / 2)) / yInterval) * yInterval
    return


[snapWH]  'if snapOn is selected, then snap the width & height to grid

    if snapOn = 0 then return

    width(index) = int((width(index) + int(xInterval / 2)) / xInterval) * xInterval
    height(index) = int((height(index) + int(yInterval / 2)) / yInterval) * yInterval
    return


[snapXY]  'if snapOn is selected, then snap the x,y position to grid

    if snapOn = 0 then return

    xOrg(index) = int((xOrg(index) + int(xInterval / 2)) / xInterval) * xInterval
    yOrg(index) = int((yOrg(index) + int(yInterval / 2)) / yInterval) * yInterval
    return


[redrawAll]

    'redraw all controls
    isModified = 1  'the form has been modified
    print #form, "cls";
    index = 0
    gosub [renderWindow]
    if objectCount < 2 then return
    for idx = 1 to objectCount
        typeIdx$ = type$(idx)
        if typeIdx$ = "textbox" then gosub [renderTextBox] : goto [redrawNext]
        if typeIdx$ = "statictext" then gosub [renderStaticText] : goto [redrawNext]
        if typeIdx$ = "button" then gosub [renderButton] : goto [redrawNext]
        if typeIdx$ = "combobox" then gosub [renderComboBox] : goto [redrawNext]
        if typeIdx$ = "listbox" then gosub [renderListBox] : goto [redrawNext]
        if typeIdx$ = "bmpbutton" then gosub [renderBmpButton] : goto [redrawNext]
        if typeIdx$ = "radiobutton" then gosub [renderRadioButton] : goto [redrawNext]
        if typeIdx$ = "checkbox" then gosub [renderCheckBox] : goto [redrawNext]
        if typeIdx$ = "groupbox" then gosub [renderGroupBox]
      [redrawNext]
    next idx

    return

[moveToBack]

    'move the selected control to the back (first item drawn)
    if index < 2 or objectCount < 2 then [inputLoop]
    if index = 2 then gosub [redrawAll] : goto [inputLoop]

    tmpType$ = type$(index)
    tmpLabel$ = label$(index)
    tmpNames$ = names$(index)
    tmpXOrigin = xOrg(index)
    tmpYOrigin = yOrg(index)
    tmpWidth = width(index)
    tmpHeight = height(index)
    tmpCorner$ = corner$(index)
    tmpBranchLabel$ = branchLabel$(index)
    tmpSegment = segment(index)
    tmpHandle$ = handle$(index)
    tmpBmpName$ = bmpName$(index)

    for idx = index - 1 to 2 step -1
        type$(idx+1) = type$(idx)
        label$(idx+1) = label$(idx)
        names$(idx+1) = names$(idx)
        xOrg(idx+1) = xOrg(idx)
        yOrg(idx+1) = yOrg(idx)
        width(idx+1) = width(idx)
        height(idx+1) = height(idx)
        corner$(idx+1) = corner$(idx)
        branchLabel$(idx+1) = branchLabel$(idx)
        segment(idx+1) = segment(idx)
        handle$(idx+1) = handle$(idx)
        bmpName$(idx+1) = bmpName$(idx)
    next idx

    type$(2) = tmpType$
    label$(2) = tmpLabel$
    names$(2) = tmpNames$
    xOrg(2) = tmpXOrigin
    yOrg(2) = tmpYOrigin
    width(2) = tmpWidth
    height(2) = tmpHeight
    corner$(2) = tmpCorner$
    branchLabel$(2) = tmpBranchLabel$
    segment(2) = tmpSegment
    handle$(2) = tmpHandle$
    bmpName$(2) = tmpBmpName$

    gosub [redrawAll]
    index = 0 'necessary here

    goto [inputLoop]


[moveToFront]

    'move the selected control to the front (last item drawn)
    if index < 2 or objectCount < 2 then [inputLoop]
    if index = objectCount then gosub [redrawAll] : goto [inputLoop]

    tmpType$ = type$(index)
    tmpLabel$ = label$(index)
    tmpNames$ = names$(index)
    tmpXOrigin = xOrg(index)
    tmpYOrigin = yOrg(index)
    tmpWidth = width(index)
    tmpHeight = height(index)
    tmpCorner$ = corner$(index)
    tmpBranchLabel$ = branchLabel$(index)
    tmpSegment = segment(index)
    tmpHandle$ = handle$(index)
    tmpBmpName$ = bmpName$(index)

    for idx = index to objectCount - 1
        type$(idx) = type$(idx+1)
        label$(idx) = label$(idx+1)
        names$(idx) = names$(idx+1)
        xOrg(idx) = xOrg(idx+1)
        yOrg(idx) = yOrg(idx+1)
        width(idx) = width(idx+1)
        height(idx) = height(idx+1)
        corner$(idx) = corner$(idx+1)
        branchLabel$(idx) = branchLabel$(idx+1)
        segment(idx) = segment(idx+1)
        handle$(idx) = handle$(idx+1)
        bmpName$(idx) = bmpName$(idx+1)
    next idx

    type$(objectCount) = tmpType$
    label$(idx) = tmpLabel$
    names$(objectCount) = tmpNames$
    xOrg(objectCount) = tmpXOrigin
    yOrg(objectCount) = tmpYOrigin
    width(objectCount) = tmpWidth
    height(objectCount) = tmpHeight
    corner$(objectCount) = tmpCorner$
    branchLabel$(objectCount) = tmpBranchLabel$
    segment(objectCount) = tmpSegment
    handle$(objectCount) = tmpHandle$
    bmpName$(objectCount) = tmpBmpName$

    gosub [redrawAll]
    gosub [selectDeselect]

    goto [inputLoop]


[deleteControl]

    'delete the selected control
    if index < 2 then [inputLoop]

    'delete graphical segments and clean up display
    print #form, "delsegment "; selectId -1 ;
    gosub [selectDeselect]
    print #form, "delsegment "; selectId - 1 ;

    for idx = index to objectCount
        type$(idx) = type$(idx+1)
        label$(idx) = label$(idx+1)
        names$(idx) = names$(idx+1)
        xOrg(idx) = xOrg(idx+1)
        yOrg(idx) = yOrg(idx+1)
        width(idx) = width(idx+1)
        height(idx) = height(idx+1)
        corner$(idx) = corner$(idx+1)
        branchLabel$(idx) = branchLabel$(idx+1)
        segment(idx) = segment(idx+1)
        handle$(idx) = handle$(idx+1)
        bmpName$(idx) = bmpName$(idx+1)
        arrayName$(idx) = arrayName$(idx+1)
    next idx

    objectCount = objectCount - 1

    gosub [redrawAll]
    index = 0

    goto [inputLoop]


[produceCodeAndOutline]

    'set a flag so that an outline will be added
    produceOutline = 1

[produceCode]

    'produce code for the controls in the form
    if objectCount < 2 then notice "No objects.  Code not produced" : goto [inputLoop]

    if codeIsOpen = 1 then close #code

    open "Free Form output window" for text as #code
    codeIsOpen = 1



    print #code, ""
    print #code, ""
    print #code, "    WindowWidth = "; windowXExtent
    print #code, "    WindowHeight = "; windowYExtent
    print #code, ""

    for x = 2 to objectCount
        if type$(x) = "button" then gosub [codeForButton]
        if type$(x) = "combobox" then gosub [codeForComboBox]
        if type$(x) = "textbox" then gosub [codeForTextBox]
        if type$(x) = "listbox" then gosub [codeForListBox]
        if type$(x) = "bmpbutton" then gosub [codeForBmpButton]
        if type$(x) = "statictext" then gosub [codeForStaticText]
        if type$(x) = "radiobutton" then gosub [codeForRadioButton]
        if type$(x) = "checkbox" then gosub [codeForCheckBox]
        if type$(x) = "groupbox" then gosub [codeForGroupBox]
        print #code, code$
    next x

    if menuCount = 0 then [noMenuCode]

    if left$(windowType$, 6) = "dialog" then print #code, "    '*** menus are not supported in windows of type "; windowType$; " ***"

    for x = 0 to menuCount - 1
        print #code, "    menu "; winHandle$; ", "; qu$; menu$(x); qu$;
        if menuItemCount(x) = 0 then print #code, ", "; chr$(34); "&FixMe"; chr$(34); ", [fixMe]  ' <-- this menu has no items!" : goto [produceNextMenu]
        for y = 0 to menuItemCount(x) - 1
            print #code, ", ";
            mi$ = menuItem$(x, y)
            print #code, qu$; left$(mi$, instr(mi$, chr$(0)) - 1) ; qu$;
            print #code, ", "; mid$(mi$, instr(mi$, chr$(0)) + 1) ;
        next y
        print #code, ""
      [produceNextMenu]
    next x


[noMenuCode] 'don't produce menu code

    print #code, "    open "; qu$; windowLabel$; qu$; " for "; windowType$; " as "; winHandle$

    if produceOutline = 0 then [doneProducingCode]


[produceOutline]

    produceOutline = 0
    branchLabels$ = ""

    for x = 2 to objectCount
        if left$(trim$(branchLabel$(x)), 1) <> "[" then [nextOutlineObject]
        if instr(trim$(branchLabel$(x)), " ") > 0 then gosub [handleMultiBranchLabels] : goto [nextOutlineObject]
        if instr(branchLabels$, branchLabel$(x)) > 0 then [nextOutlineObject]
        branchLabels$ = branchLabels$ + " " + branchLabel$(x)
        print #code, ""
        print #code, ""
        print #code, branchLabel$(x); "   'Perform action for the "; type$(x); " named '"; names$(x); "'"
        print #code, ""
        print #code, "    'Insert your own code here"
      [nextOutlineObject]
    next x

    if menuCount = 0 then [doneProducingCode]

    for x = 0 to menuCount - 1
        for y = 0 to menuItemCount(x) - 1
            mi$ = menuItem$(x, y)
            bl$ = mid$(mi$, instr(mi$, chr$(0)) + 1)
            if instr(branchLabels$, bl$) > 0 then [writeNextMenuItem]
            branchLabels$ = branchLabels$ + " " + bl$
            print #code, ""
            print #code, ""
            print #code, bl$; "   'Perform action for menu "; menu$(x); ", item "; left$(mi$, instr(mi$, chr$(0)) - 1)
            print #code, ""
            print #code, "    'Insert your own code here"
          [writeNextMenuItem]
        next y
    next x


[doneProducingCode]

    notice "Done.  Copy this code into your program."

    goto [inputLoop]


[handleMultiBranchLabels]   'handle the case where a control has more than 1 branching option

    if instr(branchLabels$, word$(branchLabel$(x), 1)) > 0 then [nextMultiBranchLabel]
    print #code, ""
    print #code, ""
    print #code, word$(branchLabel$(x), 1); "   'Perform action for the "; type$(x); " named '"; names$(x); "'"
    print #code, ""
    print #code, "    'Insert your own code here"
    branchLabels$ = branchLabels$ + " " + word$(branchLabel$(x), 1)

  [nextMultiBranchLabel]

    if instr(branchLabels$, word$(branchLabel$(x), 2)) > 0 then [doneMultiBranchLabel]
    print #code, ""
    print #code, ""
    print #code, word$(branchLabel$(x), 2); "   'Perform action for the "; type$(x); " named '"; names$(x); "'"
    print #code, ""
    print #code, "    'Insert your own code here"
    branchLabels$ = branchLabels$ + " " + word$(branchLabel$(x), 2)

  [doneMultiBranchLabel]

    return


[codeForButton]

    'produce code for a text button
    code$ = "    button "+winHandle$+", "+qu$+label$(x)+qu$+", "+branchLabel$(x)+", "+corner$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)
    return


[codeForBmpButton]

    'produce code for a bmp button
    code$ = "    bmpbutton "+winHandle$+", "+qu$+bmpName$(x)+qu$+", "+branchLabel$(x)+", "+corner$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)
    return


[codeForTextBox]

    'produce code for a text box
    code$ = "    textbox "+winHandle$+"."+names$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return


[codeForStaticText]

    'produce code for a static text
    code$ = "    statictext "+winHandle$+"."+names$(x)+", "+qu$+label$(x)+qu$+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return


[codeForGroupBox]

    'produce code for a group box
    code$ = "    groupbox "+winHandle$+", "+qu$+label$(x)+qu$+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return


[codeForListBox]

    'produce code for a listbox
    code$ = "    listbox "+winHandle$+"."+names$(x)+", "+arrayName$(x)+", "+branchLabel$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return


[codeForComboBox]

    'produce code for a listbox
    code$ = "    combobox "+winHandle$+"."+names$(x)+", "+arrayName$(x)+", "+branchLabel$(x)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return


[codeForRadioButton]

    'produce code for a radiobutton
    code$ = "    radiobutton "+winHandle$+"."+names$(x)+", "+qu$+label$(x)+qu$+", "+word$(branchLabel$(x), 1)+", "+word$(branchLabel$(x), 2)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return


[codeForCheckBox]

    'produce code for a checkbox
    code$ = "    checkbox "+winHandle$+"."+names$(x)+", "+qu$+label$(x)+qu$+", "+word$(branchLabel$(x), 1)+", "+word$(branchLabel$(x), 2)+", "+str$(xOrg(x)-xOrg-4)+", "+str$(yOrg(x)-yOrg-20-4)+", "+str$(width(x))+", "+str$(height(x))
    return


[newFile]

    'clear the contents of the form editor and start over

    if isModified = 1 then gosub [formIsModified]

    newControlNumber = 0
    windowLabel$ = "untitled"
    windowType$ = "window"
    objectCount = 0
    winHandle$ = "#main"
    windowXExtent = 550
    windowYExtent = 410

    gosub [clearMenuData]
    gosub [addWindowFrame]
    gosub [redrawAll]

    isModified = 0

    goto [inputLoop]


[saveFile]

    'abort if no controls
    if objectCount < 2 then notice "No controls.  Save aborted" : goto [inputLoop]

    'save the form into a *.fre file
    if formName$ = "" then formName$ = "untitled.fre"
    filedialog "Save form", "*.fre", formName$
    if formName$ = "" then [inputLoop]

    gosub [saveFormSubroutine]

    notice "Done.  File saved as " + formName$
    goto [inputLoop]


[saveFormSubroutine]   'the subroutine portion of the save routine

    open formName$ for output as #formOut
    print #formOut, newControlNumber
    print #formOut, windowLabel$
    print #formOut, windowType$
    print #formOut, objectCount
    print #formOut, winHandle$
    print #formOut, snapOn
    print #formOut, xInterval
    print #formOut, yInterval
    print #formOut, menuCount
    print #formOut, windowXExtent
    print #formOut, windowYExtent

    for i = 2 to objectCount
        print #formOut, type$(i)
        print #formOut, label$(i)
        print #formOut, names$(i)
        print #formOut, xOrg(i)
        print #formOut, yOrg(i)
        print #formOut, width(i)
        print #formOut, height(i)
        print #formOut, corner$(i)
        print #formOut, branchLabel$(i)
        print #formOut, segment(i)
        print #formOut, handle$(i)
        print #formOut, bmpName$(i)
        print #formOut, arrayName$(i)
    next i

    'Now write the menu information
    if menuCount = 0 then [noMenusToSave]

    for i = 0 to menuCount - 1
        print #formOut, menu$(i)
        print #formOut, menuItemCount(i)
        if menuItemCount(i) = 0 then [noMenuItemsToSave]
        for j = 0 to menuItemCount(i) - 1
            print #formOut, menuItem$(i, j)
        next j
      [noMenuItemsToSave]
    next i


[noMenusToSave]

    close #formOut

    return


[openFile]

    'load the form from a *.fre file

    if isModified = 1 then gosub [formIsModified]

    filedialog "Load form", "*.fre", formName$
    if formName$ = "" then [inputLoop]

    gosub [clearMenuData]
    objectCount = 0
    gosub [addWindowFrame]

    open formName$ for input as #formIn
    input #formIn, newControlNumber
    input #formIn, windowLabel$
    input #formIn, windowType$
    input #formIn, objectCount
    input #formIn, winHandle$
    input #formIn, snapOn
    input #formIn, xInterval
    input #formIn, yInterval
    input #formIn, menuCount
    input #formIn, windowXExtent
    input #formIn, windowYExtent

    width(1) = windowXExtent
    height(1) = windowYExtent

    for i = 2 to objectCount
        input #formIn, tmp$ : type$(i) = tmp$
        input #formIn, tmp$ : label$(i) = tmp$
        input #formIn, tmp$ : names$(i) = tmp$
        input #formIn, tmp : xOrg(i) = tmp
        input #formIn, tmp : yOrg(i) = tmp
        input #formIn, tmp : width(i) = tmp
        input #formIn, tmp : height(i) = tmp
        input #formIn, tmp$ : corner$(i) = tmp$
        input #formIn, tmp$ : branchLabel$(i) = tmp$
        input #formIn, tmp : segment(i) = tmp
        input #formIn, tmp$ : handle$(i) = tmp$
        input #formIn, tmp$ : bmpName$(i) = tmp$
        if trim$(tmp$) > "" then loadbmp tmp$, tmp$
        input #formIn, tmp$ : arrayName$(i) = tmp$
    next i

    if menuCount = 0 then [noMenusToRead]

    for i = 0 to menuCount - 1
        input #formIn, tmp$ : menu$(i)=tmp$
        input #formIn, tmp : menuItemCount(i) = tmp
        if menuItemCount(i) = 0 then [noMenuItemsToRead]
        for j = 0 to menuItemCount(i) - 1
            input #formIn, tmp$ : menuItem$(i, j) = tmp$
        next j
      [noMenuItemsToRead]
    next i

[noMenusToRead]

    close #formIn
    gosub [redrawAll]

    isModified = 0

    goto [inputLoop]




[gridDialog]  'open a dialog box for selecting & adjusting snap to grid

    WindowWidth = 350
    WindowHeight = 225

    statictext #gridDialog.statictext2, "Select here whether control positions will", 26, 16, 336, 20
    statictext #gridDialog.statictext5, "automatically snap to gridded positions,", 26, 35, 320, 20
    statictext #gridDialog.statictext6, "and what the interval will be.", 26, 54, 240, 20
    checkbox #gridDialog.snapOnOff, "Snap to Grid", [snapOn], [snapOff], 26, 85, 120, 20
    statictext #gridDialog.statictext7, "X interval:", 34, 112, 70, 20
    textbox #gridDialog.xIntrvl, 111, 106, 38, 25
    statictext #gridDialog.statictext9, "Y interval:", 178, 112, 70, 20
    textbox #gridDialog.yIntrvl, 255, 106, 38, 25
    button #gridDialog, "OK", [acceptGridDialog], UL, 99, 149
    button #gridDialog, "Cancel", [cancelGridDialog], UL, 29, 149
    open "Snap to Grid" for dialog as #gridDialog
    print #gridDialog, "trapclose [cancelGridDialog]"

    if snapOn = 1 then snapOnSelected = 1 : print #gridDialog.snapOnOff, "set"
    print #gridDialog.xIntrvl, xInterval
    print #gridDialog.yIntrvl, yInterval

    goto [inputLoop]


[snapOn]   'Perform on action for the checkbox named 'snapOnOff'

    snapOnSelected = 1
    goto [inputLoop]


[snapOff]   'Perform off action for the checkbox named 'snapOnOff'

    snapOnSelected = 0
    goto [inputLoop]


[acceptGridDialog]

    snapOn = snapOnSelected
    print #gridDialog.xIntrvl, "!contents?"
    input #gridDialog.xIntrvl, xInterval
    print #gridDialog.yIntrvl, "!contents?"
    input #gridDialog.yIntrvl, yInterval


[cancelGridDialog]

    gridDialogIsOpen = 0
    close #gridDialog
    goto [inputLoop]


[addAMenu]    'add a new menu item


    WindowWidth = 400
    WindowHeight = 230
    listbox #newMenu.menuNames, menu$(, [inputLoop], 14, 36, 120, 120
    statictext #newMenu.statictext2, "Defined Menus", 14, 16, 104, 20
    statictext #newMenu.statictext3, "Enter new menu name here:", 150, 16, 200, 20
    textbox #newMenu.newMenuName, 150, 36, 208, 25
    button #newMenu, "Accept", [acceptNewMenu], UL, 302, 131
    button #newMenu, "Cancel", [cancelNewMenu], UL, 302, 101
    open "Add a Menu" for dialog as #newMenu
    print #newMenu, "trapclose [cancelNewMenu]";
    goto [inputLoop]


[cancelNewMenu]   'Perform action for the button named 'cancelNewMenu'

    'close the dialog box
    close #newMenu
    goto [inputLoop]


[clearMenuData]     'reset menu data arrays and indices

    for x = 0 to 20
        menu$(x) = ""
        for y = 0 to 30
            menuItem$(x, y) = ""
        next y
    next x
    menuCount = 0
    return


[acceptNewMenu]   'Perform action for the button named 'acceptNewMenu'

    'add this menu onto the list of menus, and update the display as needed
    print #newMenu.newMenuName, "!contents?";
    input #newMenu.newMenuName, result$
    if result$ = "" then notice "Please type a name for a new menu." : goto [inputLoop]
    close #newMenu
    menu$(menuCount) = result$
    menuCount = menuCount + 1
    if menuCount > 1 then gosub [redrawAll] : goto [inputLoop]

    'since this is the first menu added, reposition all controls 20 pixels down
    if objectCount < 2 then gosub [redrawAll] : goto [inputLoop]
    for x = 2 to objectCount
        yOrg(x) = yOrg(x) + 20
    next x
    gosub [redrawAll]
    goto [inputLoop]



[removeMenu]   'remove a menu from the list of menus

    if menuCount = 0 then notice "No menus to remove." : goto [inputLoop]

    WindowWidth = 330
    WindowHeight = 195
    statictext #removeMenu.statictext1, "Select a menu to remove:", 26, 16, 192, 20
    listbox #removeMenu.menusToRemove, menu$(, [acceptRemoveMenu], 22, 41, 208, 100
    button #removeMenu, "Accept", [acceptRemoveMenu], UL, 246, 81
    button #removeMenu, "Cancel", [cancelRemoveMenu], UL, 246, 111
    open "Remove a Menu" for dialog as #removeMenu
    print #removeMenu, "trapclose [cancelRemoveMenu]";

    goto [inputLoop]


[acceptRemoveMenu]   'get the name of the selected item, and remove it

    print #removeMenu.menusToRemove, "selectionIndex?"
    input #removeMenu.menusToRemove, result
    close #removeMenu
    if result = 0 then notice "No item selected.  Menu not removed." : goto [inputLoop]

    menuCount = menuCount - 1
    result = result - 1

    if result = menuCount then menu$(result) = "" : goto [checkForEmptyMenuBar]

    for x = result to menuCount
        menu$(x) = menu$(x+1)
    next x

  [checkForEmptyMenuBar]  'if there are no more menus, shift controls up 20 pixels

    if menuCount > 0 then gosub [redrawAll] : goto [inputLoop]

    for x = 2 to objectCount
        yOrg(x) = yOrg(x) - 20
    next x

    gosub [redrawAll]

    goto [inputLoop]


[cancelRemoveMenu]   'close the remove menu dialog

    close #removeMenu
    goto [inputLoop]


[editMenus]     'edit menu order and menu contents

    if menuCount = 0 then notice "No menus to edit." : goto [inputLoop]

    WindowWidth = 450
    WindowHeight = 375

    listbox #editMenu.menuList, menu$(, [selectMenuToEdit], 14, 31, 112, 105
    listbox #editMenu.menuItems, menuItemLocal$(, [selectMenuItemToEdit], 14, 166, 288, 145
    statictext #editMenu.statictext6, "Menus:", 14, 11, 48, 20
    statictext #editMenu.statictext14, "Menu line items -> Branch labels:", 14, 146, 240, 20
    button #editMenu, "&Close", [closeMenuEdit], UL, 326, 21
    button #editMenu, "&New Item", [addNewMenuItem], UL, 310, 166
    button #editMenu, "&Edit", [editMenuItem], UL, 310, 196
    button #editMenu, "Move &Up", [moveMenuItemUp], UL, 310, 226
    button #editMenu, "&Move Dn", [moveMenuItemDown], UL, 310, 256
    button #editMenu, "&Delete", [deleteMenuItem], UL, 310, 286
    button #editMenu, "&To Top", [moveMenuToTop], UL, 134, 41
    open "Edit Menus" for dialog as #editMenu
    print #editMenu, "trapclose [closeMenuEdit]";
    print #editMenu.menuList, "singleclickselect";
    print #editMenu.menuItems, "singleclickselect";

    menuItemIndex = 0
    result = 0

    goto [inputLoop]


[selectMenuToEdit]   'Perform action for the listbox named 'menuList'

    'populate the listbox named menuItems
    print #editMenu.menuList, "selectionIndex?"
    input #editMenu.menuList, result

    for x = 0 to 29
        mil$ = menuItem$(result - 1, x)
        if mil$ <> "" then mil$ = left$(mil$, instr(mil$, chr$(0)) - 1) + " -> " + mid$(mil$, instr(mil$, chr$(0)) + 1)
        menuItemLocal$(x) = mil$
    next x
    print #editMenu.menuItems, "reload"

    menuItemIndex = 0

    goto [inputLoop]


[moveMenuToTop]   'move the selected menu to the top of the list

    'if there is no selection, or if the selected item is already on top, do nothing
    if result = 0 or result = 1 then [inputLoop]

    menu$(20) = menu$(result - 1)
    for x = 0 to 29
        menuItem$(20, x) = menuItem$(result - 1, x)
    next x

    for x = result - 1 to 1 step -1
        menu$(x) = menu$(x - 1)
        for y = 0 to 29
            menuItem$(x, y) = menuItem$(x - 1, y)
        next y
    next x

    menu$(0) = menu$(20)
    menu$(20) = ""
    for x = 0 to 29
        menuItem$(0, x) = menuItem$(20, x)
        menuItem$(20, x) = ""
    next x

    print #editMenu.menuList, "reload"
    print #editMenu.menuList, "selectIndex 1"
    result = 1

    'now continue on to the next routine!


[selectMenuItemToEdit]   'Perform action for the listbox named 'menuItems'

    'set the selection index for the menu item to edit
    print #editMenu.menuItems, "selectionIndex?"
    input #editMenu.menuItems, menuItemIndex
    goto [inputLoop]


[addNewMenuItem]   'Perform action for the button named 'newItemButton'

    'Insert your own code here
    if result = 0 then [inputLoop]
    menuItemCount(result - 1) = menuItemCount(result - 1) + 1
    menuItemIndex = menuItemCount(result - 1)
    editMenuItemAction$ = "ADD"
    goto [editMenuItemProperties]


[editMenuItem]   'Perform action for the button named 'editMenuItem'

    'Insert your own code here
    if menuItemIndex = 0 then [inputLoop]
    editMenuItemAction$ = "EDIT"
    goto [editMenuItemProperties]


[moveMenuItemUp]   'Perform action for the button named 'moveMenuItemUp'

    'Insert your own code here
    if menuItemIndex = 1 or menuItemIndex = 0 then [inputLoop]

    tmpMi$ = menuItem$(result - 1, menuItemIndex - 1)
    menuItem$(result - 1, menuItemIndex - 1) = menuItem$(result - 1, menuItemIndex - 2)
    menuItem$(result - 1, menuItemIndex - 2) = tmpMi$

    gosub [reloadLocalMenuItems]

    menuItemIndex = menuItemIndex - 1
    print #editMenu.menuItems, "selectIndex "; menuItemIndex

    goto [inputLoop]


[moveMenuItemDown]   'Perform action for the button named 'moveMenuItemDown'

    'Insert your own code here
    if result = 0 then [inputLoop]
    if menuItemIndex = menuItemCount(result - 1) or menuItemIndex = 0 then [inputLoop]

    tmpMi$ = menuItem$(result - 1, menuItemIndex - 1)
    menuItem$(result - 1, menuItemIndex - 1) = menuItem$(result - 1, menuItemIndex)
    menuItem$(result - 1, menuItemIndex) = tmpMi$

    gosub [reloadLocalMenuItems]

    menuItemIndex = menuItemIndex + 1
    print #editMenu.menuItems, "selectIndex "; menuItemIndex

    goto [inputLoop]


[deleteMenuItem]   'Perform action for the button named 'deleteMenuItem'

    'Insert your own code here
    if result = 0 then [inputLoop]
    if menuItemCount(result - 1) = 0 or menuItemIndex = 0 then [inputLoop]

    for x = menuItemIndex to 30
        menuItem$(result - 1, x - 1) = menuItem$(result - 1, x)
    next x

    gosub [reloadLocalMenuItems]

    menuItemIndex = 0

    return


[reloadLocalMenuItems]  'reload the contents of the menu items listbox

    for x = 0 to 29
        mil$ = menuItem$(result - 1, x)
        if mil$ <> "" then mil$ = left$(mil$, instr(mil$, chr$(0)) - 1) + " -> " + mid$(mil$, instr(mil$, chr$(0)) + 1)
        menuItemLocal$(x) = mil$
    next x
    print #editMenu.menuItems, "reload"

    return


[closeMenuEdit]   'Perform action for the button named 'closeMenuEdit'

    'close the menu editing dialog and redraw the form
    for x = 0 to 29 : menuItemLocal$(x) = "" : next x
    close #editMenu
    'gosub [redrawAll]

    goto [inputLoop]


[editMenuItemProperties]    'open a dialog for editing menu item properties

    WindowWidth = 350
    WindowHeight = 150

    textbox #menuItems.name, 134, 16, 184, 25
    textbox #menuItems.branchLabel, 134, 51, 184, 25
    statictext #menuItems.statictext6, "Name:", 22, 21, 40, 20
    statictext #menuItems.statictext7, "Branch Label:", 22, 56, 104, 20
    button #menuItems, "Accept", [acceptMenuItemProps], UL, 198, 86
    button #menuItems, "Cancel", [cancelMenuItemProps], UL, 262, 86
    open "Menu Item Properties" for dialog as #menuItems

    print #menuItems.name, "???"
    print #menuItems.branchLabel, "[???]"

    if menuItem$(result - 1, menuItemIndex - 1) = "" then [inputLoop]

    mi$ = menuItem$(result - 1, menuItemIndex - 1)
    print #menuItems.name, left$(mi$, instr(mi$, chr$(0)) - 1)
    print #menuItems.branchLabel, mid$(mi$, instr(mi$, chr$(0)) + 1)

    goto [inputLoop]


[acceptMenuItemProps]   'Perform action for the button named 'acceptMenuItemProps'

    'accept the edited menu item
    print #menuItems.name, "!contents?";
    input #menuItems.name, nResult$
    print #menuItems.branchLabel, "!contents?";
    input #menuItems.branchLabel, blResult$

    if nResult$ = "" or blResult$ = "" then notice "Bad menu item properties." : goto [inputLoop]

    blr$ = blResult$
    if left$(blResult$, 1) <> "[" then blResult$ = "[" + blResult$
    if right$(blResult$, 1) <> "]" then blResult$ = blResult$ + "]"

    if blr$ <> blResult$ then notice "Branch Label was " + blr$ + ", defaulting to " + blResult$

    menuItem$(result - 1, menuItemIndex - 1) = nResult$ + chr$(0) + blResult$
    menuItemLocal$(menuItemIndex - 1) = nResult$ + " -> " + blResult$

    close #menuItems

    print #editMenu.menuItems, "reload"

    goto [inputLoop]


[cancelMenuItemProps]   'Perform action for the button named 'cancelMenuItemProps'

    'close the window
    close #menuItems

    if editMenuItemAction$ = "ADD" then menuItemCount(result - 1) = menuItemCount(result - 1) - 1

    goto [inputLoop]


[formIsModified]    'the form has been modified, offer to save

	if objectCount < 2 then isModified = 0 : return  ' can't save form, no objects
    confirm "Save changes to " + formName$ + "?"; answer$
    if answer$ = "yes" then gosub [saveFormSubroutine]
    isModified = 0

    return


[quit]   'exit Freeform

    if isModified = 1 then gosub [formIsModified]

    'quit freeform
    close #form
    if codeIsOpen then close #code

end
