#include "threadtemp.h"



ULONG Thread::DefaultStackSize=8*1024;


void Thread::SetDefaultStackSize(ULONG x){
   DefaultStackSize=x;
}


Thread::Thread(ULONG StackS){
	StackSize=StackS;
	Started=0;
	Suspended=0;
	Running=0;
}

void Thread::Start(){
	#if defined __BORLANDC__ || defined __HIGHC__
		tid=_beginthread(&ThreadStarter,StackSize,this);
	#else
		tid=_beginthread(&ThreadStarter,0,StackSize,this);
	#endif

	if (tid) Started=1;
}

void ThreadStarter(void * Arg){
	Thread *CL=(Thread *) Arg;
	CL->Running=1;
	(CL->Run)();
	CL->Running=0;
	_endthread();
}


void Thread::SuspendThread(){
	if (Started){
		Error=DosSuspendThread(tid);
		if(!Error) Suspended=1;
	}
}

void Thread::KillThread(){
	if (Started){
		Error=DosKillThread(tid);
		if(!Error) Started=Suspended=0;
	}
}

void Thread::ResumeThread(){
	if(Suspended){
		Error=DosResumeThread(tid);
		if(!Error) Suspended=1;
	}
}

void Thread::ChangePR(ULONG Class,LONG Delta){
   Error=DosSetPriority(PRTYS_THREAD,Class,Delta,tid);
}
