/* REXX */

"@echo off"

/* Set the local environment */
a = setlocal()

call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysSetObjectData', 'RexxUtil', 'SysSetObjectData'

/* This is the command-line we'll be applying */
Parse arg arg1 arg2 args

if arg1 = "-q" then
        quiet = "T"
else
        do
                quiet = "F"
                Parse arg arg2 args
        end

if arg2 = "" then do
        say "sweepfolder - set a WPS attribute on the current folder and all subfolders"
        say
        say "sweepfolder [-q] attrstring"
        say "-q will tell sweepfolder not to output anything"
        say "attrstring is a WinSetObjectData attribute string."
        say
        say "All attributes that work on WP_Folder objects will work."
        say "Some common ones are:"
        say "    ALWAYSSORT={YES|NO}"
        say "    DEFAULTVIEW={ICON|TREE|DETAILS|}"
        say "    OPEN={ICON|TREE|DETAILS}"
        say "See the Workplace Shell Programming Reference for more info"
        exit
        end

/* Do it in the current directory first */
if quiet = "F" then
        say 'SysSetObjectData("'directory()'", "'arg2'")'
rc = SysSetObjectData(directory(), arg2)

/* Now, enumerate the subdirectories and do it to all of them */

/* Get the directory tree */
call SysFileTree '*', 'dirs', 'SDO'

/* Loop through the array, change to each directory, and execute args there */
do i=1 to dirs.0
        if quiet = "F" then
                say 'SysSetObjectData("'dirs.i'", "'arg2'")'
        rc = SysSetObjectData(dirs.i, arg2)

end

/* Restore the local environment */
a = endlocal()
